/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler.impl.jobs;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.GlobalVarI;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.scheduler.impl.jobs.Messages;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class RemoteDeliveryExecutionJob
implements StatefulJob {
    public static final String DELIVERY_NAME = "deliveryName";
    public static final String DELIVERY_PATH = "deliveryPath";
    public static final String DELIVERY_SESSION_NAME = "deliverySessionName";
    public static final String DELIVERY_PARAM = "deliveryParam";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String jobName = null;
        Logger logger = LogManager.getLogger((String)"org.quartz");
        try {
            String httpHost;
            jobName = context.getJobDetail().getKey().getName();
            logger.info(String.valueOf(Messages.getString("RemoteDeliveryExecutionJob.0")) + jobName + Messages.getString("RemoteDeliveryExecutionJob.1"));
            JobDataMap data = context.getJobDetail().getJobDataMap();
            String triggerName = context.getTrigger().getKey().getName();
            HashMap<String, String> parameters = (HashMap<String, String>)data.get((Object)triggerName);
            if (parameters == null) {
                parameters = new HashMap<String, String>();
            }
            boolean local = true;
            String deliveryName = (String)parameters.get(DELIVERY_NAME);
            if (deliveryName == null) {
                deliveryName = data.getString(DELIVERY_NAME);
            }
            if ((httpHost = (String)parameters.get("httpHost")) == null) {
                httpHost = GlobalVarI.currentHTTPHost;
            } else {
                local = false;
            }
            Integer httpPort = null;
            Object _httpPort = parameters.get("httpPort");
            if (_httpPort instanceof Integer) {
                httpPort = (Integer)_httpPort;
            } else if (_httpPort instanceof String) {
                httpPort = Integer.valueOf((String)_httpPort);
            }
            if (httpPort == null) {
                httpPort = GlobalVarI.currentHTTPPort;
            } else {
                local = false;
            }
            IEngineClient engineServer = null;
            if (local) {
                ServiceLoader<IEngineClient> serviceLoader = ServiceLoader.load(IEngineClient.class);
                Iterator<IEngineClient> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    IEngineClient _local;
                    engineServer = _local = iterator.next();
                }
                if (engineServer == null) {
                    throw new RuntimeException(Messages.getString("RemoteDeliveryExecutionJob.2"));
                }
            } else {
                LocalSession ec = null;
                ec = EngineFactory.connectionExists((String)httpHost) ? EngineFactory.connectTo((String)httpHost, null) : EngineFactory.getEngine((String)httpHost, (int)httpPort, (Map)Collections.EMPTY_MAP);
                engineServer = ec.getRemoteObject();
            }
            parameters.put("launchMode", "SCHEDULE");
            parameters.put("executionMode", "MEMORY");
            InetAddress localaddr = InetAddress.getLocalHost();
            String guestHost = localaddr.getHostName();
            parameters.put("guestHost", guestHost);
            String sessionId = engineServer.executeDelivery(deliveryName, parameters);
            if (!sessionId.equals("-1")) {
                boolean toExit = false;
                while (engineServer.isRunningSession(sessionId) && !toExit) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        toExit = true;
                    }
                }
            }
            logger.info(String.valueOf(Messages.getString("RemoteDeliveryExecutionJob.3")) + jobName + Messages.getString("RemoteDeliveryExecutionJob.4"));
        }
        catch (Exception e) {
            logger.error(String.valueOf(Messages.getString("RemoteDeliveryExecutionJob.5")) + jobName + Messages.getString("RemoteDeliveryExecutionJob.6"), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

