/*
 * Decompiled with CFR 0.152.
 */
package com.indy.a.encryptors;

import com.indy.a.encryptors.FileEncryptor;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SymetricEncryptor
extends FileEncryptor {
    private SecretKey key;
    private String algorithm;
    public static final String AES = "AES";
    public static final String DES = "DES";
    public static final String DES_EDE = "DESede";
    public static final String BLOWFISH = "Blowfish";
    public static final String RC2 = "RC2";
    public static final String ARCFOUR = "RC4";

    public SymetricEncryptor(SecretKey key) {
        this.key = key;
        this.algorithm = key.getAlgorithm();
    }

    public SymetricEncryptor(String keyFileName) throws OtherExceptionI {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyFileName));
            this.key = (SecretKey)in.readObject();
            this.algorithm = this.key.getAlgorithm();
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public SymetricEncryptor(File keyFile) throws OtherExceptionI {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(keyFile));
            this.key = (SecretKey)in.readObject();
            this.algorithm = this.key.getAlgorithm();
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public SymetricEncryptor(InputStream fis) throws OtherExceptionI {
        try {
            ObjectInputStream in = new ObjectInputStream(fis);
            this.key = (SecretKey)in.readObject();
            this.algorithm = this.key.getAlgorithm();
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public SymetricEncryptor(FileInputStream fis) throws OtherExceptionI {
        try {
            ObjectInputStream in = new ObjectInputStream(fis);
            this.key = (SecretKey)in.readObject();
            this.algorithm = this.key.getAlgorithm();
            in.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public SecretKey getSecretKey() {
        return this.key;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static SymetricEncryptor getInstance(String algorithm) throws OtherExceptionI {
        return new SymetricEncryptor(SymetricEncryptor.generateKey(algorithm));
    }

    public static SymetricEncryptor getInstance(String algorithm, String provider) throws OtherExceptionI {
        return new SymetricEncryptor(SymetricEncryptor.generateKey(algorithm, provider));
    }

    public static SymetricEncryptor getInstance(String algorithm, Provider provider) throws OtherExceptionI {
        return new SymetricEncryptor(SymetricEncryptor.generateKey(algorithm, provider));
    }

    public static SecretKey generateKey(String algorithm) throws OtherExceptionI {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            SecureRandom random = new SecureRandom();
            keygen.init(random);
            SecretKey key = keygen.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static SecretKey generateKey(String algorithm, String provider) throws OtherExceptionI {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm, provider);
            SecureRandom random = new SecureRandom();
            keygen.init(random);
            SecretKey key = keygen.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static SecretKey generateKey(String algorithm, Provider provider) throws OtherExceptionI {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm, provider);
            SecureRandom random = new SecureRandom();
            keygen.init(random);
            SecretKey key = keygen.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, String outputFileName) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFileName));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, String provider, String outputFileName) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm, provider);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFileName));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, Provider provider, String outputFileName) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm, provider);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFileName));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, File outputFile) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, String provider, File outputFile) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm, provider);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    public static void generateAndSaveKey(String algorithm, Provider provider, File outputFile) throws OtherExceptionI {
        SecretKey key = SymetricEncryptor.generateKey(algorithm, provider);
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(key);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    @Override
    public void encryptStream(InputStream in, OutputStream out) throws OtherExceptionI {
        Cipher cipher = null;
        try {
            cipher = this.blockCipherModeOperation != null ? Cipher.getInstance(String.valueOf(this.algorithm) + "/" + this.blockCipherModeOperation) : Cipher.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        try {
            if (this.blockCipherModeOperation != null && (this.blockCipherModeOperation.contains("CBC") || this.blockCipherModeOperation.contains("OFB") || this.blockCipherModeOperation.contains("CTR"))) {
                SecureRandom random = new SecureRandom();
                byte[] bytes = new byte[cipher.getBlockSize()];
                random.nextBytes(bytes);
                cipher.init(1, (Key)this.key, new IvParameterSpec(bytes));
                out.write(bytes);
            } else {
                cipher.init(1, this.key);
            }
        }
        catch (Exception e) {
            throw new OtherExceptionI(e.getMessage());
        }
        super.crypt(in, out, cipher);
        try {
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    @Override
    public void encryptStreamNC(InputStream in, OutputStream out) throws OtherExceptionI {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        try {
            cipher.init(1, this.key);
        }
        catch (InvalidKeyException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        super.crypt(in, out, cipher);
    }

    @Override
    public void decryptStream(InputStream in, OutputStream out) throws OtherExceptionI {
        Cipher cipher = null;
        try {
            cipher = this.blockCipherModeOperation != null ? Cipher.getInstance(String.valueOf(this.algorithm) + "/" + this.blockCipherModeOperation) : Cipher.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.blockCipherModeOperation != null && (this.blockCipherModeOperation.contains("CBC") || this.blockCipherModeOperation.contains("OFB") || this.blockCipherModeOperation.contains("CTR"))) {
                byte[] theIV = new byte[cipher.getBlockSize()];
                in.read(theIV);
                IvParameterSpec ivSpec = new IvParameterSpec(theIV);
                cipher.init(2, (Key)this.key, ivSpec);
            } else {
                cipher.init(2, this.key);
            }
        }
        catch (Exception e) {
            throw new OtherExceptionI(e.getMessage());
        }
        super.crypt(in, out, cipher);
        try {
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new OtherExceptionI(e.getMessage());
        }
    }

    @Override
    public void decryptStreamNC(InputStream in, OutputStream out) throws OtherExceptionI {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
        try {
            cipher.init(2, this.key);
        }
        catch (InvalidKeyException e) {
            throw new OtherExceptionI(e.getMessage());
        }
        super.crypt(in, out, cipher);
    }
}

