/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.client;

import com.indy.engine.common.client.Messages;
import com.indy.engine.core.common.LocalSession;
import com.semarchy.xdi.engine.common.CommonUtils;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlRootElement(name="client")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClientConfiguration {
    public static final Logger logger = LogManager.getLogger((String)"com.indy.engine");
    @XmlAttribute(name="connectionTimeout")
    private int connectionTimeOut = -1;
    @XmlElement(name="connection")
    private List<Connection> connections;
    Map<String, Connection> connectionMap = null;
    boolean init = false;

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException, InterruptedException, Exception {
        FileInputStream fis = new FileInputStream("D:\\work\\stambiaRuntime\\properties\\engines\\ClientConf.xml");
        ClientConfiguration cc = ClientConfiguration.getClientConfiguration(fis);
        while (true) {
            LocalSession engine = cc.connectTo("sharedConnection", null);
            Thread.sleep(10L);
        }
    }

    public static ClientConfiguration getClientConfiguration(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        return (ClientConfiguration)JAXB.unmarshal((InputStream)is, ClientConfiguration.class);
    }

    public static ClientConfiguration getClientConfiguration(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (ClientConfiguration)JAXB.unmarshal((Reader)isr, ClientConfiguration.class);
    }

    public Connection getConnection(String name) {
        this.init();
        return this.connectionMap.get(name);
    }

    private void init() {
        if (!this.init) {
            this.connectionMap = new HashMap<String, Connection>();
            for (Connection conn : this.connections) {
                this.connectionMap.put(conn.getName(), conn);
                conn.init();
            }
            this.init = true;
        }
    }

    public LocalSession connectTo(String name, ConnectionListener listener) throws Exception {
        Connection connection = this.getConnection(name);
        if (connection == null) {
            throw new Exception(String.valueOf(Messages.getString("ClientConfiguration.0")) + name + "\"");
        }
        Priority p = connection.getFirstPriority();
        int retry = 0;
        Exception firstException = null;
        while (true) {
            Runtime rt = p.elect();
            try {
                if (listener != null) {
                    listener.connecting(p.number, retry, rt.getHost(), rt.getPort(), null);
                }
                LocalSession ec = EngineFactory.getEngine(rt.getHost(), rt.getPort(), rt.getCredentials());
                if (listener != null) {
                    listener.connected(p.number, retry, rt.getHost(), rt.getPort(), null);
                }
                return ec;
            }
            catch (Exception re) {
                logger.warn("An exception occured : ", (Throwable)re);
                if (listener != null) {
                    listener.fail(p.number, retry, rt.getHost(), rt.getPort(), null);
                }
                if (firstException == null) {
                    firstException = re;
                }
                if ((p = p.next) != null || retry++ >= connection.getRetry()) continue;
                p = connection.getFirstPriority();
                Thread.sleep(connection.delay);
                if (p != null) continue;
                throw new Exception(String.valueOf(Messages.getString("ClientConfiguration.1")) + firstException + Messages.getString("ClientConfiguration.2"));
            }
            break;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Connection {
        @XmlAttribute(name="name", required=true)
        private String name;
        @XmlAttribute(name="retry", required=false)
        private int retry;
        @XmlAttribute(name="delay", required=false)
        private int delay;
        @XmlTransient
        ElectStrategy strategy = new RandomStrategy();
        @XmlElement(name="runtime")
        private List<Runtime> runtimes;
        @XmlElement(name="property")
        private List<Property> properties;
        Priority priority;
        boolean init = false;
        Map<String, String> mapProperties = new HashMap<String, String>();

        public String getName() {
            return this.name;
        }

        public int getRetry() {
            return this.retry;
        }

        public int getDelay() {
            return this.delay;
        }

        Priority getFirstPriority() {
            return this.priority;
        }

        public void init() {
            if (!this.init) {
                String lbStrat;
                this.priority = new Priority();
                this.priority.connection = this;
                for (Runtime r : this.runtimes) {
                    r.init();
                    Priority current = this.priority.search(r.priority);
                    current.runtimes.add(r);
                }
                this.priority = this.priority.next;
                this.init = true;
                if (this.properties != null) {
                    for (Property prop : this.properties) {
                        this.mapProperties.put(prop.name, prop.value);
                    }
                }
                if ((lbStrat = this.mapProperties.get("loadBalancing.strategy")) != null) {
                    try {
                        LbStrategies ls = LbStrategies.valueOf(lbStrat);
                        if (ls == LbStrategies.random) {
                            this.strategy = new RandomStrategy();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("An exception occured : ", (Throwable)e);
                    }
                }
            }
        }
    }

    public static interface ConnectionListener {
        public void connecting(int var1, int var2, String var3, int var4, String var5);

        public void connected(int var1, int var2, String var3, int var4, String var5);

        public void fail(int var1, int var2, String var3, int var4, String var5);
    }

    static interface ElectStrategy {
        public Runtime elect(Priority var1);
    }

    static class FirstStrategy
    implements ElectStrategy {
        FirstStrategy() {
        }

        @Override
        public Runtime elect(Priority priority) {
            if (priority.runtimes.size() > 0) {
                return priority.runtimes.get(0);
            }
            return null;
        }
    }

    static enum LbStrategies {
        random;

    }

    static class Priority {
        Priority previous;
        Connection connection;
        int number = Integer.MIN_VALUE;
        Priority next;
        List<Runtime> runtimes = new ArrayList<Runtime>();

        Priority() {
        }

        public Runtime elect() {
            return this.connection.strategy.elect(this);
        }

        public List<Runtime> getRuntimes() {
            return this.runtimes;
        }

        Priority search(int number) {
            if (this.number == number) {
                return this;
            }
            if (this.number < number) {
                if (this.next == null) {
                    this.next = new Priority();
                    this.next.connection = this.connection;
                    this.next.number = number;
                } else if (this.next.number > number) {
                    Priority p = this.next;
                    this.next = new Priority();
                    this.next.connection = this.connection;
                    this.next.number = number;
                    this.next.next = p;
                }
                return this.next.search(number);
            }
            if (this.previous == null) {
                this.previous = new Priority();
                this.previous.connection = this.connection;
                this.previous.number = number;
            } else if (this.previous.number < number) {
                Priority p = this.previous;
                this.previous = new Priority();
                this.previous.connection = this.connection;
                this.previous.number = number;
                this.previous.previous = p;
            }
            return this.previous.search(number);
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Property {
        @XmlAttribute(name="name", required=true)
        private String name;
        @XmlAttribute(name="value", required=true)
        private String value;
    }

    static class RandomStrategy
    implements ElectStrategy {
        RandomStrategy() {
        }

        @Override
        public Runtime elect(Priority priority) {
            if (priority.runtimes.size() > 0) {
                int i = new Random().nextInt(priority.runtimes.size());
                return priority.runtimes.get(i);
            }
            return null;
        }
    }

    static class RoundRobinStrategy
    implements ElectStrategy {
        int index = -1;

        RoundRobinStrategy() {
        }

        @Override
        public Runtime elect(Priority priority) {
            if (priority.runtimes.size() > 0) {
                if (++this.index >= priority.runtimes.size()) {
                    this.index = 0;
                }
                return priority.runtimes.get(this.index);
            }
            return null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Runtime {
        @XmlAttribute(name="host", required=true)
        private String host;
        boolean init = false;
        @XmlAttribute(name="port", required=false)
        private int port = 42000;
        @XmlAttribute(name="priority", required=false)
        private int priority = 0;
        @XmlAttribute(name="user", required=false)
        private String user;
        @XmlAttribute(name="uncryptedPassword", required=false)
        private String uncryptedPassword;
        @XmlAttribute(name="password", required=false)
        private String encryptedPassword;
        Map<String, String> credentials = new HashMap<String, String>();

        public String getHost() {
            return this.host;
        }

        public void init() {
            if (!this.init) {
                if (this.user != null) {
                    this.credentials.put("user", this.user);
                }
                if (this.encryptedPassword != null) {
                    this.credentials.put("password", this.encryptedPassword);
                }
                if (this.uncryptedPassword != null) {
                    this.credentials.put("uncryptedPassword", this.uncryptedPassword);
                }
                this.init = true;
            }
        }

        public int getPort() {
            return this.port;
        }

        public String getPassword() {
            return this.encryptedPassword;
        }

        public Map<String, String> getCredentials() {
            return this.credentials;
        }
    }
}

