/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.client.rest;

import com.indy.runtime.json.JsonUtils;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonDecoder
implements Decoder {
    private static final List<String> PRIMITIVES = new ArrayList<String>();

    static {
        Class[] classArray = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Long.TYPE};
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            PRIMITIVES.add(c.getName());
            ++n2;
        }
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.body() == null) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("PARSE_BSON_DATATYPE", true);
        map.put("INTEGER_AS_INTEGER_OR_LONG", true);
        String typeName = type.getTypeName();
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            typeName = t.getActualTypeArguments()[0].getTypeName();
        }
        Object rtn = null;
        try {
            rtn = JsonUtils.jsonNodeToObject((InputStream)response.body().asInputStream(), (String)"UTF-8", map);
            if (PRIMITIVES.contains(typeName)) {
                return rtn;
            }
            if (rtn instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object p : (List)rtn) {
                    Object o = JsonUtils.createObjectWithAnnotation(p, Class.forName(typeName));
                    list.add(o);
                }
                return list;
            }
            return JsonUtils.createObjectWithAnnotation((Object)rtn, Class.forName(typeName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return rtn;
        }
    }

    public Object generateObjectFromMap(Class clazz, Map<String, Object> fields) throws InstantiationException, IllegalAccessException {
        Object o = clazz.newInstance();
        for (String key : fields.keySet()) {
            try {
                Field f = clazz.getDeclaredField(key);
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                Object extractedField = fields.get(key);
                if (f.getType().isAssignableFrom(extractedField.getClass())) {
                    f.set(o, extractedField);
                } else if (Map.class.isAssignableFrom(extractedField.getClass())) {
                    extractedField = this.generateObjectFromMap(f.getType(), (Map)extractedField);
                    f.set(o, extractedField);
                }
                f.setAccessible(accessible);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return o;
    }
}

