/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.command.parser;

import com.indy.engine.common.command.parser.CommandParameterI;
import com.indy.engine.common.command.parser.CommandParserExceptionI;
import com.indy.engine.common.command.parser.ICommandExecutorI;
import com.indy.engine.common.command.parser.Messages;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandI
implements Comparable<CommandI> {
    static final String paramPattern = "<[^\\s]*>";
    static final String spacesPattern = "[ \\t]";
    static final String optionOrNotParamPattern = "(<[^\\s]*>)|(\\[[^\\]]*<[^\\s]*>\\])|(\\[[^<>]*\\])";
    private String commandName = null;
    private String commandModel = null;
    private String commandRegexp = null;
    private boolean deprecated = false;
    private String seeCommand;
    private String commandDefinition = null;
    private ArrayList<CommandParameterI> commandParameterList = new ArrayList();
    private ICommandExecutorI commandExecutor = null;

    public CommandI(String pCommandName, String pCommandModel, String pCommandDefinition, ICommandExecutorI pCommandExecutor, boolean deprecated, String seeCommand) throws CommandParserExceptionI {
        this(pCommandName, pCommandModel, pCommandDefinition, pCommandExecutor);
        this.deprecated = deprecated;
        this.seeCommand = seeCommand;
    }

    public CommandI(String pCommandName, String pCommandModel, String pCommandDefinition, ICommandExecutorI pCommandExecutor) throws CommandParserExceptionI {
        this.commandName = pCommandName;
        this.commandModel = pCommandModel;
        this.commandDefinition = pCommandDefinition;
        this.commandExecutor = pCommandExecutor;
        CommandParameterI comParam = null;
        try {
            this.commandRegexp = String.valueOf(this.commandModel.replace("[", "(").replace("]*", ")*").replace("]", ")?").replaceAll(paramPattern, "(\"[^\"]*\"|'[^']*'|[^'\"\\\\s][^\\\\s]*)").replaceAll(spacesPattern, "[\\\\s]*")) + "[\\s]*";
        }
        catch (Exception e) {
            throw new CommandParserExceptionI(Messages.getString("CommandI.0"), e);
        }
        try {
            Pattern optionOrNotPatt = Pattern.compile(optionOrNotParamPattern);
            Matcher m1 = optionOrNotPatt.matcher(this.commandModel);
            int paramPos = 0;
            while (m1.find()) {
                ++paramPos;
                if (m1.group(1) != null) {
                    comParam = new CommandParameterI(m1.group(1).replace("<", "").replace(">", ""), false, paramPos);
                    this.commandParameterList.add(comParam);
                    continue;
                }
                if (m1.group(3) != null && m1.group(2) == null && m1.group(1) == null) {
                    comParam = new CommandParameterI(m1.group(3), false, paramPos);
                    this.commandParameterList.add(comParam);
                    continue;
                }
                String t = m1.group(2);
                comParam = new CommandParameterI(t.substring(t.indexOf("<") + 1, t.indexOf(">")), true, ++paramPos);
                this.commandParameterList.add(comParam);
            }
        }
        catch (Exception e) {
            throw new CommandParserExceptionI(Messages.getString("CommandI.1"), e);
        }
    }

    public CommandParameterI getParameterMetadata(int num) {
        if (num < this.commandParameterList.size() && num >= 0) {
            return this.commandParameterList.get(num);
        }
        return null;
    }

    public ArrayList<CommandParameterI> getMetadataList() {
        return this.commandParameterList;
    }

    public ICommandExecutorI getCommandExecutorI() {
        return this.commandExecutor;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandRegexp() {
        return this.commandRegexp;
    }

    public String getCommandDefinition() {
        return this.commandDefinition;
    }

    public String getCommandModel() {
        return this.commandModel;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getSeeCommand() {
        return this.seeCommand;
    }

    @Override
    public int compareTo(CommandI arg0) {
        return this.getCommandName().compareTo(arg0.getCommandName());
    }
}

