/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.command.parser;

import com.indy.engine.common.command.parser.CommandLine;
import com.indy.engine.common.command.parser.CommandParameter;
import com.indy.engine.common.command.parser.CommandParserException;
import com.indy.engine.common.command.parser.Messages;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLineParser {
    CommandLine command;
    Class clazz;
    Map<CommandLine, Class> commandsMap = new HashMap<CommandLine, Class>();
    Map<String, Help> helps = new HashMap<String, Help>();

    public Object parse(String commandString) throws Exception {
        int n;
        Object object;
        for (CommandLine cl : this.commandsMap.keySet()) {
            if (!commandString.replaceFirst(cl.startWith().replace(" ", "[ ]+"), "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd").startsWith("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd")) continue;
            this.command = cl;
            this.clazz = this.commandsMap.get(cl);
            break;
        }
        if (this.command == null) {
            return null;
        }
        String command2 = commandString.substring(this.command.removeString().length()).trim();
        Class c = this.clazz;
        HashMap<Object, Field> fields = new HashMap<Object, Field>();
        Field[] fieldArray = c.getFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field f = fieldArray[n3];
            CommandParameter o = f.getAnnotation(CommandParameter.class);
            if (o != null) {
                fields.put(o.name(), f);
                object = o.aliases();
                n = ((String[])object).length;
                int n4 = 0;
                while (n4 < n) {
                    Object alias = object[n4];
                    fields.put(alias, f);
                    ++n4;
                }
            }
            ++n3;
        }
        Object t = this.clazz.newInstance();
        String[] _args = this.cutCommands(command2);
        int i = 0;
        Field field = null;
        String previous = null;
        while (i < _args.length) {
            String arg = _args[i++];
            if (field != null && this.isFill(field, t)) {
                field = null;
            }
            if (previous != null) {
                arg = String.valueOf(previous) + " " + arg;
                previous = null;
            }
            if (field == null) {
                List list;
                field = (Field)fields.get(arg);
                if (field == null) {
                    boolean exists = false;
                    for (String _arg : fields.keySet()) {
                        if (!_arg.startsWith(arg)) continue;
                        exists = true;
                    }
                    if (!exists) {
                        throw new CommandParserException(String.valueOf(Messages.getString("CommandLineParser.0")) + arg + Messages.getString("CommandLineParser.1"));
                    }
                    previous = arg;
                    continue;
                }
                if (field.getType() == List.class && (list = (List)field.get(t)) != null && list.size() > 0) {
                    list.add(null);
                }
                if (field.getType() != Boolean.class) continue;
                Object b = field.get(t);
                if (b != null) {
                    throw new CommandParserException(String.valueOf(Messages.getString("CommandLineParser.2")) + arg + Messages.getString("CommandLineParser.3"));
                }
                field.set(t, true);
                field = null;
                continue;
            }
            this.addValue(t, field, arg);
        }
        object = c.getDeclaredFields();
        n = ((Field[])object).length;
        int n5 = 0;
        while (n5 < n) {
            CommandParameter o;
            Object f = object[n5];
            if (!((Field)f).isSynthetic() && (o = ((Field)f).getAnnotation(CommandParameter.class)).required() && !this.isFill((Field)f, t)) {
                throw new CommandParserException(String.valueOf(Messages.getString("CommandLineParser.4")) + o.name() + Messages.getString("CommandLineParser.5"));
            }
            ++n5;
        }
        return t;
    }

    public void register(CommandLine commandLine, Class commandClass) {
        this.commandsMap.put(commandLine, commandClass);
        String name = commandLine.startWith();
        String help = commandLine.usage();
        Help _help = new Help();
        _help.description = commandLine.description();
        _help.commandeName = commandLine.startWith();
        _help.usage = commandLine.usage();
        this.helps.put(name, _help);
    }

    public Collection<CommandLine> getCommands() {
        return this.commandsMap.keySet();
    }

    public String getCommandUsage(Class<? extends CommandLine> command) {
        String str = "";
        Field[] fieldArray = command.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            CommandParameter o = f.getAnnotation(CommandParameter.class);
            if (!o.required()) {
                str = String.valueOf(str) + "[";
            }
            str = String.valueOf(str) + o.name();
            str = String.valueOf(str) + " ";
            if (f.getClass().getName().equals(Boolean.class.getName())) {
                str = String.valueOf(str) + "<" + o.name() + "> ";
            } else if (f.getClass().getName().equals(String.class.getName())) {
                str = String.valueOf(str) + "<" + (!o.valueSample().isEmpty() ? o.valueSample() : String.valueOf(o.name()) + " value") + "> ";
            } else if (f.getClass().getName().equals(ArrayList.class.getName())) {
                if (o.parameters().length > 0) {
                    String[] stringArray = o.parameters();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String st = stringArray[n4];
                        str = String.valueOf(str) + "<" + st + ">";
                        ++n4;
                    }
                } else {
                    str = String.valueOf(str) + "<" + (!o.valueSample().isEmpty() ? o.valueSample() : String.valueOf(o.name()) + " value") + ">";
                }
                str = String.valueOf(str) + " " + o.name() + "...";
            }
            if (!o.required()) {
                str = String.valueOf(str) + "]";
            }
            ++n2;
        }
        return str;
    }

    public Map<String, Help> getHelp(String name) {
        HashMap<String, Help> list = new HashMap<String, Help>();
        for (String key : this.helps.keySet()) {
            if (name != null) {
                if (!key.equals(name)) continue;
                list.put(key, this.helps.get(key));
                return list;
            }
            list.put(key, this.helps.get(key));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addValue(Object t, Field field, String arg) throws Exception {
        void var5_11;
        CommandParameter current = field.getAnnotation(CommandParameter.class);
        Object var5_5 = null;
        ArrayList<Object> list = null;
        if (field.getType() == Map.class) {
            if (current.parameters().length == 0) {
                throw new Exception("Error");
            }
            Map map = (Map)field.get(t);
            if (map == null) {
                HashMap hashMap = new HashMap();
                field.set(t, hashMap);
            }
        } else if (field.getType() == String.class) {
            String str = (String)field.get(t);
            if (str != null) throw new CommandParserException("Parameter \"" + arg + "\" is already setted");
            field.set(t, arg);
        } else if (field.getType() == Integer.class) {
            Integer str = (Integer)field.get(t);
            if (str != null) throw new CommandParserException("Parameter \"" + arg + "\" is already setted");
            field.set(t, Integer.parseInt(arg));
        } else if (field.getType() == List.class) {
            list = (ArrayList<Object>)field.get(t);
            if (list == null) {
                list = new ArrayList<Object>();
                field.set(t, list);
            } else if (list.size() > 0 && list.get(list.size() - 1) == null) {
                list.remove(list.size() - 1);
            }
            if (current.parameters().length > 0) {
                if (list.size() == 0) {
                    HashMap hashMap = new HashMap();
                    list.add(hashMap);
                } else if (this.isFill(field, t)) {
                    HashMap hashMap = new HashMap();
                    list.add(hashMap);
                } else {
                    Map map = (Map)list.get(list.size() - 1);
                }
            } else {
                list.add(arg);
            }
        } else if (field.getType().asSubclass(Enum.class) != null) {
            Object value = Enum.valueOf(field.getType(), arg);
            field.set(t, value);
        }
        if (var5_11 == null) return;
        if (var5_11.size() >= current.parameters().length) throw new CommandParserException("Parameter \"" + arg + "\" is already setted");
        var5_11.put(current.parameters()[var5_11.size()], arg);
    }

    private boolean isFill(Field field, Object instance) throws IllegalArgumentException, IllegalAccessException {
        CommandParameter cp = field.getAnnotation(CommandParameter.class);
        Object o = field.get(instance);
        if (o == null) {
            return false;
        }
        if (o instanceof Map) {
            return ((Map)o).size() == cp.parameters().length;
        }
        if (o instanceof String) {
            return true;
        }
        if (o instanceof Integer) {
            return true;
        }
        if (o instanceof List) {
            List list = (List)o;
            if (list.size() > 0 && list.get(list.size() - 1) == null) {
                return false;
            }
            if (list.size() == 0) {
                return false;
            }
            for (Object _o : list) {
                if (!(_o instanceof Map) || ((Map)_o).size() == cp.parameters().length) continue;
                return false;
            }
        }
        return true;
    }

    private String[] cutCommands(String line) {
        boolean openChar = false;
        line = line.replace("\"\"", "\ufffd\ufffd^");
        String current = "";
        ArrayList<String> list = new ArrayList<String>();
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\"') {
                openChar = !openChar;
            }
            if (c == ' ') {
                if (openChar) {
                    current = String.valueOf(current) + c;
                } else {
                    if (!current.isEmpty()) {
                        list.add(current.replace("\ufffd\ufffd^", "\""));
                    }
                    current = "";
                }
            } else if (c != '\"') {
                current = String.valueOf(current) + c;
            }
            ++n2;
        }
        if (!current.isEmpty()) {
            list.add(current.replace("\ufffd\ufffd^", "\""));
        }
        String[] ret = new String[list.size()];
        return list.toArray(ret);
    }

    public static class Help {
        String commandeName;
        String usage;
        String description;
        boolean deprecated = false;
        private String seeCommand;

        public String getCommandeName() {
            return this.commandeName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUsage() {
            return this.usage;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setUsage(String usage) {
            this.usage = usage;
        }

        public void setCommandName(String commandeName) {
            this.commandeName = commandeName;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setSeeCommand(String seeCommand) {
            this.seeCommand = seeCommand;
        }

        public String getSeeCommand() {
            return this.seeCommand;
        }
    }
}

