/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.security;

import com.indy.engine.common.security.Messages;
import com.indy.engine.core.security.Role;
import com.semarchy.xdi.engine.common.CommonUtils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlRootElement(name="security")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SecurityConfiguration {
    private static Logger logger = LogManager.getLogger(SecurityConfiguration.class);
    @XmlElement(name="user")
    private List<User> users;
    @XmlElement(name="key")
    private List<CryptographyKey> keys;
    Map<String, User> userMap = null;
    boolean init = false;
    List<String> allowsList = null;
    User anonymousUser;
    @XmlElement(name="allow")
    private List<Allow> allows;
    private boolean allowLocalhostOnly = false;

    public List<CryptographyKey> getKeys() {
        return this.keys;
    }

    public static SecurityConfiguration getClientConfiguration(File file) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            SecurityConfiguration securityConfiguration = SecurityConfiguration.getClientConfiguration(is);
            return securityConfiguration;
        }
    }

    public static SecurityConfiguration getClientConfiguration(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        return (SecurityConfiguration)JAXB.unmarshal((InputStream)is, SecurityConfiguration.class);
    }

    public static SecurityConfiguration getClientConfiguration(Node node) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        Transformer transformer = CommonUtils.getSafeTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, Charset.defaultCharset());
        transformer.transform(new DOMSource(node), new StreamResult(osw));
        osw.close();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStreamReader isr = new InputStreamReader((InputStream)bais, Charset.defaultCharset());
        return (SecurityConfiguration)JAXB.unmarshal((Reader)isr, SecurityConfiguration.class);
    }

    public User getUser(String name) {
        return this.userMap.get(name);
    }

    public List<String> getAllowsList() {
        return this.allowsList;
    }

    public void init(Encrypt encrypt) throws EngineExceptionI {
        if (!this.init) {
            this.userMap = new HashMap<String, User>();
            if (this.users != null) {
                for (User conn : this.users) {
                    if (conn.anonymous) {
                        if (this.anonymousUser != null) {
                            throw new RuntimeException(Messages.getString("SecurityConfiguration.1"));
                        }
                        this.anonymousUser = conn;
                    }
                    conn.validate();
                    this.userMap.put(conn.getName(), conn);
                    conn.init();
                    if (conn.uncryptedPassword != null) {
                        try {
                            conn.hashedPassword = new String(MessageDigest.getInstance("SHA-256").digest(conn.uncryptedPassword.getBytes()));
                            continue;
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(String.valueOf(Messages.getString("SecurityConfiguration.2")) + e);
                        }
                    }
                    if (conn.encryptedPassword == null) continue;
                    try {
                        conn.hashedPassword = new String(MessageDigest.getInstance("SHA-256").digest(encrypt.decrypt(conn.encryptedPassword).getBytes()));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(String.valueOf(Messages.getString("SecurityConfiguration.3")) + e);
                    }
                }
            } else {
                throw new EngineExceptionI(Messages.getString("SecurityConfiguration.4"));
            }
            if (this.allows != null) {
                this.allowsList = new ArrayList<String>();
                for (Allow ad : this.allows) {
                    if (ad.address == null) continue;
                    this.allowsList.add(ad.address);
                }
                if (this.allowsList.size() == 1 && (this.allowsList.get(0).equals("localhost") || this.allowsList.get(0).equals("127.0.0.1"))) {
                    this.allowLocalhostOnly = true;
                }
            }
            this.init = true;
        }
    }

    public List<User> getUsers() {
        return this.users;
    }

    public List<String> getRemoteHosts() {
        return this.allowsList;
    }

    public User getAnonymousUser() {
        return this.anonymousUser;
    }

    public boolean isAllowLocalhostOnly() {
        return this.allowLocalhostOnly;
    }

    public static class Allow {
        @XmlAttribute(name="address", required=true)
        public String address;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CryptographyKey {
        @XmlAttribute(name="name", required=true)
        public String name;
        @XmlAttribute(name="usage", required=false)
        public String usage;
    }

    public static interface Encrypt {
        public String encrypt(String var1) throws Throwable;

        public String decrypt(String var1) throws Throwable;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class User {
        @XmlAttribute(name="anonymous", required=false)
        private boolean anonymous = false;
        @XmlAttribute(name="name", required=false)
        private String name;
        @XmlAttribute(name="uncryptedPassword", required=false)
        private String uncryptedPassword;
        @XmlAttribute(name="password", required=false)
        private String encryptedPassword;
        @XmlAttribute(name="roles", required=false)
        private List<Role> roles;
        private String hashedPassword;
        private boolean isAdmin;

        public boolean canExecute() {
            return this.roles != null && (this.roles.contains(Role.Admin) || this.roles.contains(Role.ExecuteAPI));
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public String getName() {
            return this.name;
        }

        void validate() {
            if (!this.anonymous && (this.getName() == null || this.getName().isEmpty())) {
                throw new RuntimeException(Messages.getString("SecurityConfiguration.0"));
            }
        }

        void init() {
            this.isAdmin = this.roles == null || this.roles.size() == 0 || this.roles.contains(Role.Admin);
        }

        public List<Role> getRoles() {
            return this.roles;
        }

        public void setPassword(String password) {
            this.encryptedPassword = password;
        }

        public String getHashedPassword() {
            return this.hashedPassword;
        }
    }
}

