/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.swagger2;

import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;

public class SwaggerDefinition
implements IOpenAPI {
    @IOpenAPI.ToSerialize(name="host")
    public String host;
    @IOpenAPI.ToSerialize(name="swagger")
    String version = "2.0";
    @IOpenAPI.ToSerialize(name="basePath")
    String basePath;
    @IOpenAPI.ToSerialize(name="schemes")
    List<String> schemes = new ArrayList<String>();
    @IOpenAPI.ToSerialize(name="paths")
    Map<String, Path> paths = new TreeMap<String, Path>();
    @IOpenAPI.ToSerialize(name="definitions")
    Map<String, Definition> definitions = new TreeMap<String, Definition>();
    @IOpenAPI.ToSerialize(name="info")
    Info info;

    public void setHost(String host) {
        this.host = host;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public SwaggerDefinition(String host, String basePath) {
        this.host = host;
        this.basePath = basePath;
    }

    public Path newPath(String path) {
        Path _path = this.paths.get(path);
        if (_path == null) {
            _path = new Path();
            this.paths.put(path, _path);
        }
        return _path;
    }

    public Definition newRawDefinition(String name, String checksum, String raw, boolean subDefinition) throws Exception {
        Object o = JsonUtils.jsonNodeToObject((String)raw);
        Definition def = this.newDefinition(name, checksum, o, subDefinition);
        def.raw = raw;
        return def;
    }

    private Definition newDefinition(String prefix, String checksum, Object object, boolean subDefinition) throws Exception {
        String _prefix;
        Definition def = null;
        String computeName = _prefix = IOpenAPI.computeName(prefix);
        int index = 1;
        do {
            Definition definition;
            if ((definition = this.definitions.get(computeName)) != null && definition.checkSum != null && definition.checkSum.equals(checksum)) {
                def = definition;
                continue;
            }
            if (definition != null) {
                computeName = String.valueOf(_prefix) + "_" + ++index;
                continue;
            }
            def = new Definition();
            def.object = object;
            def.checkSum = checksum;
            def.name = computeName;
            this.definitions.put(computeName, def);
        } while (def == null);
        if (subDefinition) {
            for (Map.Entry<String, Object> entry : ((Map)def.object).entrySet()) {
                this.createSubDef(prefix, (Map)def.object, entry);
            }
        }
        return def;
    }

    private void createSubDef(String prefix, Map<String, Object> parent, Map.Entry<String, Object> entry) throws Exception {
        if (entry.getValue() instanceof Map) {
            Object type = ((Map)entry.getValue()).get("type");
            if (type instanceof String && type.equals("object")) {
                parent.remove(entry.getKey());
                String string = this.newDefinition((String)prefix, (String)entry.getKey(), (Object)entry.getValue(), (boolean)false).name;
                if (parent.get("type") != null && parent.get("type").equals("array")) {
                    parent.put("$ref", "#/definitions/" + string);
                } else {
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    map.put("$ref", "#/definitions/" + string);
                    parent.put(entry.getKey(), map);
                }
            }
            for (Map.Entry<String, Object> entry2 : ((Map)entry.getValue()).entrySet()) {
                this.createSubDef(prefix, (Map)entry.getValue(), entry2);
            }
        }
    }

    public void writeFile(String sTAMBIA_SWAGGER_20_PATH) throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, XMLStreamException {
        Object o = IOpenAPI.serialize(this);
        JsonNode.serialize((Object)o, (OutputStream)new FileOutputStream(sTAMBIA_SWAGGER_20_PATH), (String)"UTF-8");
    }

    public static void main(String[] args) throws Exception {
        SwaggerDefinition sd = new SwaggerDefinition("sedna3:42200", "/rest/StambiaDeliveryService/2");
        Path path = sd.newPath("/swaggerWebService");
        Method method = path.newMethod("post");
        method.operationId = "listCustomers";
        Parameter parameter = method.newParameter("address");
        parameter.in = "body";
        parameter.newSchemaRef("swaggerWebService_adress");
        parameter.newSchema("adress", "{\"required\":[\"city\",\"country\"],\"properties\":{\"city\":{\"type\":\"string\"},\"country\":{\"type\":\"string\"}}}", false);
        parameter.required = false;
        Response resp = method.newResponse("200");
        resp.type = "array";
        resp.newSchemaRef("swaggerWebService_customers");
        resp.description = "test";
        sd.newRawDefinition("swaggerWebService", "adress", "{\"required\":[\"city\",\"country\"],\"properties\":{\"city\":{\"type\":\"string\"},\"country\":{\"type\":\"string\"}}}", false);
        sd.newRawDefinition("swaggerWebService", "customers", "{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/swaggerWebService_customer\"}}", false);
        method.addConsumes("application/json");
        method.addProduces("application/json");
        Object o = IOpenAPI.serialize(sd);
        JsonNode.serialize((Object)o, (OutputStream)System.out, (String)"UTF-8");
    }

    public void addSchemes(String string) {
        this.schemes.add(string);
    }

    public Info newInfo() {
        if (this.info == null) {
            this.info = new Info();
        }
        return this.info;
    }

    public Info getInfo() {
        return this.info;
    }

    public static class Definition
    implements IOpenAPI.Serialize {
        public String name;
        String raw;
        String checkSum;
        Object object;

        @Override
        public Object serialize() {
            return this.object;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Info {
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="version")
        public String version;
        @IOpenAPI.ToSerialize(name="title")
        public String title;
        @IOpenAPI.ToSerialize(name="termsOfService")
        public String termsOfService;

        public String getTitle() {
            return this.title;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Method {
        @IOpenAPI.ToSerialize(name="operationId")
        String operationId;
        @IOpenAPI.ToSerialize(name="responses")
        Map<String, Response> responses = new TreeMap<String, Response>();
        @IOpenAPI.ToSerialize(name="parameters")
        List<Parameter> parameters = new ArrayList<Parameter>();
        @IOpenAPI.ToSerialize(name="consumes")
        List<String> consumes = new ArrayList<String>();
        @IOpenAPI.ToSerialize(name="produces")
        List<String> produces = new ArrayList<String>();
        @IOpenAPI.ToSerialize(name="tags")
        Set<String> tags = new TreeSet<String>();

        public Response newResponse(String code) {
            Response response = new Response();
            response.code = code;
            this.responses.put(code, response);
            return response;
        }

        public Parameter newParameter(String string) {
            Parameter parameter = new Parameter(string);
            this.parameters.add(parameter);
            return parameter;
        }

        public void addProduces(String string) {
            this.produces.add(string);
        }

        public void addConsumes(String string) {
            this.consumes.add(string);
        }

        public void setOperationId(String name) {
            this.operationId = name;
        }

        public void addTags(Set<String> tags) {
            this.tags.addAll(tags);
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Parameter {
        @IOpenAPI.ToSerialize(name="name")
        String name;
        @IOpenAPI.ToSerialize(name="in")
        String in;
        @IOpenAPI.ToSerialize(name="schema")
        SchemaRef schemaRef;
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;
        @IOpenAPI.ToSerialize(name="type")
        String type;
        @IOpenAPI.ToSerialize(name="required")
        public boolean required;
        @IOpenAPI.ToSerialize(name="enum")
        Object enumValues;

        public Parameter(String string) {
            this.name = string;
        }

        public void setIn(String in) {
            this.in = in;
        }

        public void newSchemaRef(String string) {
            this.schemaRef = new SchemaRef(string);
        }

        public void newSchema(String name, String raw, boolean global) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)raw);
        }

        public void setType(String type2) {
            this.type = type2;
        }

        public void setEnumValues(List<String> values) throws Exception {
            StringBuilder b = new StringBuilder();
            if (values != null && !values.isEmpty()) {
                for (String s : values) {
                    if (b.length() != 0) {
                        b.append(",");
                    }
                    b.append("\"" + s + "\"");
                }
                this.enumValues = JsonUtils.jsonNodeToObject((String)("[" + b.toString() + "]"));
            }
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Path
    implements IOpenAPI.Serialize {
        @IOpenAPI.ToSerialize(name="")
        Map<String, Method> methods = new TreeMap<String, Method>();

        public Method newMethod(String method) {
            Method _method = new Method();
            this.methods.put(method, _method);
            return _method;
        }

        @Override
        public Object serialize() {
            return this.methods;
        }
    }

    @IOpenAPI.ToSerialize(name="")
    public static class Response {
        String code;
        @IOpenAPI.ToSerialize(name="schema")
        SchemaRef schemaRef;
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="type")
        public String type;

        public void newSchemaRef(String string) {
            this.schemaRef = new SchemaRef(string);
        }

        public void newSchema(String name, String raw, boolean global) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)raw);
        }
    }

    static class SchemaRef
    implements IOpenAPI.Serialize {
        String ref;

        public SchemaRef(String string) {
            this.ref = string;
        }

        @Override
        public Object serialize() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("$ref", "#/definitions/" + this.ref);
            return map;
        }
    }
}

