/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc;

import com.indy.engine.common.queue.impl.FileQueue;
import com.indy.engine.common.queue.impl.MemoryBlockingQueue;
import com.indy.engine.core.common.objects.NotFetchedResultSetBindI;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.core.module.configuration.RuntimeConfiguration;
import com.indy.engine.core.queue.IQueueProducer;
import com.indy.runtime.api.impl.jdbc.Messages;
import com.indy.runtime.api.impl.jdbc.fifo.BlockingQueueWithWait;
import com.indy.runtime.api.impl.jdbc.fifo.ColumnMetadata;
import com.indy.runtime.api.impl.jdbc.fifo.FifoResultSet;
import com.indy.runtime.api.impl.jdbc.fifo.FifoRow;
import com.indy.runtime.api.impl.jdbc.fifo.PreparedStatementImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;

public class JdbcPreparedStatementToResultSet
extends PreparedStatementImpl
implements IPreparedStatementToResultSet {
    ColumnMetadata cm;
    private Map<String, BlockingQueueWithWait<FifoRow>> queues = new HashMap<String, BlockingQueueWithWait<FifoRow>>();
    public static final FifoRow stopRow = new FifoRow(0);
    public static final FifoRow endMessage = new FifoRow(0);
    Semaphore sem;
    Callable<ResultSet> executeQueryCallable;
    boolean mono;
    ResultSet source;
    IQueueProducer<FifoRow> producer;
    public static final String monoResultSet = "mono";
    boolean lastRowIsSend = false;
    FifoRow currentRow;
    List<FifoRow> batch = new ArrayList<FifoRow>();
    int closeState = 0;
    Map<String, FifoResultSet> resultSets = Collections.synchronizedMap(new HashMap());

    public void start() {
        if (this.sem != null) {
            this.sem.release();
            this.sem = null;
        }
    }

    public void addExecuteQueryCallable(Callable callable) {
        this.executeQueryCallable = callable;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.executeQueryCallable == null) {
            throw new SQLFeatureNotSupportedException();
        }
        try {
            return this.executeQueryCallable.call();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    void waitForStart() throws SQLException {
        if (this.sem != null) {
            try {
                this.sem.acquire();
            }
            catch (InterruptedException e) {
                throw new SQLException(e);
            }
        }
    }

    public JdbcPreparedStatementToResultSet() throws SQLException {
        this.cm = new ColumnMetadata();
    }

    private ColumnMetadata getCM() throws SQLException {
        if (this.closeState == 2) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.0"));
        }
        if (this.cm == null) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.4"));
        }
        return this.cm;
    }

    public void setInputResultSet(ResultSet rsm) throws SQLException {
        if (this.cm.getColumnCount() > 0) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.3"));
        }
        this.cm = null;
        this.source = rsm;
    }

    public void fill() throws SQLException {
        if (this.source != null) {
            while (this.source.next()) {
                FifoRow fr = new FifoRow(this.getMetaData().getColumnCount());
                int i = 1;
                while (i <= this.getMetaData().getColumnCount()) {
                    try {
                        fr.setObject(i, this.source.getObject(i));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                this.add(fr);
            }
            this.end();
        }
    }

    public synchronized void setConsumers(boolean fileQueue, String ... names) throws SQLException {
        if (this.producer != null) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.1"));
        }
        if (fileQueue) {
            try {
                this.producer = new FileQueue<FifoRow>(new File(String.valueOf(RuntimeConfiguration.getInstance().temporaryFolder()) + File.pathSeparator + "filequeue"), UUID.randomUUID().toString());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        } else {
            this.producer = new MemoryBlockingQueue<FifoRow>(new FifoRow());
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addConsumer(name);
            ++n2;
        }
    }

    private void addConsumer(final String name) throws SQLException {
        BlockingQueueWithWait queue;
        this.mono = this.queues.size() == 0 && name.equals(monoResultSet);
        try {
            queue = new BlockingQueueWithWait(this.producer.createConsumer());
        }
        catch (InterruptedException e) {
            throw new SQLException(e);
        }
        catch (InstantiationException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        this.queues.put(name, queue);
        FifoResultSet rs = new FifoResultSet(queue){

            @Override
            public void close() throws SQLException {
                JdbcPreparedStatementToResultSet.this.resultSets.remove(name);
                BlockingQueueWithWait bqww = (BlockingQueueWithWait)JdbcPreparedStatementToResultSet.this.queues.get(name);
                if (bqww != null) {
                    bqww.close();
                    JdbcPreparedStatementToResultSet.this.queues.remove(name);
                }
                super.close();
            }

            @Override
            public ResultSetMetaData getMetadata() throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getMetaData();
            }
        };
        this.resultSets.put(name, rs);
    }

    public void handleBeforeAdd() throws SQLException {
    }

    private void add(FifoRow row) throws SQLException {
        this.waitForStart();
        this.handleBeforeAdd();
        try {
            if (row == stopRow) {
                this.producer.end();
            } else {
                this.producer.put((Object)row);
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private void waitAck() throws SQLException {
        this.waitForStart();
        ArrayList<BlockingQueueWithWait<FifoRow>> list = new ArrayList<BlockingQueueWithWait<FifoRow>>();
        list.addAll(this.queues.values());
        for (BlockingQueueWithWait blockingQueueWithWait : list) {
            try {
                blockingQueueWithWait.internalWaitForEnd();
            }
            catch (InterruptedException e) {
                throw new SQLException(e);
            }
        }
    }

    private void addAll(List<FifoRow> rows) throws SQLException {
        this.waitForStart();
        this.handleBeforeAdd();
        try {
            this.producer.putAll(rows);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public void end() throws SQLException {
        if (!this.lastRowIsSend) {
            this.lastRowIsSend = true;
            this.add(stopRow);
            this.waitAck();
        }
    }

    public void end2() throws SQLException {
        if (!this.lastRowIsSend) {
            this.lastRowIsSend = true;
            this.add(stopRow);
        }
    }

    public void endMessage() throws SQLException {
        if (this.batch.size() > 0) {
            this.currentRow = endMessage;
            this.addBatch();
            this.executeBatch();
        } else {
            this.currentRow = endMessage;
            this.executeUpdate();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
        this.clearParameters();
    }

    @Override
    public void setString(int paramInt, String paramString) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setString(paramInt, paramString);
    }

    @Override
    public void setBoolean(int paramInt, boolean paramBoolean) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setBoolean(paramInt, paramBoolean);
    }

    @Override
    public void setDouble(int paramInt, double paramDouble) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setDouble(paramInt, paramDouble);
    }

    @Override
    public void setDate(int paramInt, Date paramDate) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setDate(paramInt, paramDate);
    }

    @Override
    public void setTime(int paramInt, Time paramTime) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setTime(paramInt, paramTime);
    }

    @Override
    public void setTimestamp(int paramInt, Timestamp paramTimestamp) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setTimestamp(paramInt, paramTimestamp);
    }

    @Override
    public void setBigDecimal(int paramInt, BigDecimal paramBigDecimal) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setBigDecimal(paramInt, paramBigDecimal);
    }

    @Override
    public void setBytes(int paramInt, byte[] parambyte) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setBytes(paramInt, parambyte);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.currentRow = new FifoRow(this.getCM().getColumnCount());
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkCurrentRow();
        this.batch.add(this.currentRow);
        this.clearParameters();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.cm;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closeState == 2) {
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.2"));
        }
        if (this.cm == null) {
            if (this.source != null) {
                return this.source.getMetaData();
            }
            throw new SQLException(Messages.getString("JdbcPreparedStatementToResultSet.5"));
        }
        return this.getCM();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closeState == 2;
    }

    @Override
    public void close() throws SQLException {
        if (this.closeState == 0) {
            this.closeState = 1;
            this.end();
            this.currentRow = null;
            if (this.batch != null) {
                this.batch.clear();
            }
            this.batch = null;
            this.cm = null;
            this.source = null;
            this.executeQueryCallable = null;
            try {
                this.producer.close();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
            this.producer = null;
            this.closeState = 2;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkCurrentRow();
        this.add(this.currentRow);
        this.clearParameters();
        return 1;
    }

    public ResultSet getResultSet(String id, boolean waitForbegin) throws SQLException {
        ResultSet rs;
        ResultSet resultSet = rs = this.mono ? (ResultSet)this.resultSets.get(monoResultSet) : (ResultSet)this.resultSets.get(id);
        if (rs != null) {
            return rs;
        }
        if (waitForbegin) {
            BlockingQueueWithWait<FifoRow> queue = this.queues.get(id);
            if (queue != null) {
                try {
                    queue.waitForBegin();
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            } else {
                throw new SQLException(String.valueOf(Messages.getString("JdbcPreparedStatementToResultSet.6")) + id + Messages.getString("JdbcPreparedStatementToResultSet.7"));
            }
        }
        throw new SQLException(String.valueOf(Messages.getString("JdbcPreparedStatementToResultSet.8")) + id + Messages.getString("JdbcPreparedStatementToResultSet.9"));
    }

    public ResultSet getResultSet(String id) throws SQLException {
        return this.getResultSet(id, false);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int i = this.batch.size();
        this.addAll(this.batch);
        this.clearBatch();
        int[] ret = new int[i];
        int j = 0;
        while (j < ret.length) {
            ret[j] = 1;
            ++j;
        }
        return ret;
    }

    public void setColumn(int paramInt, String columnName) throws SQLException {
        this.setColumn(paramInt, columnName, "VARCHAR");
    }

    public void setColumn(int paramInt, String columnName, String dataType) throws SQLException {
        this.getCM().setColumnName(paramInt, columnName);
        this.getCM().setColumnType(paramInt, dataType);
    }

    public void setColumn(int paramInt, String columnName, String dataType, int precision) throws SQLException {
        this.setColumn(paramInt, columnName, dataType);
        this.getCM().setColumnPrecision(paramInt, precision);
    }

    public void setColumn(int paramInt, String columnName, String dataType, int precision, int scale) throws SQLException {
        this.setColumn(paramInt, columnName, dataType, precision);
        this.getCM().setColumnScale(paramInt, scale);
    }

    public void setColumnName(int paramInt, String columnName) throws SQLException {
        this.getCM().setColumnName(paramInt, columnName);
    }

    public void setColumnPrecision(int paramInt, int precision) throws SQLException {
        this.getCM().setColumnPrecision(paramInt, precision);
    }

    @Deprecated
    public void setColumnsName(String string, String separator) throws SQLException {
        String[] strs = string.split(separator);
        int i = 0;
        while (i < strs.length) {
            this.setColumnName(i + 1, strs[i].trim());
            ++i;
        }
    }

    @Deprecated
    public void setColumnsPrecision(String string, String separator) throws NumberFormatException, SQLException {
        String[] strs = string.split(separator);
        int i = 0;
        while (i < strs.length) {
            this.setColumnPrecision(i + 1, Integer.valueOf(strs[i].trim()));
            ++i;
        }
    }

    void checkCurrentRow() throws SQLException {
        if (this.currentRow == null) {
            this.clearParameters();
        }
    }

    @Override
    public void setInt(int paramInt1, int paramInt2) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setInt(paramInt1, paramInt2);
    }

    @Override
    public void setNull(int paramInt1, int paramInt2) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setNull(paramInt1);
    }

    @Override
    public void setLong(int paramInt1, long paramInt2) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setLong(paramInt1, paramInt2);
    }

    @Deprecated
    public void setColumnsType(String string, String separator) throws SQLException {
        String[] strs = string.split(separator);
        int i = 0;
        while (i < strs.length) {
            this.setColumnType(i + 1, strs[i].trim());
            ++i;
        }
    }

    public void setColumnType(int paramInt, String type) throws SQLException {
        this.getCM().setColumnType(paramInt, type);
    }

    public void setColumnType(int paramInt, int type) throws SQLException {
        this.getCM().setColumnType(paramInt, type);
    }

    @Override
    public void setObject(int index, Object o) throws SQLException {
        this.checkCurrentRow();
        this.currentRow.setObject(index, o);
    }

    public NotFetchedResultSetBindI getNotFetchedResultSetBindI() {
        return new NotFetchedResultSetBindI(){

            public ResultSet initResultSet(String id) throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getResultSet(id);
            }

            public ResultSet getResultSet(String id) throws SQLException {
                return JdbcPreparedStatementToResultSet.this.getResultSet(id);
            }

            public void closeResultSet(String id) throws SQLException {
                ResultSet rs = JdbcPreparedStatementToResultSet.this.getResultSet(id);
                if (rs != null) {
                    rs.close();
                }
            }
        };
    }

    @Override
    public void setBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
        this.currentRow.setObject(paramInt, paramInputStream);
    }

    public void waitForEnd() throws SQLException {
        this.waitForStart();
        ArrayList<BlockingQueueWithWait<FifoRow>> list = new ArrayList<BlockingQueueWithWait<FifoRow>>();
        list.addAll(this.queues.values());
        for (BlockingQueueWithWait blockingQueueWithWait : list) {
            try {
                blockingQueueWithWait.waitForEnd();
            }
            catch (InterruptedException e) {
                throw new SQLException(e);
            }
        }
    }
}

