/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc.fifo;

import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.api.impl.jdbc.fifo.BlockingQueueWithWait;
import com.indy.runtime.api.impl.jdbc.fifo.FifoRow;
import com.indy.runtime.api.impl.jdbc.fifo.Messages;
import com.indy.runtime.api.impl.jdbc.fifo.ResultSetImpl;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public abstract class FifoResultSet
extends ResultSetImpl {
    private BlockingQueueWithWait<FifoRow> queue;
    Map<String, Integer> index = new HashMap<String, Integer>();
    FifoRow currentRow = null;
    boolean isClosed = false;

    public FifoResultSet(BlockingQueueWithWait<FifoRow> queue) {
        this.queue = queue;
    }

    public abstract ResultSetMetaData getMetadata() throws SQLException;

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer _index = this.index.get(columnLabel);
        if (_index == null) {
            int i = 1;
            while (i <= this.getMetadata().getColumnCount()) {
                String str = this.getMetadata().getColumnLabel(i);
                if (str.equalsIgnoreCase(columnLabel)) {
                    this.index.put(columnLabel, i);
                    return i;
                }
                ++i;
            }
            throw new SQLDataException(String.valueOf(Messages.getString("FifoResultSet.0")) + columnLabel + Messages.getString("FifoResultSet.1"));
        }
        return _index;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int type = this.getMetaData().getColumnType(columnIndex);
        switch (type) {
            case 1111: {
                return this.currentRow.getObject(columnIndex);
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return this.getString(columnIndex);
            }
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                int i = this.getInt(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Integer(i);
            }
            case 16: {
                boolean b = this.getBoolean(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return b;
            }
            case -5: {
                long l = this.getLong(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Long(l);
            }
            case 8: {
                double d = this.getDouble(columnIndex);
                if (this.wasNull()) {
                    return null;
                }
                return new Double(d);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
        }
        throw new SQLDataException(String.valueOf(Messages.getString("FifoResultSet.2")) + this.getMetadata().getColumnType(columnIndex) + Messages.getString("FifoResultSet.3"));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkRow();
        return this.currentRow.getInt(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkRow();
        return this.currentRow.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkRow();
        return this.currentRow.getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getMetadata();
    }

    private void checkRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException(Messages.getString("FifoResultSet.4"));
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkRow();
        return this.currentRow.getString(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
        this.currentRow = null;
        this.queue = null;
    }

    public void waitForBegin() throws Exception {
        this.queue.waitForBegin();
    }

    public void waitForEnd() throws InterruptedException {
        this.queue.waitForEnd();
    }

    @Override
    public synchronized boolean next() throws SQLException {
        try {
            this.currentRow = this.queue.take();
        }
        catch (Exception e1) {
            throw new SQLException(e1);
        }
        return this.currentRow != null;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.currentRow.wasNull();
    }

    public static void main(String[] args) throws SQLException, InterruptedException {
        final JdbcPreparedStatementToResultSet fps = new JdbcPreparedStatementToResultSet();
        fps.setConsumers(false, "1");
        fps.setColumnName(1, "TEST1");
        fps.setColumnPrecision(1, 255);
        fps.setColumnType(1, "VARCHAR");
        fps.setColumnName(2, "TEST2");
        fps.setColumnPrecision(2, 255);
        fps.setColumnType(2, "VARCHAR");
        fps.setColumnName(3, "TEST3");
        fps.setColumnPrecision(3, 255);
        fps.setColumnType(3, "VARCHAR");
        final ResultSet frs = fps.getResultSet("");
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try {
                    ResultSetMetaData md = frs.getMetaData();
                    while (frs.next()) {
                        int i = 1;
                        while (i <= md.getColumnCount()) {
                            System.out.println(String.valueOf(md.getColumnName(i)) + ": " + frs.getString(i));
                            ++i;
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable producer = new Runnable(){

            @Override
            public void run() {
                try {
                    int i = 1;
                    while (i <= 10) {
                        fps.setString(1, "VALUE1 " + i);
                        fps.setString(2, "VALUE2 " + i);
                        fps.setString(3, "VALUE3 " + i);
                        fps.addBatch();
                        fps.executeBatch();
                        ++i;
                    }
                    fps.end();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(producer).start();
        Thread.sleep(1000L);
        new Thread(reader).start();
    }

    @Override
    public double getDouble(int index) throws SQLException {
        this.checkRow();
        return this.currentRow.getDouble(index);
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.checkRow();
        return this.currentRow.getBoolean(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws SQLException {
        this.checkRow();
        return this.currentRow.getBigDecimal(index);
    }

    @Override
    public Time getTime(int index) throws SQLException {
        this.checkRow();
        return this.currentRow.getTime(index);
    }

    @Override
    public Timestamp getTimestamp(int index) throws SQLException {
        this.checkRow();
        int type = this.getMetadata().getColumnType(index);
        switch (type) {
            case 91: {
                return new Timestamp(this.getDate(index).getTime());
            }
        }
        return this.currentRow.getTimestamp(index);
    }

    @Override
    public Date getDate(int index) throws SQLException {
        this.checkRow();
        return this.currentRow.getDate(index);
    }

    @Override
    public InputStream getBinaryStream(int index) throws SQLException {
        this.checkRow();
        return (InputStream)this.currentRow.getObject(index);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    public boolean isEndMessage() throws SQLException {
        return this.currentRow == JdbcPreparedStatementToResultSet.endMessage;
    }
}

