/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.engine.common;

import com.indy.engine.core.Messages;
import com.indy.engine.shared.certification.IDeliveryChecksumCertifier;
import com.indy.engine.shared.passwordmanagement.IPasswordManagerDelegate;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DeliveryChecksumCertifier
implements IDeliveryChecksumCertifier {
    static final MessageDigest MD5Digest;
    private IPasswordManagerDelegate passwordManager;
    private static Map<IPasswordManagerDelegate, IDeliveryChecksumCertifier> deliveryChecksumCertifierMap;

    static {
        deliveryChecksumCertifierMap = Collections.synchronizedMap(new HashMap());
        try {
            MD5Digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected DeliveryChecksumCertifier() {
    }

    public boolean validateCertifiedCheckSum(String checksumToValidate, String value) throws Exception {
        String decodedChecksum = null;
        try {
            decodedChecksum = this.passwordManager.decryptPassword(checksumToValidate);
        }
        catch (Exception e) {
            throw new Exception(Messages.getString((String)"CertifierChecksumHelper.0"), e);
        }
        String validationCheckSum = this.generateCertifiedCheckSum(value, false);
        return validationCheckSum.equals(decodedChecksum);
    }

    public String generateCertifiedCheckSum(String value, boolean encrypt) {
        try {
            value = "uuidi^d" + value + "/$$s$";
            byte[] array = MD5Digest.digest(value.getBytes("UTF-8"));
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < array.length) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
                ++i;
            }
            String s = sb.toString();
            if (encrypt) {
                s = this.passwordManager.encryptPassword(s);
            }
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void init(IPasswordManagerDelegate iPasswordManager) {
        this.passwordManager = iPasswordManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDeliveryChecksumCertifier getChecksumHelper(IPasswordManagerDelegate passwordManagerDelegate) {
        Map<IPasswordManagerDelegate, IDeliveryChecksumCertifier> map = deliveryChecksumCertifierMap;
        synchronized (map) {
            DeliveryChecksumCertifier deliveryChecksumCertifier = (DeliveryChecksumCertifier)deliveryChecksumCertifierMap.get(passwordManagerDelegate);
            if (deliveryChecksumCertifier == null) {
                deliveryChecksumCertifier = new DeliveryChecksumCertifier();
                deliveryChecksumCertifier.init(passwordManagerDelegate);
                deliveryChecksumCertifierMap.put(passwordManagerDelegate, deliveryChecksumCertifier);
            }
            return deliveryChecksumCertifier;
        }
    }
}

