/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.engine.common;

import com.indy.engine.common.client.ClientConfiguration;
import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.FunctionType;
import com.indy.engine.core.common.LocalSession;
import com.indy.engine.core.common.RemoteSessionInfo;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.engine.common.Messages;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xml.sax.SAXException;

public class EngineFactory {
    public static final String JSON_METHOD_NAME = "method";
    public static final String JSON_PARAMETER_TYPES = "parametersTypes";
    public static final String JSON_PARAMETER_VALUES = "params";
    private static ClientConfiguration clientConfiguration;
    private static final HostnameVerifier hv;
    static final TrustManager[] ingoreTrustStore;
    public static final String FUNCTION_THREAD;
    public static final String FUNCTION_CLIENT_RMI;
    public static final String FUNCTION_DIRECTORY_EXIST;
    public static final String FUNCTION_GET_DELIVERY_PARAMS;
    public static final String FUNCTION_GET_INETADDRESS;
    public static final String FUNCTION_MONITORING_SUMMARY;
    public static final String FUNCTION_PING;
    public static final String FUNCTION_TEST_CONNECTION;
    public static final String HTTP_REQUEST_HEADER_SESSION_ID = "com.indy.engine.common.EngineFactory.sessionId";

    static {
        hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        ingoreTrustStore = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            File _file;
            String file = System.getProperty("xdi.runtime.client.configuration.file.path");
            if (file == null) {
                file = System.getProperty("stambia.client.configuration");
            }
            if (file != null && (_file = new File(file)).exists()) {
                EngineFactory.setClientConfiguration(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FUNCTION_THREAD = FunctionType.getAllThreads.name();
        FUNCTION_CLIENT_RMI = FunctionType.getConnectedClient.name();
        FUNCTION_DIRECTORY_EXIST = FunctionType.doesDirectoryExist.name();
        FUNCTION_GET_DELIVERY_PARAMS = FunctionType.getDeliveryParams.name();
        FUNCTION_GET_INETADDRESS = FunctionType.getInetAddress.name();
        FUNCTION_MONITORING_SUMMARY = FunctionType.getMonitoringSummary.name();
        FUNCTION_PING = FunctionType.ping.name();
        FUNCTION_TEST_CONNECTION = FunctionType.testConnection.name();
    }

    public static void setClientConfiguration(String file) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        clientConfiguration = ClientConfiguration.getClientConfiguration(new FileInputStream(file));
    }

    public static boolean connectionExists(String name) {
        if (clientConfiguration != null) {
            return clientConfiguration.getConnection(name) != null;
        }
        return false;
    }

    public static LocalSession connectTo(String name, ClientConfiguration.ConnectionListener listener) throws Exception {
        if (clientConfiguration != null) {
            return clientConfiguration.connectTo(name, listener);
        }
        throw new Exception(String.valueOf(Messages.getString("EngineFactory.0")) + name);
    }

    public static LocalSession getEngine(String host, int port, Map<String, String> credentials, int enableSSL) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("enableSSL", enableSSL);
        return EngineFactory.getEngine(host, port, properties, credentials);
    }

    public static LocalSession getEngine(String host, int port, Map<String, String> credentials) throws Exception {
        return EngineFactory.getEngine(host, port, null, credentials);
    }

    public static LocalSession getEngine(String host, int port, Map<String, Object> properties, Map<String, String> credentials) throws Exception {
        Protocol protocol = null;
        String _protocol = (String)(properties != null ? properties.get("protocol") : null);
        if (_protocol == null) {
            if (host.startsWith("https://")) {
                protocol = Protocol.https;
            } else if (host.startsWith("http://")) {
                protocol = Protocol.http;
            } else {
                if (host.startsWith("rmi://") || host.startsWith("rmis://")) {
                    throw new Exception(Messages.getString("EngineFactory.5"));
                }
                protocol = Protocol.auto;
            }
        } else {
            protocol = Protocol.valueOf(_protocol);
        }
        URL url = protocol == Protocol.auto ? new URL("http://" + host + "/client/1") : new URL(String.valueOf(host) + "/client/1");
        url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
        LocalSession ls = EngineFactory.getHttpEngine(url, credentials);
        IEngineClient engine = ls.getRemoteObject();
        if (engine == null) {
            throw new Exception(Messages.getString("EngineFactory.1"));
        }
        ls.getRemoteObject().isConnected();
        return ls;
    }

    private static LocalSession getHttpEngine(final URL url, Map<String, String> credentials) throws Exception {
        String user = credentials != null ? credentials.get("user") : null;
        String encoded = null;
        if (user != null) {
            String password = credentials.getOrDefault("password", credentials.get("uncryptedPassword"));
            encoded = DatatypeConverter.printBase64Binary((byte[])(String.valueOf(user) + ":" + password).getBytes());
        }
        final String auth = encoded != null ? "Basic " + encoded : null;
        final String sessionID = UUID.randomUUID().toString();
        IEngineClient ret = (IEngineClient)Proxy.newProxyInstance(IEngineClient.class.getClassLoader(), new Class[]{IEngineClient.class}, new InvocationHandler(){
            SSLContext httpSSLContext;

            private SSLContext getSSLContext() {
                try {
                    if (this.httpSSLContext == null) {
                        String val = (String)System.getProperties().get("com.stambia.runtime.https.ignoreCertCheck");
                        if (val != null && val.equals("true")) {
                            String protocol = (String)System.getProperties().get("com.stambia.runtime.https.ignoreCertCheckProtocol");
                            if (protocol == null) {
                                protocol = "SSL";
                            }
                            SSLContext ctx = SSLContext.getInstance(protocol);
                            ctx.init(null, ingoreTrustStore, new SecureRandom());
                            this.httpSSLContext = ctx;
                        } else {
                            this.httpSSLContext = SSLContext.getDefault();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return this.httpSSLContext;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                InputStream is;
                HttpURLConnection connection = null;
                String requestAsString = null;
                connection = (HttpURLConnection)url.openConnection();
                if (connection instanceof HttpsURLConnection) {
                    connection.setRequestProperty("Connection", "keep-alive");
                    ((HttpsURLConnection)connection).setHostnameVerifier(hv);
                    ((HttpsURLConnection)connection).setSSLSocketFactory(this.getSSLContext().getSocketFactory());
                }
                if (auth != null) {
                    connection.setRequestProperty("Authorization", auth);
                }
                connection.setRequestProperty(EngineFactory.HTTP_REQUEST_HEADER_SESSION_ID, sessionID);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                Map request = this.parseRequest(method, args);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                JsonNode.serialize((Object)request, (OutputStream)baos, (String)"UTF-8");
                requestAsString = new String(baos.toByteArray(), "UTF-8");
                connection.setRequestProperty("Accept-Encoding", "deflate");
                if (method.getName().equals("putDelivery") || method.getName().equals("initSessionWithStream")) {
                    connection.setRequestProperty("Params-In-Header", requestAsString);
                    is = (InputStream)args[0];
                } else {
                    is = new ByteArrayInputStream(requestAsString.getBytes("UTF-8"));
                }
                OutputStream os = connection.getOutputStream();
                IOUtils.copy((InputStream)is, (OutputStream)os);
                is.close();
                os.close();
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("PARSE_BSON_DATATYPE", true);
                map.put("INTEGER_AS_INTEGER_OR_LONG", true);
                if (connection.getResponseCode() >= 400) {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        BufferedInputStream stream = new BufferedInputStream(connection.getErrorStream());
                        try {
                            StringBuffer buf = new StringBuffer();
                            Throwable throwable2 = null;
                            Object var16_20 = null;
                            try (Scanner scanner = new Scanner(stream);){
                                scanner.useDelimiter("\\A");
                                buf.append(scanner.next());
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            throw new IOException(buf.toString());
                        }
                        catch (Throwable throwable4) {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                Object o = JsonUtils.jsonNodeToObject((InputStream)connection.getInputStream(), (String)"UTF-8", map);
                return o;
            }

            private Map parseRequest(Method method, Object[] args) {
                HashMap<String, Object> request = new HashMap<String, Object>();
                request.put(EngineFactory.JSON_METHOD_NAME, method.getName());
                ArrayList<String> parametersTypes = new ArrayList<String>();
                Class<?>[] classArray = method.getParameterTypes();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    parametersTypes.add(c.getName());
                    ++n2;
                }
                request.put(EngineFactory.JSON_PARAMETER_TYPES, parametersTypes);
                if (args != null) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    Object[] objectArray = args;
                    int n3 = args.length;
                    n = 0;
                    while (n < n3) {
                        Object obj = objectArray[n];
                        if (!(obj instanceof InputStream)) {
                            params.add(obj);
                        }
                        ++n;
                    }
                    request.put(EngineFactory.JSON_PARAMETER_VALUES, params);
                }
                return request;
            }
        });
        LocalSession cc = new LocalSession(url.getHost(), url.getPort(), Boolean.valueOf(url.toString().startsWith("https")), Boolean.valueOf(true), ret, new RemoteSessionInfo(sessionID, url.getHost(), user));
        return cc;
    }

    public static enum Protocol {
        http,
        https,
        auto;

    }
}

