/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceWrapperImpl;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import com.semarchy.xdi.runtime.connection.jdbc.DriverManagerDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.HikariDataSourceImpl;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceManager {
    private static final DataSourceManager INSTANCE = new DataSourceManager();
    private CacheLoader<DataSourceConfiguration, DataSource> dataSourceCacheLoader = new CacheLoader<DataSourceConfiguration, DataSource>(){

        public DataSource load(DataSourceConfiguration config) {
            return this.doCreateDataSource(config);
        }

        private DataSource doCreateDataSource(DataSourceConfiguration configuration) {
            return configuration.isEnablePool() ? new HikariDataSourceImpl(configuration.jdbcParameters(), configuration.isResolveExternalSecrets()) : new DriverManagerDataSourceImpl(configuration.jdbcParameters(), configuration.isResolveExternalSecrets());
        }
    };
    private RemovalListener<DataSourceConfiguration, DataSource> removalListener = entry -> {
        if (entry.getValue() instanceof AbstractDataSourceWrapperImpl) {
            try {
                ((AbstractDataSourceWrapperImpl)entry.getValue()).close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private LoadingCache<DataSourceConfiguration, DataSource> dataSourceCache = DataSourceManager.cacheBuilderSpecProperty("xdi.runtime.jdbcDataSourceCache", (CacheBuilder<Object, Object>)CacheBuilder.newBuilder()).removalListener(this.removalListener).build(this.dataSourceCacheLoader);

    private DataSourceManager() {
        Thread thread = new Thread(() -> this.dataSourceCache.invalidateAll());
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public static DataSourceManager instance() {
        return INSTANCE;
    }

    private static CacheBuilder<Object, Object> cacheBuilderSpecProperty(String propName, CacheBuilder<Object, Object> defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        try {
            CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse((String)propValue);
            return CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public DataSource getDataSource(DataSourceConfiguration configuration) {
        return (DataSource)this.dataSourceCache.getUnchecked((Object)configuration);
    }
}

