/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class JdbcParameters {
    private String driver;
    private String url;
    private String username;
    private String password;
    private String moduleName;
    private final Properties properties = new Properties();
    private int connectionTimeout = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.connectionTimeout", "30000"));
    private List<String> initSqls = new ArrayList<String>();
    private boolean autocommit = !Boolean.getBoolean("com.semarchy.xdi.runtime.jdbc.disableDefaultAutocommit");
    private int idleTimeout = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolIdleTimeout", "600000"));
    private int keepAliveTime = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolKeepAlive", "0"));
    private int maxLifetime = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMaxLifetime", "1800000"));
    private int minimumIdle = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMinIdle", "0"));
    private int maximumPoolSize = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolMaxSize", "20"));
    private int validationTimeout = Integer.parseInt(System.getProperty("com.semarchy.xdi.runtime.jdbc.poolValidationTimeout", "5000"));
    private String validationQuery = System.getProperty("com.semarchy.xdi.runtime.jdbc.poolValidationQuery");

    public List<String> getInitSqls() {
        return this.initSqls;
    }

    public JdbcParameters initSqls(List<String> initSqls) {
        this.initSqls = initSqls;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public JdbcParameters idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public JdbcParameters keepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        return this;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public JdbcParameters maxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
        return this;
    }

    public int getMinimumIdle() {
        return this.minimumIdle;
    }

    public JdbcParameters minimumIdle(int minimumIdle) {
        this.minimumIdle = minimumIdle;
        return this;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public JdbcParameters maximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        return this;
    }

    public int getValidationTimeout() {
        return this.validationTimeout;
    }

    public JdbcParameters validationTimeout(int validationTimeout) {
        this.validationTimeout = validationTimeout;
        return this;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public JdbcParameters validationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public JdbcParameters autocommit(boolean autocommit) {
        this.autocommit = autocommit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public JdbcParameters connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public JdbcParameters moduleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public JdbcParameters addProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getDriver() {
        return this.driver;
    }

    public JdbcParameters driver(String driver) {
        this.driver = driver;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public JdbcParameters url(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public JdbcParameters username(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public JdbcParameters password(String password) {
        this.password = password;
        return this;
    }

    public JdbcParameters connectionInitSqls(Collection<String> initSqls2) {
        this.initSqls.addAll(initSqls2);
        return this;
    }

    public List<String> getConnectionInitSqls() {
        return Collections.unmodifiableList(this.initSqls);
    }

    public int hashCode() {
        return Objects.hash(this.autocommit, this.connectionTimeout, this.driver, this.idleTimeout, this.initSqls, this.keepAliveTime, this.maxLifetime, this.maximumPoolSize, this.minimumIdle, this.moduleName, this.password, this.properties, this.url, this.username, this.validationQuery, this.validationTimeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcParameters other = (JdbcParameters)obj;
        return this.autocommit == other.autocommit && this.connectionTimeout == other.connectionTimeout && Objects.equals(this.driver, other.driver) && this.idleTimeout == other.idleTimeout && Objects.equals(this.initSqls, other.initSqls) && this.keepAliveTime == other.keepAliveTime && this.maxLifetime == other.maxLifetime && this.maximumPoolSize == other.maximumPoolSize && this.minimumIdle == other.minimumIdle && Objects.equals(this.moduleName, other.moduleName) && Objects.equals(this.password, other.password) && Objects.equals(this.properties, other.properties) && Objects.equals(this.url, other.url) && Objects.equals(this.username, other.username) && Objects.equals(this.validationQuery, other.validationQuery) && this.validationTimeout == other.validationTimeout;
    }
}

