/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;

public class ContentTypeCacheLevelImpl
extends MapCacheLevelImpl {
    private static final long serialVersionUID = 1L;

    public ContentTypeCacheLevelImpl() {
        this.enableKeyFallback(null);
    }

    @Override
    public Object get(String key) {
        return super.get(ContentTypeCacheLevelImpl.normalize(key));
    }

    @Override
    public void put(Object value, String key) {
        super.put(value, ContentTypeCacheLevelImpl.normalize(key));
    }

    @Override
    public void remove(String key) {
        super.remove(ContentTypeCacheLevelImpl.normalize(key));
    }

    private static String normalize(String key) {
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(32);
        int parameterStart = 0;
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (c == ';') {
                    parameterStart = i;
                    break;
                }
                sb.append(Character.toLowerCase(c));
            }
            ++i;
        }
        if (parameterStart > 0) {
            TreeMap<String, String> parameter = new TreeMap<String, String>();
            StringBuilder ksb = new StringBuilder(32);
            StringBuilder vsb = new StringBuilder(32);
            boolean isKey = true;
            int i2 = parameterStart + 1;
            while (i2 < key.length()) {
                char c = key.charAt(i2);
                if (!Character.isWhitespace(c)) {
                    if (isKey) {
                        if (c == '=') {
                            isKey = false;
                        } else {
                            ksb.append(Character.toLowerCase(c));
                        }
                    } else if (c == ';') {
                        isKey = true;
                        parameter.put(ksb.toString(), vsb.toString());
                        ksb.setLength(0);
                        vsb.setLength(0);
                    } else if (c != '\"') {
                        vsb.append(Character.toLowerCase(c));
                    }
                }
                ++i2;
            }
            if (ksb.length() > 0) {
                parameter.put(ksb.toString(), vsb.toString());
            }
            for (Map.Entry entry : parameter.entrySet()) {
                sb.append(';');
                sb.append((String)entry.getKey());
                sb.append('=');
                sb.append((String)entry.getValue());
            }
        }
        return sb.toString();
    }
}

