/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Locale;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertificateAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientCertificateAuthenticationProvider.class);
    private SSLSocketFactory socketFactory;

    @Override
    public void setSession(BindingSession session) {
        Object keyfile;
        super.setSession(session);
        if (this.socketFactory == null && (keyfile = this.getSession().get("org.apache.chemistry.opencmis.clientcerts.keyfile")) instanceof String) {
            Object passphrase = this.getSession().get("org.apache.chemistry.opencmis.clientcerts.passphrase");
            String keyfileStr = ((String)keyfile).trim();
            String passphraseStr = passphrase instanceof String ? ((String)passphrase).trim() : null;
            this.socketFactory = this.createSSLSocketFactory(keyfileStr, passphraseStr);
        }
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return this.socketFactory;
    }

    protected SSLSocketFactory createSSLSocketFactory(String keyFile, String passphrase) {
        assert (keyFile != null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using key file '{}'", (Object)keyFile);
        }
        try {
            char[] passphraseChars = passphrase == null ? null : passphrase.toCharArray();
            String ext = this.getExtension(keyFile);
            KeyStore keyStore = "p12".equals(ext) || "pfx".equals(ext) ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("JKS");
            BufferedInputStream keyStream = null;
            try {
                keyStream = new BufferedInputStream(new FileInputStream(keyFile));
                keyStore.load(keyStream, passphraseChars);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(keyStream);
                throw throwable;
            }
            IOUtils.closeQuietly(keyStream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Key store type: {}", (Object)keyStore.getType());
                StringBuilder sb = new StringBuilder();
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(aliases.nextElement());
                }
                LOG.debug("Aliases in key store: {}", (Object)sb.toString());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, passphraseChars);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), null, null);
            return context.getSocketFactory();
        }
        catch (FileNotFoundException fnfe) {
            throw new CmisRuntimeException("Key file '" + keyFile + "' not found!", fnfe);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Cannot set up client certificate: " + e.toString(), e);
        }
    }

    private String getExtension(String filename) {
        int x = filename.lastIndexOf(46);
        if (x > -1) {
            return filename.substring(x + 1).toLowerCase(Locale.ENGLISH);
        }
        return null;
    }
}

