/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.util.HashMap;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.CmisSpi;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AclServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.DiscoveryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.MultiFilingServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.NavigationServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.ObjectServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.PolicyServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.RelationshipServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.RepositoryServiceImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.local.VersioningServiceImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;
import org.apache.chemistry.opencmis.commons.spi.PolicyService;
import org.apache.chemistry.opencmis.commons.spi.RelationshipService;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisLocalSpi
implements CmisSpi {
    private static final Logger LOG = LoggerFactory.getLogger(CmisLocalSpi.class);
    private final CmisServiceFactory factory;
    private final RepositoryService repositoryService;
    private final NavigationService navigationService;
    private final ObjectService objectService;
    private final VersioningService versioningService;
    private final DiscoveryService discoveryService;
    private final MultiFilingService multiFilingService;
    private final RelationshipService relationshipService;
    private final PolicyService policyService;
    private final AclService aclService;

    public CmisLocalSpi(BindingSession session) {
        String serviceFactoryClassname;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {}: Initializing local SPI...", (Object)session.getSessionId());
        }
        if ((serviceFactoryClassname = (String)session.get("org.apache.chemistry.opencmis.binding.local.classname")) == null) {
            throw new CmisConnectionException("Factory class not set!");
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (String key : session.getKeys()) {
                Object value = session.get(key);
                if (!(value instanceof String)) continue;
                parameters.put(key, (String)value);
            }
            this.factory = (CmisServiceFactory)ClassLoaderUtil.loadClass(serviceFactoryClassname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.factory.init(parameters);
        }
        catch (Exception e) {
            throw new CmisConnectionException("Factory cannot be created: " + e.getMessage(), e);
        }
        this.repositoryService = new RepositoryServiceImpl(session, this.factory);
        this.navigationService = new NavigationServiceImpl(session, this.factory);
        this.objectService = new ObjectServiceImpl(session, this.factory);
        this.versioningService = new VersioningServiceImpl(session, this.factory);
        this.discoveryService = new DiscoveryServiceImpl(session, this.factory);
        this.multiFilingService = new MultiFilingServiceImpl(session, this.factory);
        this.relationshipService = new RelationshipServiceImpl(session, this.factory);
        this.policyService = new PolicyServiceImpl(session, this.factory);
        this.aclService = new AclServiceImpl(session, this.factory);
    }

    @Override
    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    @Override
    public NavigationService getNavigationService() {
        return this.navigationService;
    }

    @Override
    public ObjectService getObjectService() {
        return this.objectService;
    }

    @Override
    public DiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    @Override
    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    @Override
    public MultiFilingService getMultiFilingService() {
        return this.multiFilingService;
    }

    @Override
    public RelationshipService getRelationshipService() {
        return this.relationshipService;
    }

    @Override
    public PolicyService getPolicyService() {
        return this.policyService;
    }

    @Override
    public AclService getAclService() {
        return this.aclService;
    }

    @Override
    public void clearAllCaches() {
    }

    @Override
    public void clearRepositoryCache(String repositoryId) {
    }

    @Override
    public void close() {
        this.factory.destroy();
    }
}

