/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

public class RepositoryServiceImpl
extends AbstractLocalService
implements RepositoryService {
    public RepositoryServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            RepositoryInfo serviceResult = service.getRepositoryInfo(repositoryId, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            RepositoryInfo repositoryInfo = serviceResult;
            return repositoryInfo;
        }
    }

    @Override
    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        try (CmisService service = this.getService(null);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            List<RepositoryInfo> serviceResult = service.getRepositoryInfos(extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            List<RepositoryInfo> list = serviceResult;
            return list;
        }
    }

    @Override
    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            TypeDefinition serviceResult = service.getTypeDefinition(repositoryId, typeId, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    @Override
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            TypeDefinitionList serviceResult = service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            TypeDefinitionList typeDefinitionList = serviceResult;
            return typeDefinitionList;
        }
    }

    @Override
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            List<TypeDefinitionContainer> serviceResult = service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            List<TypeDefinitionContainer> list = serviceResult;
            return list;
        }
    }

    @Override
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            TypeDefinition serviceResult = service.createType(repositoryId, type, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    @Override
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return null;
            }
            TypeDefinition serviceResult = service.updateType(repositoryId, type, extension);
            if (this.stopAfterService(service)) {
                return null;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    @Override
    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteType(repositoryId, typeId, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }
}

