/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.io.StringWriter;
import java.math.BigInteger;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.RepositoryInfoCache;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractWebServicesService {
    private static final String ADDITIONAL_DATA_NS = "http://chemistry.apache.org/opencmis/exception";
    private static final String ADDITIONAL_DATA_TAG = "additionalData";
    private BindingSession session;

    protected void setSession(BindingSession session) {
        this.session = session;
    }

    protected BindingSession getSession() {
        return this.session;
    }

    protected CmisBaseException convertException(CmisException ex) {
        if (ex == null || ex.getFaultInfo() == null) {
            return new CmisRuntimeException("CmisException has no fault!");
        }
        String msg = ex.getFaultInfo().getMessage();
        BigInteger code = ex.getFaultInfo().getCode();
        String errorContent = null;
        HashMap<String, String> additionalData = null;
        if (!ex.getFaultInfo().getAny().isEmpty()) {
            StringBuilder sb = new StringBuilder(1024);
            for (Object o : ex.getFaultInfo().getAny()) {
                if (o == null) continue;
                if (o instanceof Node) {
                    Node node = (Node)o;
                    if (ADDITIONAL_DATA_NS.equals(node.getNamespaceURI()) && ADDITIONAL_DATA_TAG.equals(node.getNodeName())) {
                        NodeList entries = node.getChildNodes();
                        int n = entries.getLength();
                        int i = 0;
                        while (i < n) {
                            Node entry = entries.item(i);
                            if ("entry".equals(entry.getNodeName())) {
                                String key = null;
                                String value = null;
                                NodeList keyValueList = entry.getChildNodes();
                                int n2 = keyValueList.getLength();
                                int j = 0;
                                while (j < n2) {
                                    Node item = keyValueList.item(j);
                                    if ("key".equals(item.getNodeName())) {
                                        key = item.getTextContent();
                                    } else if ("value".equals(item.getNodeName())) {
                                        value = item.getTextContent();
                                    }
                                    ++j;
                                }
                                if (key != null && value != null) {
                                    if (additionalData == null) {
                                        additionalData = new HashMap<String, String>();
                                    }
                                    additionalData.put(key, value);
                                }
                            }
                            ++i;
                        }
                    }
                    sb.append(AbstractWebServicesService.getNodeAsString(node));
                } else {
                    sb.append(o.toString());
                }
                sb.append('\n');
            }
            errorContent = sb.toString();
        }
        switch (ex.getFaultInfo().getType()) {
            case CONSTRAINT: {
                return new CmisConstraintException(msg, code, errorContent, additionalData);
            }
            case CONTENT_ALREADY_EXISTS: {
                return new CmisContentAlreadyExistsException(msg, code, errorContent, additionalData);
            }
            case FILTER_NOT_VALID: {
                return new CmisFilterNotValidException(msg, code, errorContent, additionalData);
            }
            case INVALID_ARGUMENT: {
                return new CmisInvalidArgumentException(msg, code, errorContent, additionalData);
            }
            case NAME_CONSTRAINT_VIOLATION: {
                return new CmisNameConstraintViolationException(msg, code, errorContent, additionalData);
            }
            case NOT_SUPPORTED: {
                return new CmisNotSupportedException(msg, code, errorContent, additionalData);
            }
            case OBJECT_NOT_FOUND: {
                return new CmisObjectNotFoundException(msg, code, errorContent, additionalData);
            }
            case PERMISSION_DENIED: {
                return new CmisPermissionDeniedException(msg, code, errorContent, additionalData);
            }
            case RUNTIME: {
                return new CmisRuntimeException(msg, code, errorContent, additionalData);
            }
            case STORAGE: {
                return new CmisStorageException(msg, code, errorContent, additionalData);
            }
            case STREAM_NOT_SUPPORTED: {
                return new CmisStreamNotSupportedException(msg, code, errorContent, additionalData);
            }
            case UPDATE_CONFLICT: {
                return new CmisUpdateConflictException(msg, code, errorContent, additionalData);
            }
            case VERSIONING: {
                return new CmisVersioningException(msg, code, errorContent, additionalData);
            }
        }
        return new CmisRuntimeException("Unknown exception[" + ex.getFaultInfo().getType().value() + "]: " + msg);
    }

    private static String getNodeAsString(Node node) {
        try {
            Transformer transformer = XMLUtils.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter(512);
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            assert (false);
            return "";
        }
    }

    protected CmisVersion getCmisVersion(String repositoryId) {
        if (CmisBindingsHelper.getForcedCmisVersion(this.session) != null) {
            return CmisBindingsHelper.getForcedCmisVersion(this.session);
        }
        RepositoryInfoCache cache = CmisBindingsHelper.getRepositoryInfoCache(this.session);
        RepositoryInfo info = cache.get(repositoryId);
        if (info == null && (info = CmisBindingsHelper.getSPI(this.session).getRepositoryService().getRepositoryInfo(repositoryId, null)) != null) {
            cache.put(info);
        }
        return info == null ? CmisVersion.CMIS_1_0 : info.getCmisVersion();
    }
}

