/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryEntryType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRepositoryInfoType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

public class RepositoryServiceImpl
extends AbstractWebServicesService
implements RepositoryService {
    private final AbstractPortProvider portProvider;

    public RepositoryServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    @Override
    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        CmisVersion cmisVersion = CmisBindingsHelper.getForcedCmisVersion(this.getSession());
        if (cmisVersion == null) {
            cmisVersion = CmisVersion.CMIS_1_1;
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositories");
        List<CmisRepositoryEntryType> entries = null;
        try {
            try {
                entries = port.getRepositories(WSConverter.convert(extension));
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), e);
            }
        }
        finally {
            this.portProvider.endCall(port);
        }
        ArrayList<RepositoryInfo> infos = null;
        if (entries != null) {
            port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositoryInfo");
            try {
                try {
                    infos = new ArrayList<RepositoryInfo>();
                    for (CmisRepositoryEntryType entry : entries) {
                        try {
                            CmisRepositoryInfoType info = port.getRepositoryInfo(entry.getRepositoryId(), null);
                            infos.add(WSConverter.convert(info));
                        }
                        catch (CmisBaseException e) {
                            RepositoryInfoImpl info = new RepositoryInfoImpl();
                            info.setId(entry.getRepositoryId());
                            info.setName(entry.getRepositoryName());
                            infos.add(info);
                        }
                    }
                }
                catch (CmisException e) {
                    throw this.convertException(e);
                }
                catch (Exception e) {
                    throw new CmisRuntimeException("Error: " + e.getMessage(), e);
                }
            }
            finally {
                this.portProvider.endCall(port);
            }
        }
        return infos;
    }

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        CmisVersion cmisVersion = CmisBindingsHelper.getForcedCmisVersion(this.getSession());
        if (cmisVersion == null) {
            cmisVersion = CmisVersion.CMIS_1_1;
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(cmisVersion, "getRepositoryInfo");
        try {
            RepositoryInfo repositoryInfo = WSConverter.convert(port.getRepositoryInfo(repositoryId, WSConverter.convert(extension)));
            return repositoryInfo;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeDefinition");
        try {
            TypeDefinition typeDefinition = WSConverter.convert(port.getTypeDefinition(repositoryId, typeId, WSConverter.convert(extension)));
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeChildren");
        try {
            TypeDefinitionList typeDefinitionList = WSConverter.convert(port.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, WSConverter.convert(extension)));
            return typeDefinitionList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(this.getCmisVersion(repositoryId), "getTypeDescendants");
        try {
            List<TypeDefinitionContainer> list = WSConverter.convertTypeContainerList(port.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, WSConverter.convert(extension)));
            return list;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "createType");
        try {
            Holder typeDef = new Holder((Object)WSConverter.convert(type));
            port.createType(repositoryId, (Holder<CmisTypeDefinitionType>)typeDef, WSConverter.convert(extension));
            TypeDefinition typeDefinition = WSConverter.convert((CmisTypeDefinitionType)typeDef.value);
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "updateType");
        try {
            Holder typeDef = new Holder((Object)WSConverter.convert(type));
            port.updateType(repositoryId, (Holder<CmisTypeDefinitionType>)typeDef, WSConverter.convert(extension));
            TypeDefinition typeDefinition = WSConverter.convert((CmisTypeDefinitionType)typeDef.value);
            return typeDefinition;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        if (this.getCmisVersion(repositoryId) == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("Repository is a CMIS 1.0 repository!");
        }
        RepositoryServicePort port = this.portProvider.getRepositoryServicePort(CmisVersion.CMIS_1_1, "deleteType");
        try {
            try {
                Holder<CmisExtensionType> portExtension = WSConverter.convertExtensionHolder(extension);
                port.deleteType(repositoryId, typeId, portExtension);
                WSConverter.setExtensionValues(portExtension, extension);
            }
            catch (CmisException e) {
                throw this.convertException(e);
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Error: " + e.getMessage(), e);
            }
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

