/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.bindings.cache.TypeDefinitionCache;
import org.apache.chemistry.opencmis.client.runtime.CmisBindingHelper;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.cache.Cache;
import org.apache.chemistry.opencmis.client.runtime.repository.RepositoryImpl;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class SessionFactoryImpl
implements SessionFactory,
Serializable {
    private static final long serialVersionUID = 1L;

    protected SessionFactoryImpl() {
    }

    public static SessionFactoryImpl newInstance() {
        return new SessionFactoryImpl();
    }

    @Override
    public Session createSession(Map<String, String> parameters) {
        return this.createSession(parameters, null, null, null, null);
    }

    public Session createSession(Map<String, String> parameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache, TypeDefinitionCache typeDefCache) {
        SessionImpl session = new SessionImpl(parameters, objectFactory, authenticationProvider, cache, typeDefCache);
        session.connect();
        return session;
    }

    @Override
    public List<Repository> getRepositories(Map<String, String> parameters) {
        return this.getRepositories(parameters, null, null, null, null);
    }

    public List<Repository> getRepositories(Map<String, String> parameters, ObjectFactory objectFactory, AuthenticationProvider authenticationProvider, Cache cache, TypeDefinitionCache typeDefCache) {
        CmisBinding binding = CmisBindingHelper.createBinding(parameters, authenticationProvider, typeDefCache);
        List<RepositoryInfo> repositoryInfos = binding.getRepositoryService().getRepositoryInfos(null);
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (RepositoryInfo data : repositoryInfos) {
            result.add(new RepositoryImpl(data, parameters, this, objectFactory, binding.getAuthenticationProvider(), cache, typeDefCache));
        }
        return result;
    }
}

