/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.PacketOutputStream;
import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamWrapper;
import com.healthmarketscience.rmiio.RemoteRetry;
import com.healthmarketscience.rmiio.util.EncodingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteInputStreamClient {
    protected static final Log LOG = LogFactory.getLog(RemoteInputStreamClient.class);

    private RemoteInputStreamClient() {
    }

    public static InputStream wrap(RemoteInputStream remoteIn) throws IOException {
        return RemoteInputStreamClient.wrap(remoteIn, RemoteClient.DEFAULT_RETRY);
    }

    public static InputStream wrap(RemoteInputStream remoteIn, RemoteRetry retry) throws IOException {
        InputStream retStream;
        if (retry == null) {
            retry = RemoteClient.DEFAULT_RETRY;
        }
        if (((RemoteInputStreamImpl)(retStream = new RemoteInputStreamImpl(remoteIn, retry)))._remoteIn.usingGZIPCompression()) {
            retStream = new SaferGZIPInputStream(retStream, 7168);
        }
        return retStream;
    }

    private static class SaferGZIPInputStream
    extends GZIPInputStream {
        private SaferGZIPInputStream(InputStream in, int size) throws IOException {
            super(in, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Exception closeFailure = null;
            try {
                super.close();
            }
            catch (Exception e) {
                closeFailure = e;
            }
            finally {
                this.in.close();
            }
            if (closeFailure != null) {
                if (closeFailure instanceof IOException) {
                    throw (IOException)closeFailure;
                }
                throw (RuntimeException)closeFailure;
            }
        }
    }

    private static final class RemoteInputStreamImpl
    extends EncodingInputStream {
        private final RemoteInputStream _remoteIn;
        private final PacketOutputStream _ostream;
        private int nextActionId = 0;
        private volatile boolean _remoteCloseSuccessful;
        private volatile boolean _readSuccess = true;

        public RemoteInputStreamImpl(RemoteInputStream remoteIn, RemoteRetry retry) {
            super(7168);
            this._remoteIn = new RemoteInputStreamWrapper(remoteIn, retry, LOG);
            this._ostream = this.createOutputStream();
        }

        public synchronized int available() throws IOException {
            return super.available();
        }

        public synchronized int read() throws IOException {
            return super.read();
        }

        public synchronized int read(byte[] b) throws IOException {
            return super.read(b);
        }

        public synchronized int read(byte[] buf, int pos, int len) throws IOException {
            return super.read(buf, pos, len);
        }

        public synchronized long skip(long len) throws IOException {
            return super.skip(len);
        }

        public synchronized byte[] readPacket(boolean readPartial) throws IOException {
            return super.readPacket(readPartial);
        }

        public synchronized int packetsAvailable() throws IOException {
            return super.packetsAvailable();
        }

        public void close() throws IOException {
            if (this._remoteCloseSuccessful) {
                return;
            }
            this._remoteIn.close(this._readSuccess);
            this._remoteCloseSuccessful = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void encode(int suggestedLength) throws IOException {
            boolean success = false;
            byte[] packet = null;
            try {
                packet = this._remoteIn.readPacket(this.nextActionId++);
                success = true;
            }
            finally {
                if (!success) {
                    this._readSuccess = false;
                }
            }
            if (packet != null) {
                this._ostream.writePacket(packet);
            } else {
                this._ostream.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long encodeSkip(long len) throws IOException {
            boolean success = false;
            try {
                long result = this._remoteIn.skip(len, this.nextActionId++);
                success = true;
                long l = result;
                return l;
            }
            finally {
                if (!success) {
                    this._readSuccess = false;
                }
            }
        }
    }
}

