/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamMonitor;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteInputStreamServer
extends RemoteStreamServer<RemoteInputStreamServer, RemoteInputStream>
implements RemoteInputStream {
    private static final long serialVersionUID = 20080212L;
    public static final int DEFAULT_CHUNK_SIZE = 7168;
    public static final RemoteStreamMonitor<RemoteInputStreamServer> DUMMY_MONITOR = new RemoteInputStreamMonitor();
    protected final transient InputStream _in;
    protected final transient int _chunkSize;
    private transient int _lastPacketId = -1;
    private transient byte[] _lastPacket;
    private transient int _lastSkipId = -1;
    private transient long _lastSkip;

    protected RemoteInputStreamServer(InputStream in) {
        this(in, DUMMY_MONITOR, 7168);
    }

    protected RemoteInputStreamServer(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor) {
        this(in, monitor, 7168);
    }

    public RemoteInputStreamServer(InputStream in, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize) {
        super(monitor);
        this._in = in;
        this._chunkSize = chunkSize;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    @Override
    protected final Object getLock() {
        return this._in;
    }

    @Override
    protected RemoteInputStreamServer getAsSub() {
        return this;
    }

    @Override
    public Class<RemoteInputStream> getRemoteClass() {
        return RemoteInputStream.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl(boolean readSuccess) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this._in.close();
        }
    }

    @Override
    public final void close(boolean readSuccess) throws IOException {
        this.finish(true, readSuccess);
    }

    @Override
    public final int available() throws IOException {
        this.checkAborted();
        return this.availableImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] readPacket(int packetId) throws IOException {
        if (packetId < 0) {
            throw new IllegalArgumentException("packetId must be >= 0.");
        }
        this.checkAborted();
        Object object = this.getLock();
        synchronized (object) {
            if (packetId < this._lastPacketId) {
                throw new IllegalArgumentException("packetId must increase.");
            }
            boolean isReattempt = false;
            if (packetId != this._lastPacketId) {
                try {
                    this._lastPacket = this.readPacket();
                }
                catch (IOException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                this._lastPacketId = packetId;
            } else {
                isReattempt = true;
            }
            if (this._lastPacket != null) {
                this._monitor.bytesMoved(this, this._lastPacket.length, isReattempt);
            }
            return this._lastPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long skip(long n, int skipId) throws IOException {
        if (skipId < 0) {
            throw new IllegalArgumentException("skipId must be >= 0.");
        }
        this.checkAborted();
        Object object = this.getLock();
        synchronized (object) {
            if (skipId < this._lastSkipId) {
                throw new IllegalArgumentException("skipId must increase.");
            }
            boolean isReattempt = false;
            if (skipId != this._lastSkipId) {
                try {
                    this._lastSkip = this.skip(n);
                }
                catch (IOException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                this._lastSkipId = skipId;
            } else {
                isReattempt = true;
            }
            this._monitor.bytesSkipped(this, this._lastSkip, isReattempt);
            return this._lastSkip;
        }
    }

    protected abstract int availableImpl() throws IOException;

    protected abstract byte[] readPacket() throws IOException;

    protected abstract long skip(long var1) throws IOException;
}

