/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIteratorServer<DataType>
implements Closeable {
    protected final InputStream _localIStream;
    private final RemoteInputStreamServer _remoteIStream;

    public RemoteIteratorServer(InputStream localIStream) throws IOException {
        this(localIStream, true, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public RemoteIteratorServer(InputStream localIStream, boolean useCompression) throws IOException {
        this(localIStream, useCompression, RemoteInputStreamServer.DUMMY_MONITOR);
    }

    public RemoteIteratorServer(InputStream localIStream, boolean useCompression, RemoteStreamMonitor<RemoteInputStreamServer> monitor) throws IOException {
        this(localIStream, useCompression, monitor, 7168);
    }

    public RemoteIteratorServer(InputStream localIStream, boolean useCompression, RemoteStreamMonitor<RemoteInputStreamServer> monitor, int chunkSize) throws IOException {
        this._localIStream = localIStream;
        this._remoteIStream = useCompression ? new GZIPRemoteInputStream(this._localIStream, monitor, chunkSize){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void closeImpl(boolean readSuccess) throws IOException {
                try {
                    super.closeImpl(readSuccess);
                }
                finally {
                    RemoteIteratorServer.this.closeImpl(readSuccess);
                }
            }
        } : new SimpleRemoteInputStream(this._localIStream, monitor, chunkSize){
            private static final long serialVersionUID = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void closeImpl(boolean readSuccess) throws IOException {
                try {
                    super.closeImpl(readSuccess);
                }
                finally {
                    RemoteIteratorServer.this.closeImpl(readSuccess);
                }
            }
        };
    }

    RemoteInputStream getRemoteInputStream(RemoteStreamExporter exporter) throws IOException {
        return exporter == null ? (RemoteInputStream)this._remoteIStream.export() : (RemoteInputStream)exporter.export(this._remoteIStream);
    }

    public final boolean isClosed() {
        return this._remoteIStream.isClosed();
    }

    @Override
    public final void close() {
        this._remoteIStream.close();
    }

    public void abort() throws IOException {
        this._remoteIStream.abort();
    }

    protected void closeImpl(boolean readSuccess) throws IOException {
    }
}

