/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamMonitor;
import com.healthmarketscience.rmiio.RemoteStreamMonitor;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteOutputStreamServer
extends RemoteStreamServer<RemoteOutputStreamServer, RemoteOutputStream>
implements RemoteOutputStream {
    private static final long serialVersionUID = 20080212L;
    public static final RemoteStreamMonitor<RemoteOutputStreamServer> DUMMY_MONITOR = new RemoteOutputStreamMonitor();
    protected final transient OutputStream _out;
    private transient int _lastPacketId = -1;

    public RemoteOutputStreamServer(OutputStream out) {
        this(out, DUMMY_MONITOR);
    }

    public RemoteOutputStreamServer(OutputStream out, RemoteStreamMonitor<RemoteOutputStreamServer> monitor) {
        super(monitor);
        this._out = out;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    @Override
    protected final Object getLock() {
        return this._out;
    }

    @Override
    protected RemoteOutputStreamServer getAsSub() {
        return this;
    }

    @Override
    public Class<RemoteOutputStream> getRemoteClass() {
        return RemoteOutputStream.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeImpl(boolean writeSuccess) throws IOException {
        Object object = this.getLock();
        synchronized (object) {
            this._out.close();
        }
    }

    @Override
    public final void close(boolean writeSuccess) throws IOException {
        this.finish(true, writeSuccess);
    }

    @Override
    public final void flush() throws IOException {
        this.checkAborted();
        this.flushImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writePacket(byte[] packet, int packetId) throws IOException {
        if (packetId < 0) {
            throw new IllegalArgumentException("packetId must be >= 0.");
        }
        this.checkAborted();
        Object object = this.getLock();
        synchronized (object) {
            if (packetId < this._lastPacketId) {
                throw new IllegalArgumentException("packetId must increase.");
            }
            boolean isReattempt = false;
            if (packetId != this._lastPacketId) {
                try {
                    this.writePacket(packet);
                }
                catch (IOException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this._monitor.failure(this, e);
                    throw e;
                }
                this._lastPacketId = packetId;
            } else {
                isReattempt = true;
            }
            this._monitor.bytesMoved(this, packet.length, isReattempt);
        }
    }

    protected abstract void flushImpl() throws IOException;

    protected abstract void writePacket(byte[] var1) throws IOException;
}

