/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.GZIPRemoteInputStream;
import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import com.healthmarketscience.rmiio.RemoteRetry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class SerializableInputStream
extends InputStream
implements Serializable,
RemoteClient {
    private static final long serialVersionUID = -8922181237767770749L;
    private final RemoteInputStream _remoteIn;
    private transient RemoteRetry _retry;
    private transient InputStream _localIn;

    public SerializableInputStream(InputStream localIn) throws IOException {
        this(new GZIPRemoteInputStream(localIn));
    }

    public SerializableInputStream(RemoteInputStream remoteIn) {
        this._remoteIn = remoteIn;
    }

    private synchronized InputStream getLocalIn() throws IOException {
        if (this._localIn == null) {
            this._localIn = RemoteInputStreamClient.wrap(this._remoteIn, this._retry);
        }
        return this._localIn;
    }

    public synchronized void setRemoteRetry(RemoteRetry retry) {
        this._retry = retry;
    }

    public int available() throws IOException {
        return this.getLocalIn().available();
    }

    public int read() throws IOException {
        return this.getLocalIn().read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buf, int pos, int len) throws IOException {
        return this.getLocalIn().read(buf, pos, len);
    }

    public long skip(long len) throws IOException {
        return this.getLocalIn().skip(len);
    }

    public void close() throws IOException {
        this.getLocalIn().close();
    }
}

