/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.GZIPRemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import com.healthmarketscience.rmiio.RemoteRetry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializableOutputStream
extends OutputStream
implements Serializable,
RemoteClient {
    private static final long serialVersionUID = 2752774698731338838L;
    private final RemoteOutputStream _remoteOut;
    private transient RemoteRetry _retry;
    private transient OutputStream _localOut;
    private transient Integer _chunkSize;

    public SerializableOutputStream(OutputStream localIn) {
        this(new GZIPRemoteOutputStream(localIn));
    }

    public SerializableOutputStream(RemoteOutputStream remoteOut) {
        this._remoteOut = remoteOut;
    }

    private synchronized OutputStream getLocalOut() throws IOException {
        if (this._localOut == null) {
            this._localOut = RemoteOutputStreamClient.wrap(this._remoteOut, this._retry, this._chunkSize);
        }
        return this._localOut;
    }

    public synchronized void setRemoteRetry(RemoteRetry retry) {
        this._retry = retry;
    }

    public synchronized void setChunkSize(Integer chunkSize) {
        this._chunkSize = chunkSize;
    }

    public void flush() throws IOException {
        this.getLocalOut().flush();
    }

    public void write(int b) throws IOException {
        this.getLocalOut().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.getLocalOut().write(b, off, len);
    }

    public void close() throws IOException {
        this.getLocalOut().close();
    }
}

