/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.exporter;

import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.exporter.DefaultRemoteStreamExporter;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteStreamExporter {
    protected static final Log LOG = LogFactory.getLog(RemoteStreamExporter.class);
    public static final String EXPORTER_PROPERTY = "com.healthmarketscience.rmiio.exporter";
    public static final String DEFAULT_EXPORTER_CLASS_NAME = DefaultRemoteStreamExporter.class.getName();
    private static RemoteStreamExporter _INSTANCE = null;

    protected RemoteStreamExporter() {
    }

    public static synchronized RemoteStreamExporter getInstance() {
        if (_INSTANCE == null) {
            String exporterClassName = System.getProperty(EXPORTER_PROPERTY, DEFAULT_EXPORTER_CLASS_NAME);
            LOG.info((Object)("Using stream exporter " + exporterClassName));
            try {
                _INSTANCE = (RemoteStreamExporter)Class.forName(exporterClassName).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("could not instantiate exporter " + exporterClassName, e);
            }
        }
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <StreamType, StreamServerType extends RemoteStreamServer<?, StreamType>> StreamType export(StreamServerType server) throws RemoteException {
        StreamServerType StreamServerType = server;
        synchronized (StreamServerType) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exporting remote object " + server));
            }
            Object stubObj = this.exportImpl(server);
            boolean exportProcessed = false;
            StreamType stub = null;
            try {
                stub = server.getRemoteClass().cast(stubObj);
                server.exported(this);
                exportProcessed = true;
            }
            finally {
                if (!exportProcessed) {
                    this.unexport(server);
                }
            }
            return stub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexport(RemoteStreamServer<?, ?> server) {
        RemoteStreamServer<?, ?> remoteStreamServer = server;
        synchronized (remoteStreamServer) {
            block6: {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Unexporting remote object " + server));
                    }
                    this.unexportImpl(server);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)("Unexporting failed! for " + server), (Throwable)e);
                }
            }
        }
    }

    protected abstract Object exportImpl(RemoteStreamServer<?, ?> var1) throws RemoteException;

    protected abstract void unexportImpl(RemoteStreamServer<?, ?> var1) throws Exception;
}

