/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.osgi.service.datalocation.Location;

public class BuiltPlatformResourceURIHandler
extends PlatformResourceURIHandlerImpl {
    public static final String INDY_BUILD_FOLDER = ".indy.build";
    Location workspaceLocation = E4InjectorHelper.getService(Location.class, Location.INSTANCE_FILTER);

    public static IPath getBuildFolder() {
        Location workspaceLocation = E4InjectorHelper.getService(Location.class, Location.INSTANCE_FILTER);
        Path buildPath = new Path(String.valueOf(workspaceLocation.getURL().getPath()) + "/" + INDY_BUILD_FOLDER);
        return buildPath;
    }

    public OutputStream createOutputStream(final URI uri, Map<?, ?> options) throws IOException {
        final Map response = options == null ? null : (Map)options.get("RESPONSE");
        IPath buildPath = BuiltPlatformResourceURIHandler.getBuildFolder();
        buildPath = buildPath.append("/" + URI.decode((String)uri.segment(1)));
        int i = 3;
        while (i < uri.segmentCount()) {
            buildPath = buildPath.append("/" + URI.decode((String)uri.segment(i)));
            ++i;
        }
        final IPath _p = buildPath;
        if (!_p.toFile().getParentFile().exists()) {
            _p.toFile().getParentFile().mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(_p.toFile()){

            private void refreshResource() {
                try {
                    E4InjectorHelper.getService(XDIModelURIResolver.class).refreshResurce(uri);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                    this.refreshResource();
                }
                finally {
                    if (response != null) {
                        response.put("TIME_STAMP", _p.toFile().lastModified());
                    }
                }
            }

            @Override
            public void flush() throws IOException {
                super.flush();
            }
        });
    }
}

