/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IModelTranslationProvider;
import com.semarchy.xdi.designer.core.services.IOverrideService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class ProcessToolDescriptor
implements IRegistryService.RegistryItem,
Serializable {
    private static final long serialVersionUID = -2006336431745935017L;
    private List<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
    private List<MetadataLinkDescriptor> metaDatalinks = new ArrayList<MetadataLinkDescriptor>();
    private List<XslVariableDescriptor> xslVariables = new ArrayList<XslVariableDescriptor>();
    private List<BindVariableDescriptor> bindVariables = new ArrayList<BindVariableDescriptor>();
    private IconDescriptor smallIcon = null;
    private IconDescriptor largeIcon = null;
    private ProcessToolDescriptorKey key;
    private static transient Map<String, Optional<TranslationProvider>> translators = new HashMap<String, Optional<TranslationProvider>>();
    private static final String DEFAULT_ACTION_CODE_16_ICON_PATH = "/com.indy.gmf.process.edit/icons/full/obj16/ActionCode.gif";
    private static final String DEFAULT_ACTION_CODE_32_ICON_PATH = "/com.indy.gmf.process.edit/icons/full/obj32/ActionCode.gif";
    private static final String DEFAULT_PROCESSREF_16_ICON_PATH = "/com.indy.gmf.process.edit/icons/full/obj16/ActionProcessRef.png";
    private static final String DEFAULT_PROCESSREF_32_ICON_PATH = "/com.indy.gmf.process.edit/icons/full/obj32/ActionProcessRef.png";

    private static TranslationProvider getTranslator(String modelId) {
        Optional<TranslationProvider> p = translators.get(modelId);
        if (p == null) {
            ICacheService cacheService = E4InjectorHelper.getService(ICacheService.class);
            URI modelURI = cacheService.findResourceURIByFileId(modelId);
            IOverrideService overrideService = E4InjectorHelper.getService(IOverrideService.class);
            URI internalResourceURI = modelURI;
            if (internalResourceURI != null && !internalResourceURI.segment(1).equals("com.indy.environment")) {
                internalResourceURI = overrideService.getOverridenURI(internalResourceURI);
            }
            TranslationProvider provider = null;
            if (internalResourceURI != null) {
                try {
                    provider = new TranslationProvider(internalResourceURI);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            translators.put(modelId, Optional.ofNullable(provider));
        }
        return p.get();
    }

    public abstract String getDefaultSmallIconPath();

    public abstract String getDefaultLargeIconPath();

    public ProcessToolDescriptor(String fileID, String toolName, IconDescriptor smallIcon, IconDescriptor largeIcon) {
        Assert.isNotNull((Object)fileID);
        Assert.isNotNull((Object)toolName);
        this.key = new ProcessToolDescriptorKey(fileID, toolName);
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
    }

    public List<ParameterDescriptor> getParameters() {
        return this.parameters;
    }

    public List<MetadataLinkDescriptor> getMetaDatalinks() {
        return this.metaDatalinks;
    }

    public List<XslVariableDescriptor> getXslVariables() {
        return this.xslVariables;
    }

    public List<BindVariableDescriptor> getBindVariables() {
        return this.bindVariables;
    }

    public IconDescriptor getSmallIcon() {
        return this.smallIcon;
    }

    public IconDescriptor getLargeIcon() {
        return this.largeIcon;
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    static /* synthetic */ TranslationProvider access$0(String string) {
        return ProcessToolDescriptor.getTranslator(string);
    }

    private static abstract class AbstractTool
    extends ProcessToolDescriptor {
        private static final long serialVersionUID = -7298549999798736402L;
        private String name;
        private String displayName;
        private String description;
        private String paletteCategory;
        private String originalLongDescription;
        private transient boolean translated = false;
        private transient String __displayName;
        private transient String __paletteCategory;
        private transient String __description;
        private transient String longDescription;

        public AbstractTool(String fileID, String name, IconDescriptor smallIcon, IconDescriptor largeIcon, String displayName, String description, String longDescription, String paletteCategory) {
            super(fileID, name, smallIcon, largeIcon);
            this.paletteCategory = paletteCategory;
            this.originalLongDescription = longDescription;
            this.name = name;
            this.displayName = displayName;
            this.description = description;
        }

        /*
         * Unable to fully structure code
         */
        private void applyTranslation() {
            block12: {
                try {
                    try {
                        translator = ProcessToolDescriptor.access$0(this.getRegistrationKey().getProviderFileID());
                        s = translator.readProperty(TranslationProvider.getKey(this, "label"));
                        this.__displayName = s != null && s.isEmpty() == false ? s : this.displayName;
                        s = translator.readProperty(TranslationProvider.getKey(this, "description"));
                        this.__description = s != null && s.isEmpty() == false ? s : this.description;
                        s = translator.readProperty(TranslationProvider.getKey(this, "category"));
                        this.__paletteCategory = s != null && s.isEmpty() == false ? s : this.paletteCategory;
                        for (ParameterDescriptor d : this.getParameters()) {
                            s = translator.readProperty(TranslationProvider.getKey(this, d, "label"));
                            if (s != null && !s.isEmpty()) {
                                ParameterDescriptor.access$1(d, s);
                            } else {
                                ParameterDescriptor.access$1(d, ParameterDescriptor.access$2(d));
                            }
                            s = translator.readProperty(TranslationProvider.getKey(this, d, "description"));
                            if (s != null && !s.isEmpty()) {
                                ParameterDescriptor.access$3(d, s);
                            } else {
                                ParameterDescriptor.access$3(d, ParameterDescriptor.access$4(d));
                            }
                            s = translator.readProperty(TranslationProvider.getKey(this, d, "longDescription"));
                            if (s != null && !s.isEmpty()) {
                                ParameterDescriptor.access$5(d, s);
                                continue;
                            }
                            ParameterDescriptor.access$5(d, ParameterDescriptor.access$6(d));
                        }
                        break block12;
                    }
                    catch (Exception ex) {
                        this.__displayName = this.displayName;
                        this.__description = this.description;
                        this.longDescription = this.originalLongDescription;
                        this.__paletteCategory = this.paletteCategory;
                        ** for (d : this.getParameters())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ParameterDescriptor.access$1(d, ParameterDescriptor.access$2(d));
                        ParameterDescriptor.access$3(d, ParameterDescriptor.access$4(d));
                        ParameterDescriptor.access$5(d, ParameterDescriptor.access$6(d));
                        continue;
lbl38:
                        // 1 sources

                    }
                }
                finally {
                    this.translated = true;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            if (!this.translated) {
                this.applyTranslation();
            }
            return this.__displayName;
        }

        public String getDescription() {
            if (!this.translated) {
                this.applyTranslation();
            }
            return this.__description;
        }

        public String getPaletteCategory() {
            if (!this.translated) {
                this.applyTranslation();
            }
            return this.__paletteCategory;
        }

        public String getLongDescription() {
            if (!this.translated) {
                this.applyTranslation();
            }
            return this.longDescription;
        }
    }

    public static class ActionDefinition
    extends AbstractTool {
        private static final long serialVersionUID = 8230596501118535937L;
        private String className;
        private boolean bindableAsSrc;
        private boolean bindableAsTrg;
        private boolean hidden;
        private Integer defaultCycleNumber = null;
        private Boolean defaultToleratedError = null;
        private String initializationCode;
        HashMap<String, List<ParameterDescriptor>> cachedParamsByLvl = null;

        public ActionDefinition(String fileID, String name, IconDescriptor smallIcon, IconDescriptor largeIcon, String className, boolean bindableAsSrc, boolean bindableAsTrg, String displayName, String description, String longDescription, boolean hidden, Integer defaultCycleNumber, Boolean defaultToleratedError, String paletteCategory, String initializationCode) {
            super(fileID, name, smallIcon, largeIcon, displayName, description, longDescription, paletteCategory);
            Assert.isNotNull((Object)paletteCategory);
            this.className = className;
            this.bindableAsSrc = bindableAsSrc;
            this.bindableAsTrg = bindableAsTrg;
            this.hidden = hidden;
            this.defaultCycleNumber = defaultCycleNumber;
            this.defaultToleratedError = defaultToleratedError;
            this.initializationCode = initializationCode;
        }

        public String getInitializationCode() {
            return this.initializationCode;
        }

        @Override
        public List<ParameterDescriptor> getParameters() {
            return super.getParameters();
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isBindableAsSrc() {
            return this.bindableAsSrc;
        }

        public boolean isBindableAsTrg() {
            return this.bindableAsTrg;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Integer getDefaultCycleNumber() {
            return this.defaultCycleNumber;
        }

        public Boolean getDefaultToleratedError() {
            return this.defaultToleratedError;
        }

        @Override
        public String getDefaultSmallIconPath() {
            return ProcessToolDescriptor.DEFAULT_ACTION_CODE_16_ICON_PATH;
        }

        @Override
        public String getDefaultLargeIconPath() {
            return ProcessToolDescriptor.DEFAULT_ACTION_CODE_32_ICON_PATH;
        }

        public HashMap<String, List<ParameterDescriptor>> getParametersPerLevels() {
            if (this.cachedParamsByLvl == null) {
                this.cachedParamsByLvl = new HashMap();
                for (ParameterDescriptor p : this.getParameters()) {
                    if (!p.hasInitializer()) continue;
                    for (String s : p.mdLinkInitializerXPathExpressionPerLevelCode.keySet()) {
                        List<ParameterDescriptor> l = this.cachedParamsByLvl.get(s);
                        if (l == null) {
                            l = new ArrayList<ParameterDescriptor>();
                            this.cachedParamsByLvl.put(s, l);
                        }
                        if (l.contains(p)) continue;
                        l.add(p);
                    }
                }
            }
            return this.cachedParamsByLvl;
        }
    }

    public static class ActionDefinitionExtension
    extends ActionDefinition {
        private static final long serialVersionUID = -4767292583813011960L;
        private transient URI toolDefinitionMdNodeURI;
        private String mdNodeURI;

        public ActionDefinitionExtension(String fileID, String name, IconDescriptor smallIcon, IconDescriptor largeIcon, String displayName, String description, String longDescription, String paletteCategory, ActionDefinition baseActionDef, URI toolDefinitionMdNodeURI, String initializationCode) {
            super(fileID, name, smallIcon != null ? smallIcon : baseActionDef.getSmallIcon(), largeIcon != null ? largeIcon : baseActionDef.getLargeIcon(), baseActionDef.getClassName(), baseActionDef.isBindableAsSrc(), baseActionDef.isBindableAsTrg(), displayName, description, longDescription, baseActionDef.isHidden(), baseActionDef.getDefaultCycleNumber(), baseActionDef.getDefaultToleratedError(), paletteCategory, initializationCode);
            this.toolDefinitionMdNodeURI = toolDefinitionMdNodeURI;
            this.mdNodeURI = this.toolDefinitionMdNodeURI.toString();
        }

        public URI getDefinitionMdNodeURI() {
            if (this.toolDefinitionMdNodeURI == null && this.mdNodeURI != null) {
                this.toolDefinitionMdNodeURI = URI.createURI((String)this.mdNodeURI);
            }
            return this.toolDefinitionMdNodeURI;
        }
    }

    public static class BindVariableDescriptor
    implements Serializable {
        private static final long serialVersionUID = -6143943804244081282L;
        private String name;
        private String description;

        public BindVariableDescriptor(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class CacheURIProcessMatcher
    implements IRegistryService.IRegistryMatcher {
        private String fileID;
        private String eltID;

        public CacheURIProcessMatcher(EObject processRef) {
            this(processRef.eIsProxy() ? ((InternalEObject)processRef).eProxyURI() : EcoreUtil.getURI((EObject)processRef));
        }

        public CacheURIProcessMatcher(URI uri) {
            this.fileID = CacheHelper.extractFileID(uri.fragment());
            this.eltID = CacheHelper.extractEltID(uri.fragment());
        }

        @Override
        public boolean match(Object o) {
            String id;
            if (o instanceof ProcessToolDescriptorKey && (id = ((ProcessToolDescriptorKey)o).getToolName()).contains("/")) {
                String fId = id.split("/")[0];
                String eltId = id.split("/")[1];
                return this.fileID != null && this.fileID.equals(fId) && this.eltID.equals(eltId);
            }
            return false;
        }
    }

    public static class EnablementExpression
    implements Serializable {
        private static final long serialVersionUID = -1476866448606709506L;
        public static final int NOT_TYPE = 1;
        public static final int OR_TYPE = 2;
        public static final int AND_TYPE = 3;
        public static final int PARAM_EVAL_TYPE = 4;
        public static final int PARM_EXIST_TYPE = 5;
        List<EnablementExpression> children = new ArrayList<EnablementExpression>();
        int type;
        String parameterName;
        String parameterValue;

        public EnablementExpression(int expressionType, String parameterName, String parameterValue) {
            this.type = expressionType;
            this.parameterName = parameterName;
            this.parameterValue = parameterValue;
        }

        public List<EnablementExpression> getChildren() {
            return this.children;
        }

        public int getType() {
            return this.type;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getParameterValue() {
            return this.parameterValue;
        }
    }

    public static class IconDescriptor
    implements Serializable {
        private String key;
        private byte[] data;
        private static final long serialVersionUID = -199999888675869292L;

        public IconDescriptor() {
        }

        public IconDescriptor(String key, byte[] data) throws MalformedURLException {
            this.key = key;
            this.data = data;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getIconData() {
            return this.data;
        }

        public boolean isRaw() {
            return this.data != null;
        }
    }

    public static class MetadataLinkDescriptor
    implements Serializable {
        private static final long serialVersionUID = -4693572983047306323L;
        private String name;
        private Map<String, String> allowedLevels = new LinkedHashMap<String, String>();
        private List<String> publicationModes = new ArrayList<String>();
        private boolean publish;
        private String visibility;
        private String tooltip;

        public MetadataLinkDescriptor(String name, boolean publish, String visibility, String tooltip) {
            this.name = name;
            this.publish = publish;
            this.visibility = visibility;
            this.tooltip = tooltip;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAllowedLevels() {
            return this.allowedLevels;
        }

        public boolean isPublish() {
            return this.publish;
        }

        public String getVisibility() {
            return this.visibility;
        }

        public List<String> getPublicationModes() {
            return this.publicationModes;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    public static class ParameterDescriptor
    implements Serializable {
        private static final long serialVersionUID = -7757192834499776465L;
        private String name;
        private boolean mandatory;
        private String originalDescription;
        private String originalLongDescription;
        private String originalDiplayName;
        private String type;
        private String defaultValue;
        private boolean system;
        private boolean hidden;
        private List<String> restrictedValues = new ArrayList<String>();
        private List<String> publicationModes = new ArrayList<String>();
        private EnablementExpression enablementExpression = null;
        private HashMap<String, String> mdLinkInitializerXPathExpressionPerLevelCode = new HashMap();
        private transient String description;
        private transient String longDescription;
        private transient String diplayName;
        private String forcedValue;

        public ParameterDescriptor(String name, boolean mandatory, String description, String longDescription, String diplayName, String type, String defaultValue, boolean system, boolean hidden) {
            this.originalLongDescription = longDescription;
            this.name = name;
            this.mandatory = mandatory;
            this.originalDescription = description;
            this.originalDiplayName = diplayName;
            this.type = type;
            this.defaultValue = defaultValue;
            this.system = system;
            this.hidden = hidden;
        }

        public String getMdLinkInitializationXPathExpression4Lvl(String lvl) {
            return this.mdLinkInitializerXPathExpressionPerLevelCode.get(lvl);
        }

        public HashMap<String, String> getMdLinkInitializers() {
            return this.mdLinkInitializerXPathExpressionPerLevelCode;
        }

        public String getForcedValue() {
            return this.forcedValue;
        }

        public void setForcedValue(String forcedValue) {
            this.forcedValue = forcedValue;
        }

        public String getLongDescription() {
            return this.longDescription;
        }

        public void setEnablementExpression(EnablementExpression enablementExpression) {
            this.enablementExpression = enablementExpression;
        }

        public EnablementExpression getEnablementExpression() {
            return this.enablementExpression;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDiplayName() {
            return this.diplayName;
        }

        public String getType() {
            return this.type;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isSystem() {
            return this.system;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public List<String> getRestrictedValues() {
            return this.restrictedValues;
        }

        public List<String> getPublicationModes() {
            return this.publicationModes;
        }

        public void addInitializer(String valueXpathExpression, List<String> levelCodes) throws Exception {
            Assert.isTrue((valueXpathExpression != null && !valueXpathExpression.trim().isEmpty() ? 1 : 0) != 0);
            for (String s : levelCodes) {
                Assert.isTrue((this.mdLinkInitializerXPathExpressionPerLevelCode.get(s) == null ? 1 : 0) != 0);
                this.mdLinkInitializerXPathExpressionPerLevelCode.put(s, valueXpathExpression);
            }
        }

        public boolean hasInitializer() {
            return !this.mdLinkInitializerXPathExpressionPerLevelCode.isEmpty();
        }

        public boolean defineInitializer4(String levelCode) {
            return this.mdLinkInitializerXPathExpressionPerLevelCode.get(levelCode) != null;
        }

        static /* synthetic */ void access$1(ParameterDescriptor parameterDescriptor, String string) {
            parameterDescriptor.diplayName = string;
        }

        static /* synthetic */ String access$2(ParameterDescriptor parameterDescriptor) {
            return parameterDescriptor.originalDiplayName;
        }

        static /* synthetic */ void access$3(ParameterDescriptor parameterDescriptor, String string) {
            parameterDescriptor.description = string;
        }

        static /* synthetic */ String access$4(ParameterDescriptor parameterDescriptor) {
            return parameterDescriptor.originalDescription;
        }

        static /* synthetic */ void access$5(ParameterDescriptor parameterDescriptor, String string) {
            parameterDescriptor.longDescription = string;
        }

        static /* synthetic */ String access$6(ParameterDescriptor parameterDescriptor) {
            return parameterDescriptor.originalLongDescription;
        }
    }

    public static class ProcessToolDescriptorKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = -6351565615842373537L;
        private String fullCode;
        private String fileID;
        private String toolName;

        public ProcessToolDescriptorKey(String fileID, String toolName) {
            this.fullCode = String.valueOf(fileID) + "/" + toolName;
            this.fileID = fileID;
            this.toolName = toolName;
        }

        public String getFullCode() {
            return this.fullCode;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof ProcessToolDescriptorKey) {
                return this.fullCode.equals(((ProcessToolDescriptorKey)o).fullCode);
            }
            return false;
        }

        public int hashCode() {
            return this.fullCode.hashCode();
        }

        public boolean equals(Object obj) {
            return this.match(obj);
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }

        public String getToolName() {
            return this.toolName;
        }
    }

    public static class ToolDefinition
    extends AbstractTool {
        private static final long serialVersionUID = -8545403038294515469L;
        private transient URI processRefURI = null;
        private String _refURI;
        private transient URI toolDefinitionMdNodeURI;
        private String mdNodeURI;

        public ToolDefinition(String fileID, String name, IconDescriptor smallIcon, IconDescriptor largeIcon, String processRefURI, String displayName, String description, String longDescription, String paletteCategory, URI toolDefinitionMdNodeURI) {
            super(fileID, name, smallIcon, largeIcon, displayName, description, longDescription, paletteCategory);
            Assert.isNotNull((Object)paletteCategory);
            this._refURI = processRefURI;
            this.toolDefinitionMdNodeURI = toolDefinitionMdNodeURI;
            this.mdNodeURI = this.toolDefinitionMdNodeURI.toString();
        }

        public URI getDefinitionMdNodeURI() {
            if (this.toolDefinitionMdNodeURI == null && this.mdNodeURI != null) {
                this.toolDefinitionMdNodeURI = URI.createURI((String)this.mdNodeURI);
            }
            return this.toolDefinitionMdNodeURI;
        }

        public URI getProcessRefURI() {
            if (this.processRefURI == null) {
                this.processRefURI = URI.createURI((String)this._refURI);
            }
            return this.processRefURI;
        }

        @Override
        public String getDefaultSmallIconPath() {
            return ProcessToolDescriptor.DEFAULT_PROCESSREF_16_ICON_PATH;
        }

        @Override
        public String getDefaultLargeIconPath() {
            return ProcessToolDescriptor.DEFAULT_PROCESSREF_32_ICON_PATH;
        }
    }

    public static class TranslationProvider {
        public static final String PROP_DISPLAY_NAME = "label";
        public static final String PROP_PALETTE_CATEGORY = "category";
        public static final String PROP_DESCRIPTION = "description";
        public static final String PROP_LONG_DESCRIPTION = "longDescription";
        Properties props;

        public TranslationProvider(URI modelURI) throws Exception {
            Assert.isTrue((modelURI != null && "com.indy.environment".equals(modelURI.segment(1)) ? 1 : 0) != 0);
            IModelTranslationProvider provider = E4InjectorHelper.getService(IModelTranslationProvider.class);
            if (provider != null) {
                this.props = new Properties();
                List<java.net.URI> u = provider.getTranslationFileURI(modelURI);
                if (u != null) {
                    u.stream().forEach(p -> {
                        try {
                            Throwable throwable = null;
                            Object var3_5 = null;
                            try (InputStreamReader is = new InputStreamReader(p.toURL().openStream(), "UTF-8");){
                                this.props.load(is);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    });
                }
            } else {
                throw new Exception();
            }
        }

        private static String getBaseKey(AbstractTool a) {
            return a.getName().replace(" ", "");
        }

        private static String getBaseKey(AbstractTool a, ParameterDescriptor p) {
            return String.valueOf(TranslationProvider.getBaseKey(a)) + "/" + p.getName();
        }

        public static String getKey(AbstractTool a, String propName) {
            return String.valueOf(TranslationProvider.getBaseKey(a)) + "." + propName;
        }

        public static String getKey(AbstractTool a, ParameterDescriptor p, String propName) {
            return String.valueOf(TranslationProvider.getBaseKey(a, p)) + "." + propName;
        }

        public String readProperty(String key) {
            return this.props.getProperty(key);
        }
    }

    public static class XslVariableDescriptor
    implements Serializable {
        private static final long serialVersionUID = -3086367407687470501L;
        private String name;
        private String type;
        private String visibility;

        public XslVariableDescriptor(String name, String type, String visibility) {
            this.name = name;
            this.type = type;
            this.visibility = visibility;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getVisibility() {
            return this.visibility;
        }
    }
}

