/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;

public class RuntimeEngine
implements IRegistryService.RegistryItem,
Serializable {
    public static final String DEFAULT_RUNTIME_PROVIDER_FILE_ID = "com.indy.ui.custom.out.services.registry.defaultRuntimeFileProvderID";
    private static final long serialVersionUID = 3391423582162422440L;
    private String host;
    private String port;
    private String description;
    private String user;
    private String password;
    private RuntimeEngineKey key;
    private Map<String, Properties> confProperties = new HashMap<String, Properties>();
    private String currentConf = null;

    public RuntimeEngine(String fileID, String runtimeName, String host, String port, String description, String user, String password) {
        Assert.isNotNull((Object)fileID);
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)port);
        Assert.isNotNull((Object)runtimeName);
        this.host = host;
        this.port = port;
        this.description = description;
        this.user = user;
        this.password = password;
        this.key = new RuntimeEngineKey(fileID, runtimeName);
    }

    public void addConfiguration(String confName, String host, String port, String user, String password) {
        Properties prop = new Properties();
        if (host != null) {
            prop.put("host", host);
        }
        if (port != null) {
            prop.put("port", port);
        }
        if (user != null) {
            prop.put("user", user);
        }
        if (password != null) {
            prop.put("password", password);
        }
        this.confProperties.put(confName, prop);
    }

    private String getConfProperty(String propName) {
        if (this.currentConf != null && this.confProperties.get(this.currentConf) != null) {
            return this.confProperties.get(this.currentConf).getProperty(propName);
        }
        return null;
    }

    public String getUser() {
        String s = this.getConfProperty("user");
        if (s != null) {
            return s;
        }
        return this.user;
    }

    public String getPassword() {
        String s = this.getConfProperty("password");
        if (s != null) {
            return s;
        }
        return this.password;
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public String getHost() {
        String s = this.getConfProperty("host");
        if (s != null) {
            return s;
        }
        return this.host;
    }

    public String getPort() {
        String s = this.getConfProperty("port");
        if (s != null) {
            return s;
        }
        return this.port;
    }

    public String getDescription() {
        return this.description;
    }

    public RuntimeEngineKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.key.runtimeName;
    }

    public String toString() {
        if (this.getHost() != null && this.getPort() != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getName());
            buf.append(" (");
            buf.append(this.getHost());
            buf.append(":");
            buf.append(this.getPort());
            buf.append(")");
            return buf.toString();
        }
        return this.getName();
    }

    public boolean supportConf(String ... conf) {
        String[] stringArray = conf;
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (this.confProperties.get(s) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setCurrentConf(String conf) {
        this.currentConf = conf;
    }

    public static class RuntimeEngineKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = 441330945424618114L;
        private String runtimeName;
        private String fileID;

        public RuntimeEngineKey(String fileID, String runtimeName) {
            this.runtimeName = runtimeName;
            this.fileID = fileID;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof RuntimeEngineKey) {
                return this.runtimeName.equals(((RuntimeEngineKey)o).runtimeName);
            }
            return false;
        }

        public int hashCode() {
            return this.runtimeName.hashCode();
        }

        public boolean equals(Object obj) {
            return this.match(obj);
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }

        public String toString() {
            return String.valueOf(this.getProviderFileID()) + "_" + this.runtimeName;
        }
    }

    public static class RuntimeEngineMatcher
    implements IRegistryService.IRegistryMatcher {
        private String runtimeName;

        public RuntimeEngineMatcher(String runtimeName) {
            this.runtimeName = runtimeName;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof RuntimeEngineKey) {
                return this.runtimeName.equals(((RuntimeEngineKey)o).runtimeName);
            }
            return false;
        }
    }
}

