/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.services.ICacheService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class E4InjectorHelper {
    private static ServiceHandler serviceHandler = new ServiceHandler();

    public static void inject(Object object) {
        Bundle bundle = FrameworkUtil.getBundle(object.getClass());
        BundleContext bundleCtx = bundle.getBundleContext();
        if (bundleCtx == null) {
            Bundle b = Platform.getBundle((String)bundle.getSymbolicName());
            System.out.println();
        }
        IEclipseContext ctx = EclipseContextFactory.getServiceContext((BundleContext)bundleCtx);
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)ctx);
    }

    public static <T> T getService(Class<T> service) {
        T res = E4InjectorHelper.getService(service, null);
        if (service == ICacheService.class) {
            ((ICacheService)res).init(false);
        }
        return res;
    }

    public static <T> T getService(Class<T> service, String serviceFilter) {
        return (T)serviceHandler.getService(service, serviceFilter);
    }

    public static <T> void consumeService(Class<T> service, Consumer<T> consumer) {
        serviceHandler.executeWithServive(service, consumer);
    }

    public static <T, R> R consumeServiceWithResult(Class<T> service, Function<T, R> consumer) {
        return serviceHandler.executeWithServive(service, consumer);
    }

    private static class ServiceHandler {
        private Map<ServiceKey, ServiceReference> servicesMap = Collections.synchronizedMap(new HashMap());
        private Map<ServiceReference, Object> servicesObjectMap = Collections.synchronizedMap(new HashMap());
        private Bundle bundle = FrameworkUtil.getBundle(E4InjectorHelper.class);

        private ServiceHandler() {
        }

        public <S> S getService(Class class1, String filter) {
            ServiceReference sr;
            block5: {
                if (this.bundle.getState() == 16) {
                    return null;
                }
                ServiceKey k = new ServiceKey(class1, filter);
                sr = this.servicesMap.get(k);
                if (sr == null) {
                    block6: {
                        Collection refs = this.bundle.getBundleContext().getServiceReferences(class1, filter);
                        if (refs == null || refs.isEmpty()) break block5;
                        sr = (ServiceReference)refs.iterator().next();
                        if (sr != null) break block6;
                        return null;
                    }
                    try {
                        this.servicesMap.put(k, sr);
                        this.servicesObjectMap.put(sr, this.bundle.getBundleContext().getService(sr));
                    }
                    catch (InvalidSyntaxException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return (S)this.servicesObjectMap.get(sr);
        }

        public <T> T createService(Class<T> service, String serviceFactory) {
            this.bundle.getBundleContext().getServiceReference(service);
            return null;
        }

        public <T> void executeWithServive(Class<T> service, Consumer<T> c) {
            ServiceReference sr = this.bundle.getBundleContext().getServiceReference(service);
            try {
                Object s = this.bundle.getBundleContext().getService(sr);
                c.accept(s);
            }
            finally {
                this.bundle.getBundleContext().ungetService(sr);
            }
        }

        public <T, R> R executeWithServive(Class<T> service, Function<T, R> c) {
            ServiceReference sr = this.bundle.getBundleContext().getServiceReference(service);
            try {
                Object s = sr == null ? null : this.bundle.getBundleContext().getService(sr);
                R r = c.apply(s);
                return r;
            }
            finally {
                if (sr != null) {
                    this.bundle.getBundleContext().ungetService(sr);
                }
            }
        }
    }

    private static class ServiceKey {
        Class serviceClass;
        String filter;
        String id;

        ServiceKey(Class serviceClass, String filter) {
            this.serviceClass = serviceClass;
            this.filter = filter;
            this.id = String.valueOf(serviceClass.getName()) + "/";
            if (filter != null) {
                this.id = String.valueOf(this.id) + filter;
            }
        }

        public boolean equals(Object arg0) {
            return arg0 instanceof ServiceKey && ((ServiceKey)arg0).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

