/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.services.ICacheService;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;

public class MappingBuildablePredicate
implements Predicate<URI> {
    private ICacheService cacheService;
    private Logger logger;

    public static Predicate<URI> of(ICacheService cacheService, Logger logger) {
        return new MappingBuildablePredicate(cacheService, logger);
    }

    private MappingBuildablePredicate(ICacheService cacheService, Logger logger) {
        this.cacheService = cacheService;
        this.logger = logger;
    }

    @Override
    public boolean test(URI modelURI) {
        boolean res = true;
        ICacheService.SourceState srcState = this.cacheService.getSourceState(modelURI);
        if (srcState == null) {
            this.logger.warn(() -> String.format("Unknown source %s", modelURI));
            return false;
        }
        if (!srcState.sourceExists()) {
            this.logger.warn(() -> String.format("Skip %s because the resource does not exist in the index", modelURI));
            res = false;
        }
        if (srcState.isMissingCrossReference()) {
            this.logger.info(() -> String.format("Skip %s because of missing crossRefs", modelURI));
            res = false;
        }
        if (this.cacheService.getCacheState().getUnparsedResources().get(modelURI) != null) {
            this.logger.info(() -> String.format("Skip build %s because resource cannot be parsed", modelURI));
            res = false;
        }
        if (srcState.hasBrokenRequirements()) {
            this.logger.info(() -> String.format("Skip build %s because resource requirements are broken", modelURI));
            res = false;
        }
        res = res && srcState.isSync();
        return res;
    }
}

