/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.utils;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class URIUtils {
    private static final int TYPE_MAP = 1;
    private static final int TYPE_PROC = 2;
    private static final String CHAR_AND = "&";
    private static final String ENCODED_AND = "%26";

    public static String normalizeResourceFragment(String fragment) {
        String res = fragment.replace(CHAR_AND, ENCODED_AND).replace("?", "%3F");
        return res;
    }

    public static IPath toPath(URI uri) {
        String scheme;
        if (uri != null && "platform".equals(scheme = uri.scheme()) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
            StringBuffer platformResourcePath = new StringBuffer();
            int j = 1;
            int size = uri.segmentCount();
            while (j < size) {
                platformResourcePath.append('/');
                platformResourcePath.append(URI.decode((String)uri.segment(j)));
                ++j;
            }
            return new Path(platformResourcePath.toString());
        }
        return null;
    }

    public static URI getDiagramURI(URI modelURI) {
        URI diagramResourceUri = null;
        int type = -1;
        if (modelURI.fileExtension() != null) {
            if (modelURI.fileExtension().startsWith("map")) {
                type = 1;
            } else if (modelURI.fileExtension().startsWith("proc")) {
                type = 2;
            }
            ICacheService cacheService = E4InjectorHelper.getService(ICacheService.class);
            URI semanticUri = modelURI;
            String semanticSoruceId = cacheService.getSourceId(modelURI.trimFragment());
            if (semanticSoruceId == null) {
                semanticSoruceId = cacheService.getSourceId(modelURI);
            }
            if (semanticSoruceId != null) {
                semanticUri = cacheService.findResourceURIByFileId(semanticSoruceId);
            }
            if (modelURI.isPlatformPlugin()) {
                if (modelURI.segment(1).equals("com.indy.environment")) {
                    Path p = new Path("");
                    int i = 1;
                    while (i < semanticUri.segmentCount() - 1) {
                        p = p.append(URI.decode((String)semanticUri.segment(i)));
                        ++i;
                    }
                    p = p.append("indy.diagram");
                    switch (type) {
                        case 1: {
                            p = p.append("map");
                            break;
                        }
                        case 2: {
                            p = p.append("proc");
                        }
                    }
                    p = p.append(URI.decode((String)semanticUri.trimFileExtension().trimFragment().lastSegment()));
                    switch (type) {
                        case 1: {
                            p = p.addFileExtension("map_diagram");
                            break;
                        }
                        case 2: {
                            p = p.addFileExtension("proc_diagram");
                        }
                    }
                    diagramResourceUri = URI.createPlatformPluginURI((String)p.toString(), (boolean)true);
                } else {
                    diagramResourceUri = URI.createPlatformPluginURI((String)"com.indy.gmf.map.diagram", (boolean)true).appendSegment(String.valueOf(semanticSoruceId) + "-proc").appendFileExtension("proc_diagram");
                }
            } else if (type == 2 && "indy.build".equals(semanticUri.segment(2))) {
                diagramResourceUri = URI.createPlatformPluginURI((String)"com.indy.gmf.map.diagram", (boolean)true).appendSegment(semanticSoruceId).appendFileExtension("proc_diagram");
            } else {
                Path p = new Path("");
                int i = 1;
                while (i < semanticUri.segmentCount() - 1) {
                    p = p.append(URI.decode((String)semanticUri.segment(i)));
                    ++i;
                }
                p = p.append("indy.diagram");
                switch (type) {
                    case 1: {
                        p = p.append("map");
                        break;
                    }
                    case 2: {
                        p = p.append("proc");
                    }
                }
                p = p.append(URI.decode((String)semanticUri.trimFileExtension().trimFragment().lastSegment()));
                switch (type) {
                    case 1: {
                        p = p.addFileExtension("map_diagram");
                        break;
                    }
                    case 2: {
                        p = p.addFileExtension("proc_diagram");
                    }
                }
                diagramResourceUri = URIUtils.convertIPathToEMFURI2((IPath)p);
            }
        }
        return diagramResourceUri;
    }

    public static URI convertIPathToEMFURI2(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    private static IPath getBuiltFolder(URI resourceFile) {
        if (resourceFile != null) {
            Path p = new Path("indy.build");
            int i = 2;
            while (i < resourceFile.segmentCount() - 1) {
                p = p.append("/" + resourceFile.segment(i));
                ++i;
            }
            return p;
        }
        return null;
    }

    public static URI getMappingBuiltProcFile(URI mappingResourceURI) {
        IPath p = URIUtils.getBuiltFolder(mappingResourceURI);
        if (p != null) {
            return URI.createPlatformResourceURI((String)(String.valueOf(mappingResourceURI.segment(1)) + "/" + p.toString() + "/" + mappingResourceURI.trimFragment().trimFileExtension().lastSegment() + ".proc"), (boolean)false);
        }
        return null;
    }

    public static URI getMappingBuiltMdFile(URI mappingResourceURI) {
        IPath p = URIUtils.getBuiltFolder(mappingResourceURI);
        if (p != null) {
            return URI.createPlatformResourceURI((String)(String.valueOf(mappingResourceURI.segment(1)) + "/" + p.toString() + "/" + mappingResourceURI.trimFragment().trimFileExtension().lastSegment() + ".md"), (boolean)false);
        }
        return null;
    }

    public static URI getMappingRef(URI mappingResourceURI) {
        IPath p = URIUtils.getBuiltFolder(mappingResourceURI);
        if (p != null) {
            return URI.createPlatformResourceURI((String)(String.valueOf(mappingResourceURI.segment(1)) + "/" + p.toString() + "/" + mappingResourceURI.trimFragment().trimFileExtension().lastSegment() + ".map_ref"), (boolean)false);
        }
        return null;
    }

    public static URI getCrossModelURI(URI resourceURI) {
        IPath p = URIUtils.getBuiltFolder(resourceURI);
        if (p != null) {
            return URI.createPlatformResourceURI((String)(String.valueOf(resourceURI.segment(1)) + "/" + p.toString() + "/" + resourceURI.trimFragment().lastSegment() + ".cross"), (boolean)false);
        }
        return null;
    }

    public static Collection<URI> getMappingBuiltFiles(URI mappingURI, XDIModelURIResolver resolver, boolean checkExistance) {
        File f;
        ArrayList<URI> res = new ArrayList<URI>();
        URI mdURI = URIUtils.getMappingBuiltMdFile(mappingURI);
        if (!checkExistance || resolver.exists(mdURI)) {
            res.add(mdURI);
        }
        URI procURI = URIUtils.getMappingBuiltProcFile(mappingURI);
        if (!checkExistance || resolver.exists(procURI)) {
            res.add(procURI);
        }
        if ((f = resolver.resolve(procURI)) == null) {
            return res;
        }
        String mappingFileName = URI.decode((String)mappingURI.trimFileExtension().lastSegment());
        String[] builtFiles = f.getParentFile().list();
        if (builtFiles != null) {
            String[] stringArray = builtFiles;
            int n = builtFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (procURI != null && s.startsWith(String.valueOf(mappingFileName) + "-ref-") && s.endsWith(".md")) {
                    URI ref = procURI.trimSegments(1).appendSegment(s).appendFileExtension("md");
                    res.add(ref);
                }
                ++n2;
            }
        }
        return res;
    }
}

