/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.elasticsearch.action;

import com.indy.addons.elasticsearch.Messages;
import com.indy.addons.json.JSONReverser;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.runtime.json.JsonNode;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import com.stambia.md.util.MdFactoryHelper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.emf.ecore.EObject;

public class ReverseDocAction
implements IExecute {
    private static int version = 0;

    public static void reverse(MdNode node, InputStream is, String encoding) throws Exception {
    }

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        version = ReverseDocAction.getElasticsearchVersion(node);
        ReverseDocAction.reverse(node, 0);
        return null;
    }

    public static void reverse(MdNode node, int mode) throws ExecuteException {
        ReverseDocAction.reverse(node, mode, null);
    }

    private static void reverseType(MdNode index, MdNode originalIndex, String indexName, String typeName, String strUrl, String uuid) throws Exception {
        URL url;
        String reverseFrom;
        MdNode type = MdFactoryHelper.createMdNode((String)"com.stambia.elasticsearch.type");
        type.setSubstituteContainer((EObject)index);
        if (version >= 7) {
            type.setName(indexName);
        } else {
            type.setName(typeName);
        }
        if (originalIndex != null) {
            for (MdNode node : originalIndex.getNode()) {
                if (!node.getDefType().equals("com.stambia.elasticsearch.type")) continue;
                if (uuid != null) {
                    if (!node.getId().equals(uuid)) continue;
                    type.setName(node.getName());
                    break;
                }
                if (version >= 7) {
                    type.setName(node.getName());
                    break;
                }
                String physicalName = node.evaluate("@physicalName");
                if (!physicalName.equals(typeName)) continue;
                type.setName(node.getName());
                break;
            }
        }
        type.setAttribute("physicalName", typeName, false);
        String reverseSize = index.evaluate("ancestor-or-self::server/@reverseSize");
        if (reverseSize == null || reverseSize.isEmpty()) {
            reverseSize = "100";
        }
        if ((reverseFrom = index.evaluate("ancestor-or-self::server/@reverseFrom")) == null || reverseFrom.isEmpty()) {
            reverseFrom = "0";
        }
        if (version >= 7) {
            type.setName(indexName);
            type.setAttribute("physicalName", "_doc", false);
            url = new URL(String.valueOf(strUrl) + "/" + indexName + "/_search?size=" + reverseSize + "&from=" + reverseFrom);
        } else {
            url = new URL(String.valueOf(strUrl) + "/" + indexName + "/" + typeName + "/_search?size=" + reverseSize + "&from=" + reverseFrom);
        }
        String user = index.evaluate("ancestor-or-self::*/@httpUser");
        String password = index.evaluate("ancestor-or-self::*/@httpPassword");
        HttpURLConnection conn2 = ReverseDocAction.getConnection(url, user, password);
        JSONReverser jr = new JSONReverser();
        jr.setParentNode(type);
        int i = 1;
        MdNode exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("index");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "string", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("type");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "string", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("id");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "string", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("parent");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "string", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        MdNode doc = jr.reverse(conn2.getInputStream(), StandardCharsets.UTF_8.toString());
        MdNode hitsO = doc.getNodeByName("com.stambia.json.object", "hits");
        MdNode hitsA = hitsO.getNodeByName("com.stambia.json.array", "hits");
        MdNode item = hitsA.getNodeByName("com.stambia.json.object", "item");
        if (item != null) {
            MdNode source = item.getNodeByName("com.stambia.json.object", "_source");
            source.setPosition(BigInteger.valueOf(i++));
            source.setName("document");
            type.getNode().add((Object)source);
            index.getNode().add((Object)type);
        }
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("version");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "number", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("found");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "boolean", false);
        exchattr.setPosition(BigInteger.valueOf(i++));
        exchattr = MdFactoryHelper.createMdNode((String)"com.stambia.json.value");
        exchattr.setName("created");
        type.getNode().add((Object)exchattr);
        exchattr.setAttribute("type", "boolean", false);
        exchattr.setPosition(BigInteger.valueOf(i));
    }

    static HttpURLConnection getConnection(URL url, String user, String password) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        if (user != null) {
            if (password != null && !password.isEmpty()) {
                try {
                    String decrypt;
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    password = decrypt = semaphoreManager.getStringAsciiInfo(password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String encoded = DatatypeConverter.printBase64Binary((byte[])(String.valueOf(user) + ":" + password).getBytes());
            http.setRequestProperty("Authorization", "Basic " + encoded);
        }
        if (http instanceof HttpsURLConnection) {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, null, new SecureRandom());
            ((HttpsURLConnection)http).setSSLSocketFactory(sc.getSocketFactory());
        }
        return http;
    }

    public static List<MdNode> getReversedNodes(RelevantNodes relevant, int mode, String data) throws ExecuteException {
        try {
            MdNode doc = relevant.getDocNode();
            MdNode index = relevant.getIndexNode();
            MdNode node = relevant.getCurrentNode();
            String urlStr = node.evaluate("ancestor-or-self::*/@httpUrl");
            if (urlStr == null || urlStr.isEmpty()) {
                throw new ExecuteException(Messages.ReverseDocAction_58);
            }
            URL url = new URL(String.valueOf(urlStr) + "/_all");
            String user = node.evaluate("ancestor-or-self::*/@httpUser");
            String password = node.evaluate("ancestor-or-self::*/@httpPassword");
            HttpURLConnection conn = ReverseDocAction.getConnection(url, user, password);
            JsonNode jsnode = JsonNode.parse((InputStream)conn.getInputStream(), (String)StandardCharsets.UTF_8.toString());
            ArrayList<MdNode> nodes = new ArrayList<MdNode>();
            HashSet<String> docTypeAlreadyDone = new HashSet<String>();
            HashMap<String, ArrayList<String>> aliasesMap = new HashMap<String, ArrayList<String>>();
            if (jsnode.isObject()) {
                for (String key : jsnode.keys()) {
                    JsonNode mappings;
                    JsonNode currentIndex;
                    String indexName;
                    MdNode nodeIndex = null;
                    JsonNode currentNode = jsnode.get(key);
                    HashSet aliases = new HashSet();
                    JsonNode currentAliases = currentNode.get("aliases");
                    if (currentAliases != null && currentAliases.isObject()) {
                        aliases.addAll(currentAliases.keys());
                    }
                    String string = indexName = index != null ? index.evaluate("if (@physicalName!='') then @physicalName else @name") : "__No__Index__";
                    if (index == null || aliases.contains(indexName) || indexName.equals(key)) {
                        nodeIndex = MdFactoryHelper.createMdNode((String)"com.stambia.elasticsearch.index");
                        nodeIndex.setSubstituteContainer((EObject)node);
                        nodeIndex.setName(index.getName());
                        nodeIndex.setAttribute("physicalName", indexName, false);
                        if (aliases.contains(indexName)) {
                            ArrayList<String> list = (ArrayList<String>)aliasesMap.get(indexName);
                            if (list == null) {
                                list = new ArrayList<String>();
                                aliasesMap.put(indexName, list);
                            }
                            list.add(key);
                        }
                        nodes.add(nodeIndex);
                    }
                    if (nodeIndex == null || !(currentIndex = jsnode.get(key)).isObject() || !(mappings = currentIndex.get("mappings")).isObject()) continue;
                    for (String keyType : mappings.keys()) {
                        String docName;
                        if (docTypeAlreadyDone.contains(keyType)) continue;
                        String string2 = docName = doc != null ? doc.evaluate("if (@physicalName!='') then @physicalName else @name") : "__No__DOC__";
                        if (doc != null && !docName.equals(keyType) && version < 7) continue;
                        ReverseDocAction.reverseType(nodeIndex, index, key, version >= 7 ? Messages.ReverseDocAction_1 : keyType, urlStr, doc != null ? doc.getId() : null);
                        docTypeAlreadyDone.add(docName);
                    }
                }
                if (!nodes.isEmpty() && !aliasesMap.isEmpty()) {
                    for (MdNode ___node : nodes) {
                        List list = (List)aliasesMap.get(___node.getName());
                        if (list == null) continue;
                        ReverseDocAction.addUnboudedStringAttribute(___node, "indexes", list);
                    }
                }
            }
            return nodes;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    public static void reverse(MdNode node, int mode, String data) throws ExecuteException {
        try {
            MdNode doc;
            Object object = doc = node.getDefType().contains("type") ? node : null;
            Object index = doc != null ? (MdNode)doc.eContainer() : (node.getDefType().contains("index") ? node : null);
            MdNode server = index != null ? (MdNode)index.eContainer() : node;
            RelevantNodes relevant = new RelevantNodes(doc, (MdNode)index, server, node);
            List<MdNode> nodes = ReverseDocAction.getReversedNodes(relevant, mode, data);
            MdNode newlyReversedNode = null;
            MdNode rootCandidateNode = nodes.get(0);
            if (rootCandidateNode.getName().equals(node.getName()) && rootCandidateNode.getDefType().equals(node.getDefType()) && "com.stambia.elasticsearch.index".equals(node.getDefType())) {
                newlyReversedNode = rootCandidateNode;
            } else {
                for (MdNode candidateNode : rootCandidateNode.getNode()) {
                    if (!candidateNode.getName().equals(node.getName()) || !candidateNode.getDefType().equals(node.getDefType()) || !"com.stambia.elasticsearch.type".equals(node.getDefType())) continue;
                    newlyReversedNode = candidateNode;
                    break;
                }
            }
            HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
            reverseNodes.put(newlyReversedNode, node);
            nodes.get(0).getDefType();
            nodes.get(0).getNode();
            IncrementalReverser ir = new IncrementalReverser((EObject)server, reverseNodes, Collections.emptyList(), false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
    }

    private static void addUnboudedStringAttribute(MdNode node, String code, List<String> values) {
        Attribute attr = MdFactoryHelper.createAttribute((String)(String.valueOf(node.getDefType()) + "." + code));
        node.getAttribute().add((Object)attr);
        attr.getValues().addAll(values);
    }

    public static SSLContext getSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, null, new SecureRandom());
        return sc;
    }

    public static int getElasticsearchVersion(MdNode node) throws ExecuteException {
        try {
            JsonNode versionNode;
            String password;
            String urlStr = node.evaluate("ancestor-or-self::*/@httpUrl");
            if (urlStr == null || urlStr.isEmpty()) {
                throw new ExecuteException(Messages.ReverseDocAction_3);
            }
            URL url = new URL(urlStr);
            String user = node.evaluate("ancestor-or-self::*/@httpUser");
            HttpURLConnection conn = ReverseDocAction.getConnection(url, user, password = node.evaluate("ancestor-or-self::*/@httpPassword"));
            JsonNode jsnode = JsonNode.parse((InputStream)conn.getInputStream(), (String)"UTF-8");
            if (jsnode != null && (versionNode = jsnode.get("version")) != null) {
                JsonNode number = versionNode.get("number");
                String versionString = number.getString();
                return Integer.parseInt(versionString.split("\\.")[0]);
            }
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException(e);
        }
        return 0;
    }

    public static class RelevantNodes {
        private MdNode docNode;
        private MdNode indexNode;
        private MdNode serverNode;
        private MdNode currentNode;

        public RelevantNodes(MdNode docNode, MdNode indexNode, MdNode serverNode, MdNode currentNode) {
            this.docNode = docNode;
            this.indexNode = indexNode;
            this.serverNode = serverNode;
            this.currentNode = currentNode;
        }

        public MdNode getDocNode() {
            return this.docNode;
        }

        public MdNode getIndexNode() {
            return this.indexNode;
        }

        public MdNode getServerNode() {
            return this.serverNode;
        }

        public MdNode getCurrentNode() {
            return this.currentNode;
        }
    }
}

