/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.elasticsearch.action;

import com.indy.addons.elasticsearch.Messages;
import com.indy.addons.elasticsearch.action.ReverseDocAction;
import com.indy.addons.json.JSONReverser;
import com.indy.runtime.json.JsonUtils;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IExecute;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ExecuteException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class ReverseSearchAction
implements IExecute {
    private static int version = 0;

    public static void reverse(MdNode node, InputStream is, String encoding) throws Exception {
    }

    public Object run(Object object, String configuration, Map<String, String> params) throws ExecuteException {
        MdNode node = (MdNode)object;
        version = ReverseDocAction.getElasticsearchVersion(node);
        ReverseSearchAction.reverse(node, 0);
        return null;
    }

    public static void reverse(MdNode node, int mode) throws ExecuteException {
        ReverseSearchAction.reverse(node, mode, null);
    }

    public static List<MdNode> getReversedNodes(MdNode currentNode, int mode, String data) throws ExecuteException {
        try {
            int code;
            MdNode aggs;
            MdNode aggregations;
            String reverseFrom;
            String urlStr = currentNode.evaluate("ancestor-or-self::*/@httpUrl");
            String index = currentNode.evaluate("@indexes");
            String type = currentNode.evaluate("@types");
            String query = currentNode.evaluate("@query");
            if (urlStr == null || urlStr.isEmpty()) {
                throw new ExecuteException(Messages.ReverseSearchAction_4);
            }
            List _nodes = (List)currentNode.evaluateMdSet("*[name()='value' and @name!='response']");
            String strUrl = version >= 7 ? String.valueOf(urlStr) + "/" + index + "/_search" : String.valueOf(urlStr) + "/" + index + "/" + type + "/_search";
            String reverseSize = currentNode.evaluate("ancestor-or-self::server/@reverseSize");
            if (reverseSize != null && !reverseSize.isEmpty()) {
                strUrl = String.valueOf(strUrl) + "?size=" + reverseSize;
            }
            if ((reverseFrom = currentNode.evaluate("ancestor-or-self::server/@reverseFrom")) != null && !reverseFrom.isEmpty()) {
                strUrl = reverseSize != null && !reverseSize.isEmpty() ? String.valueOf(strUrl) + "&" : String.valueOf(strUrl) + "?";
                strUrl = String.valueOf(strUrl) + "from=" + reverseFrom;
            }
            URL url = new URL(strUrl);
            String user = currentNode.evaluate("ancestor-or-self::*/@httpUser");
            String password = currentNode.evaluate("ancestor-or-self::*/@httpPassword");
            HttpURLConnection conn = ReverseDocAction.getConnection(url, user, password);
            conn.setRequestMethod("POST");
            conn.addRequestProperty("Content-type", "application/json; charset=UTF-8");
            conn.setDoInput(true);
            conn.setDoOutput(true);
            OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
            HashMap<String, String> inputParams = new HashMap<String, String>();
            for (MdNode o : _nodes) {
                String val = o.evaluate("@reverseValue");
                if (val == null) continue;
                String _type = o.evaluate("@type");
                if (_type != null && _type.equals("string")) {
                    inputParams.put(o.getName(), "\"" + val + "\"");
                    continue;
                }
                inputParams.put(o.getName(), val);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JsonUtils.convertJsonToXml((InputStream)new ByteArrayInputStream(query.getBytes("UTF-8")), (OutputStream)os, (String)"UTF-8", (String)"UTF-8", (boolean)false, inputParams);
            ByteArrayOutputStream os2 = new ByteArrayOutputStream();
            JsonUtils.convertXmlToJson((InputStream)new ByteArrayInputStream(os.toByteArray()), (OutputStream)os2, (String)"UTF-8", (String)"UTF-8");
            String _query = new String(os2.toByteArray());
            osw.write(_query);
            osw.close();
            ArrayList<MdNode> nodes = new ArrayList<MdNode>();
            JSONReverser jsonR = new JSONReverser();
            jsonR.setParentNode(currentNode);
            MdNode n = jsonR.reverse(conn.getInputStream(), "UTF-8");
            MdNode hits = n.getNodeByName("com.stambia.json.object", "hits");
            if (hits != null && (hits = hits.getNodeByName("com.stambia.json.array", "hits")) != null && hits.getNode().size() > 0) {
                for (MdNode _node : hits.getNode()) {
                    _node.setName("hit");
                    for (MdNode __node : _node.getNode()) {
                        if (__node.getName().equals("_source")) {
                            __node.setName("document");
                        }
                        if (!__node.getName().startsWith("_")) continue;
                        __node.setName(__node.getName().substring(1));
                    }
                }
                nodes.add(hits);
            }
            if ((aggregations = n.getNodeByName("com.stambia.json.object", "aggregations")) != null) {
                nodes.add(aggregations);
            }
            if ((aggs = n.getNodeByName("com.stambia.json.object", "aggs")) != null) {
                aggs.setName("aggregations");
                nodes.add(aggs);
            }
            if ((code = conn.getResponseCode()) != 200) {
                throw new ExecuteException(conn.getResponseMessage());
            }
            return nodes;
        }
        catch (Exception e) {
            if (e instanceof ExecuteException) {
                throw (ExecuteException)((Object)e);
            }
            throw new ExecuteException(e);
        }
    }

    public static void reverse(MdNode node, int mode, String data) throws ExecuteException {
        try {
            List<MdNode> nodes = ReverseSearchAction.getReversedNodes(node, mode, data);
            HashMap<MdNode, MdNode> reverseNodes = new HashMap<MdNode, MdNode>();
            for (MdNode n : new ArrayList<MdNode>(nodes)) {
                reverseNodes.put(n, node.getNodeByName(n.getDefType(), n.getName()));
                n.setSubstituteContainer((EObject)node);
                if (!(n.eContainer() instanceof MdNode)) continue;
                ((MdNode)n.eContainer()).getNode().remove((Object)n);
            }
            IncrementalReverser ir = new IncrementalReverser((EObject)node, reverseNodes, Collections.EMPTY_LIST, false, null, null, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
        }
        catch (Exception e) {
            if (e instanceof ExecuteException) {
                throw (ExecuteException)((Object)e);
            }
            throw new ExecuteException(e);
        }
    }
}

