/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file;

import com.stambia.jdbc.driver.file.AbstractDriver;
import com.stambia.jdbc.driver.file.FileDriverConnection;
import com.stambia.jdbc.driver.file.Messages;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetColumn;
import com.stambia.jdbc.driver.file.resultset.FileDriverResultSetMetaData;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDriver
extends AbstractDriver {
    public static final int SELECT_COLUMN = 0;
    public static final int WHERE_COLUMN = 1;
    private static final String URL_PREFIX = "jdbc:semarchy:file";
    private static final String LEGACY_URL_PREFIX = "jdbc:stambia:file";
    private static final String URL_FOLDER = "folder=";
    private static final String URL_METADATA = "metadata=";
    private static final String URL_LOG = "log=";
    public static final String URL_READER_VERSION = "readerversion=";

    static {
        try {
            DriverManager.registerDriver(new FileDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String ret = sw.toString();
        return ret;
    }

    public static FileDriverResultSetColumn createColMetadata(FileDriverResultSetMetaData colFather, String colClassName, int colNum, String colName, String colLabel, int colType, int colDisplaySize, int colPrecision, int colScale) {
        FileDriverResultSetColumn col = new FileDriverResultSetColumn();
        col.setClassName(colClassName);
        col.setFather(colFather);
        col.setColNum(colNum);
        col.setName(colName);
        col.setLabel(colLabel);
        col.setType(colType);
        col.setDisplaySize(colDisplaySize);
        col.setPrecision(colPrecision);
        col.setScale(colScale);
        return col;
    }

    public static String getTypeNameFromSQLType(int colType) {
        String ret;
        switch (colType) {
            case -5: {
                ret = "java.lang.Long";
                break;
            }
            case -7: {
                ret = "java.lang.Boolean";
                break;
            }
            case 1: {
                ret = "java.lang.String";
                break;
            }
            case 91: {
                ret = "java.sql.Date";
                break;
            }
            case 3: {
                ret = "java.math.BigDecimal";
                break;
            }
            case 8: {
                ret = "java.lang.Double";
                break;
            }
            case 6: {
                ret = "java.lang.Double";
                break;
            }
            case 4: {
                ret = "java.lang.Integer";
                break;
            }
            case -1: {
                ret = "java.lang.String";
                break;
            }
            case 2: {
                ret = "java.math.BigDecimal";
                break;
            }
            case 7: {
                ret = "java.lang.Float";
                break;
            }
            case 5: {
                ret = "java.lang.Short";
                break;
            }
            case 92: {
                ret = "java.sql.Time";
                break;
            }
            case 93: {
                ret = "java.sql.TimeStamp";
                break;
            }
            case -6: {
                ret = "java.lang.Byte";
                break;
            }
            case 12: {
                ret = "java.lang.String";
                break;
            }
            default: {
                ret = "java.lang.String";
            }
        }
        return ret;
    }

    @Override
    public int getMajorVersion() {
        return FileDriver.getDriverMajorVersion();
    }

    public static int getDriverMajorVersion() {
        return 1;
    }

    public static int getDriverMinorVersion() {
        return 250;
    }

    @Override
    public int getMinorVersion() {
        return FileDriver.getDriverMinorVersion();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!url.startsWith(URL_PREFIX) && !url.startsWith(LEGACY_URL_PREFIX)) {
            return null;
        }
        String paramGlobalUrlPattern = "(\\?.*=.*)?|(\\?.*=.*){1}(&.*=.*)*";
        Pattern pattGlobal = Pattern.compile(paramGlobalUrlPattern);
        if (url.startsWith(LEGACY_URL_PREFIX)) {
            url = url.replace(URL_PREFIX, "");
        }
        String chaine = url.replace(URL_PREFIX, "");
        Matcher m1 = pattGlobal.matcher(chaine);
        String path = "./";
        String metadataPath = "";
        String logPath = "";
        String readerVersion = "";
        if (m1.matches()) {
            String elementUrlPattern = "(\\?[^&]*=[^&]*|&[^&]*=[^&]*)";
            Pattern pattElement = Pattern.compile(elementUrlPattern);
            Matcher m2 = pattElement.matcher(chaine);
            String param = "";
            while (m2.find()) {
                param = m2.group(0).substring(1);
                if (param.startsWith(URL_FOLDER)) {
                    path = param.substring(URL_FOLDER.length());
                    continue;
                }
                if (param.startsWith(URL_METADATA)) {
                    metadataPath = param.substring(URL_METADATA.length());
                    continue;
                }
                if (param.startsWith(URL_LOG)) {
                    logPath = param.substring(URL_LOG.length());
                    continue;
                }
                if (!param.startsWith(URL_READER_VERSION)) continue;
                readerVersion = param.substring(URL_READER_VERSION.length());
            }
        }
        if (!path.equals("")) {
            File file = new File(path);
            if (!file.exists()) {
                throw new SQLException(String.valueOf(Messages.getString("FileDriver.11")) + path + Messages.getString("FileDriver.12"));
            }
            if (!file.isDirectory()) {
                throw new SQLException(String.valueOf(Messages.getString("FileDriver.13")) + path + Messages.getString("FileDriver.14"));
            }
        }
        if (readerVersion != null && !readerVersion.isEmpty()) {
            info = info == null ? new Properties() : new Properties(info);
            info.put("readerversion", readerVersion);
        }
        FileDriverConnection fdc = new FileDriverConnection(info);
        if (!logPath.equals("")) {
            fdc.setLogFileName(logPath);
            fdc.openLogFile();
        }
        if (!metadataPath.equals("")) {
            fdc.setMetadataFromXmlFile(metadataPath);
        }
        return fdc;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url != null) {
            return url.startsWith(URL_PREFIX) || url.startsWith(LEGACY_URL_PREFIX);
        }
        return false;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public static String leftPad(String stringToPad, String padder, int size) {
        if (padder.length() == 0) {
            return stringToPad;
        }
        StringBuffer strb = new StringBuffer(size);
        StringCharacterIterator sci = new StringCharacterIterator(padder);
        while (strb.length() < size - stringToPad.length()) {
            char ch = sci.first();
            while (ch != '\uffff') {
                if (strb.length() < size - stringToPad.length()) {
                    strb.insert(strb.length(), String.valueOf(ch));
                }
                ch = sci.next();
            }
        }
        return strb.append(stringToPad).toString();
    }

    public static String rightPad(String stringToPad, String padder, int size) {
        if (padder.length() == 0) {
            return stringToPad;
        }
        StringBuffer strb = new StringBuffer(stringToPad);
        StringCharacterIterator sci = new StringCharacterIterator(padder);
        while (strb.length() < size) {
            char ch = sci.first();
            while (ch != '\uffff') {
                if (strb.length() < size) {
                    strb.append(String.valueOf(ch));
                }
                ch = sci.next();
            }
        }
        return strb.toString();
    }

    public static String ltrim(String _string) {
        _string = _string.replaceAll("^ *", "");
        return _string;
    }

    public static String rtrim(String _string) {
        _string = _string.replaceAll(" *$", "");
        return _string;
    }

    public static enum FD_CODE_MSG {
        FD_010_001,
        FD_010_002,
        FD_010_003,
        FD_010_004,
        FD_010_005,
        FD_010_006,
        FD_010_007,
        FD_010_008,
        FD_010_009,
        FD_010_010,
        FD_010_011,
        FD_010_012;


        public String getMessage() {
            return this.getMessage(null, new String[0]);
        }

        public String getMessage(String data, String[] str) {
            String tmp = this._getMessage(data, str);
            if (tmp != null) {
                return String.valueOf(this.toString()) + ": " + tmp;
            }
            return this.toString();
        }

        private String _getMessage(String data, String[] str) {
            if (data != null) {
                str = Arrays.copyOf(str, str.length + 1);
                str[str.length - 1] = data;
            }
            switch (this) {
                case FD_010_002: {
                    return Messages.getString("FileDriver.0");
                }
                case FD_010_003: {
                    return Messages.getString("FileDriver.1");
                }
                case FD_010_004: {
                    return Messages.getString("FileDriver.2");
                }
                case FD_010_005: {
                    return Messages.getString("FileDriver.3");
                }
                case FD_010_006: {
                    return String.format(Messages.getString("FileDriver.4"), str);
                }
                case FD_010_007: {
                    return String.format(Messages.getString("FileDriver.5"), str);
                }
                case FD_010_008: {
                    return String.format(Messages.getString("FileDriver.6"), str);
                }
                case FD_010_009: {
                    return String.format(Messages.getString("FileDriver.7"), str);
                }
                case FD_010_010: {
                    return String.format(Messages.getString("FileDriver.8"), str);
                }
                case FD_010_011: {
                    return String.format(Messages.getString("FileDriver.9"), str);
                }
                case FD_010_012: {
                    return Messages.getString("FileDriver.10");
                }
            }
            return null;
        }
    }
}

