/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileManagment;

import com.stambia.jdbc.driver.file.tools.BinaryNumber;
import com.stambia.jdbc.driver.file.tools.StbScriptEngineManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class TransformInputStreamWithScript {
    public static void main(String[] args) throws IOException {
        int i;
        FileInputStream is = new FileInputStream("d:/temp/myexport.txt");
        StringBuffer script = new StringBuffer();
        script.append("i=0;\ndo{\n\ti=__in__.read();\n\tif (i>-1){\n\t\tch=String.fromCharCode(i);\n\t\tif (ch=='1')\n \t\t\tch='9';\n\t\ti=ch.charCodeAt();\n\t\t__out__.write(i);\n\t\t}}while(i>-1);");
        InputStream in = TransformInputStreamWithScript.transform(is, script.toString(), "rhino");
        do {
            if ((i = in.read()) == -1) continue;
            System.out.print((char)i);
        } while (i != -1);
        in.close();
    }

    public static InputStream transform(final InputStream is, final String script, String language) throws IOException {
        final Exception[] ex = new Exception[1];
        PipedInputStream in = new PipedInputStream(){

            @Override
            public synchronized int available() throws IOException {
                if (ex[0] != null) {
                    throw new IOException(ex[0]);
                }
                return super.available();
            }

            @Override
            protected synchronized void receive(int b) throws IOException {
                if (ex[0] != null) {
                    throw new IOException(ex[0]);
                }
                super.receive(b);
            }

            @Override
            public synchronized int read() throws IOException {
                if (ex[0] != null) {
                    throw new IOException(ex[0]);
                }
                return super.read();
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) throws IOException {
                if (ex[0] != null) {
                    throw new IOException(ex[0]);
                }
                return super.read(b, off, len);
            }
        };
        final PipedOutputStream out = new PipedOutputStream(in);
        StbScriptEngineManager scriptEngineManager = new StbScriptEngineManager();
        language = language == null ? "rhino" : language;
        final ScriptEngine scriptEngine = ((ScriptEngineManager)scriptEngineManager).getEngineByName(language);
        final Bindings bindings = scriptEngine.getBindings(100);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        bindings.put("__in__", (Object)is);
                        bindings.put("__out__", (Object)out);
                        Api api = new Api();
                        bindings.put("__api__", (Object)api);
                        scriptEngine.eval(script);
                    }
                    catch (ScriptException e) {
                        ex[0] = e;
                        try {
                            is.close();
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        is.close();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        t.start();
        return in;
    }

    public static class Api {
        public String leftPad(String s, int length, String pad) {
            return this.pad(s, length, pad, true);
        }

        public String rightPad(String s, int length, String pad) {
            return this.pad(s, length, pad, false);
        }

        private String pad(String s, int length, String pad, boolean leftPad) {
            while (s.length() < length) {
                s = leftPad ? String.valueOf(pad) + s : String.valueOf(s) + pad;
            }
            if (s.length() > length) {
                if (leftPad) {
                    return s.substring(s.length() - length);
                }
                return s.substring(0, length);
            }
            return s;
        }

        public long parseFixedBinary(String str, boolean signed, ByteOrder order, String encoding) {
            byte[] result = encoding != null ? str.getBytes(Charset.forName(encoding)) : str.getBytes();
            long l = BinaryNumber.getLong(result, signed, order);
            return l;
        }

        public long parseFixedBinary(byte[] b, boolean signed, ByteOrder order) {
            return BinaryNumber.getLong(b, signed, order);
        }

        public long parseFixedBinary(int[] b, boolean signed, ByteOrder order) {
            byte[] b2 = new byte[b.length];
            int i = 0;
            while (i < b.length) {
                b2[i] = (byte)b[i];
                ++i;
            }
            return BinaryNumber.getLong(b2, signed, order);
        }
    }
}

