/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataDirectory;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataEnreg;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MetadataFile
extends MetadataEnreg {
    String id;
    String readingScript;
    String languageScript;
    MetadataDirectory father;
    String physicalName;
    int type;
    String lineSeparator = MetadataServer.DEFAULT_LINE_SEPARATOR;
    String fieldSeparator = ",";
    String decimalSeparator = ".";
    String escapeChar = "";
    String stringDelimiter = "";
    boolean addDelimiterToAll = false;
    String charsetName = "";
    int headerSize = 0;
    ErrorBehaviour fieldErrorBehaviour = new ErrorBehaviour(ErrorMode.abort, false);
    boolean raiseExceptionAtTheEnd = false;
    ErrorBehaviour wrongNumberFieldBehaviour = new ErrorBehaviour(ErrorMode.disableCheck, false);
    ErrorBehaviour trailingFieldsBehaviour = new ErrorBehaviour(ErrorMode.disableCheck, false);
    private String stringDefaultValue;
    private boolean emptyStringAsNull;
    private String numericDefaultValue;
    private String dateDefaultValue;
    private String timestampDefaultValue;
    private String lineSize = "-1";
    private String lineTransformationLanguage;
    private String lineTransformationScript;
    ByteOrder byteOrder;
    boolean disableRightTrimOnString = false;
    boolean enableLeftTrimOnString = false;
    String defaultDecimalFormat;
    String defaultTimestampFormat;
    String defaultGroupingSeparator;
    String defaultDateFormat;
    private String numericPaddingChar = MetadataServer.DEFAULT_NUMERIC_PADDING_CHAR;
    String propertyFieldPrefix = "";
    int lastLineToSkip;

    public String getReadingScript() {
        return this.readingScript;
    }

    public void setReadScript(String readScript) {
        this.readingScript = readScript != null && readScript.trim().length() == 0 ? null : readScript;
    }

    public String getLanguageScript() {
        return this.languageScript;
    }

    public void setReadingScriptLanguage(String languageScript) {
        this.languageScript = languageScript;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public MetadataFile(MetadataDirectory pFather) {
        this.father = pFather;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public String getStringDelimiter() {
        return this.stringDelimiter;
    }

    public void setStringDelimiter(String stringDelimiter) {
        this.stringDelimiter = stringDelimiter;
    }

    public void setHexaStringDelimiter(String stringDelimiter) throws UnsupportedEncodingException {
        this.stringDelimiter = MetadataServer.hexStringToString(stringDelimiter);
    }

    public MetadataDirectory getFather() {
        return this.father;
    }

    public void setFather(MetadataDirectory father) {
        this.father = father;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String physicalName) {
        this.physicalName = physicalName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void setHexaLineSeparator(String lineSeparator) throws UnsupportedEncodingException {
        this.lineSeparator = MetadataServer.hexStringToString(lineSeparator);
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setHexaFieldSeparator(String fieldSeparator) throws UnsupportedEncodingException {
        this.fieldSeparator = MetadataServer.hexStringToString(fieldSeparator);
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public ErrorBehaviour getFieldErrorBehaviour() {
        return this.fieldErrorBehaviour;
    }

    public void setRaiseExceptionAtTheEnd(boolean raiseExceptionAtTheEnd) {
        this.raiseExceptionAtTheEnd = raiseExceptionAtTheEnd;
    }

    public boolean getRaiseExceptionAtTheEnd() {
        return this.raiseExceptionAtTheEnd;
    }

    public ErrorBehaviour getWrongNumberFieldBehaviour() {
        return this.wrongNumberFieldBehaviour;
    }

    public ErrorBehaviour getTrailingFieldsBehaviour() {
        return this.trailingFieldsBehaviour;
    }

    public void setEmptyStringAsNull(boolean emptyStringAsNull) {
        this.emptyStringAsNull = emptyStringAsNull;
    }

    public String getStringDefaultValue() {
        return this.stringDefaultValue;
    }

    public boolean isEmptyStringAsNull() {
        return this.emptyStringAsNull;
    }

    public String getNumericDefaultValue() {
        return this.numericDefaultValue;
    }

    public String getDateDefaultValue() {
        return this.dateDefaultValue;
    }

    public String getTimestampDefaultValue() {
        return this.timestampDefaultValue;
    }

    public void setHexaDecimalSeparator(String decimalSeparator) throws UnsupportedEncodingException {
        this.decimalSeparator = MetadataServer.hexStringToString(decimalSeparator);
    }

    public void setStringDefaultValue(String nodeValue) {
        this.stringDefaultValue = nodeValue;
    }

    public void setNumericDefaultValue(String nodeValue) {
        this.numericDefaultValue = nodeValue;
    }

    public void setDateDefaultValue(String nodeValue) {
        this.dateDefaultValue = nodeValue;
    }

    public void setTimestampDefaultValue(String nodeValue) {
        this.timestampDefaultValue = nodeValue;
    }

    public String getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(String parseInt) {
        this.lineSize = parseInt;
    }

    @Override
    public IMetadataColumn getColumnByPosition(int pos) {
        if (this.mapCol == null) {
            this.mapCol = new HashMap();
            MetadataColumn[] list = (MetadataColumn[])this.getLstColumns();
            List<MetadataColumn> _list = Arrays.asList(list);
            Collections.sort(_list, new Comparator<MetadataColumn>(){

                @Override
                public int compare(MetadataColumn o1, MetadataColumn o2) {
                    return new Integer(o1.getPosition()).compareTo(new Integer(o2.getPosition()));
                }
            });
            int i = 0;
            while (i < list.length) {
                MetadataColumn mc = _list.get(i);
                this.mapCol.put(i, mc);
                ++i;
            }
        }
        return (IMetadataColumn)this.mapCol.get(pos);
    }

    @Override
    public IMetadataColumn getColumn(int index) {
        if (index >= 0 && index < this.lstColumns.length) {
            return this.lstColumns[index];
        }
        return null;
    }

    @Override
    public IMetadataColumn getColumn(String name) {
        IMetadataColumn col = null;
        int i = 0;
        while (i < this.lstColumns.length) {
            if (this.lstColumns[i].getName().equals(name)) {
                return this.lstColumns[i];
            }
            ++i;
        }
        return col;
    }

    @Override
    public void close() {
        super.close();
    }

    public String getLineTransformationLanguage() {
        return this.lineTransformationLanguage;
    }

    public String getLineTransformationScript() {
        return this.lineTransformationScript;
    }

    public void setTransformLineScriptLanguage(String lineTransformationLanguage) {
        this.lineTransformationLanguage = lineTransformationLanguage;
    }

    public void setTransformLineScript(String lineTransformationScript) {
        this.lineTransformationScript = lineTransformationScript;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean isDisableRightTrimOnString() {
        return this.disableRightTrimOnString;
    }

    public void setDisableRightTrimOnString(String disableRightTrimOnString) {
        this.disableRightTrimOnString = Boolean.valueOf(disableRightTrimOnString);
    }

    public boolean isEnableLeftTrimOnString() {
        return this.enableLeftTrimOnString;
    }

    public void setEnableLeftTrimOnString(String paramBoolean) {
        this.enableLeftTrimOnString = Boolean.valueOf(paramBoolean);
    }

    public String getDefaultDecimalFormat() {
        return this.defaultDecimalFormat;
    }

    public void setDefaultDecimalFormat(String defaultDecimalFormat) {
        this.defaultDecimalFormat = defaultDecimalFormat;
    }

    public String getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    public void setDefaultTimestampFormat(String defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    public String getDefaultGroupingSeparator() {
        return this.defaultGroupingSeparator;
    }

    public void setDefaultHexaGroupingSeparator(String groupingSeparator) throws UnsupportedEncodingException {
        this.defaultGroupingSeparator = MetadataServer.hexStringToString(groupingSeparator);
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public void setHexaNumericPaddingChar(String NumericPaddingChar) throws UnsupportedEncodingException {
        this.numericPaddingChar = MetadataServer.hexStringToString(NumericPaddingChar);
    }

    public String getNumericPaddingChar() {
        return this.numericPaddingChar;
    }

    public String getPropertyFieldPrefix() {
        return this.propertyFieldPrefix;
    }

    public void setPropertyFieldPrefix(String string) {
        this.propertyFieldPrefix = string;
    }

    public int getLastLineToSkip() {
        return this.lastLineToSkip;
    }

    public void setLastLineToSkip(int lastLinePosition) {
        this.lastLineToSkip = lastLinePosition;
    }

    public boolean isAddDelimiterToAll() {
        return this.addDelimiterToAll;
    }

    public void setAddDelimiterToAll(boolean addDelimiterToAll) {
        this.addDelimiterToAll = addDelimiterToAll;
    }

    public class ErrorBehaviour {
        ErrorMode errorMode;
        boolean redirectToBadFile;
        boolean checkSize;

        public ErrorMode getErrorMode() {
            return this.errorMode;
        }

        public void setCheckSize(boolean checkSize) {
            this.checkSize = checkSize;
        }

        public boolean hasCheckSize() {
            return this.checkSize;
        }

        public void setErrorMode(ErrorMode errorMode) {
            this.errorMode = errorMode;
        }

        public boolean isRedirectToBadFile() {
            return this.redirectToBadFile;
        }

        public void setRedirectToBadFile(boolean redirectToBadFile) {
            this.redirectToBadFile = redirectToBadFile;
        }

        public ErrorBehaviour(ErrorMode raiseError, boolean redirectToBadFile) {
            this.errorMode = raiseError;
            this.redirectToBadFile = redirectToBadFile;
        }

        public boolean isRaiseError() {
            return this.errorMode.equals(ErrorMode.raiseException);
        }

        public boolean isSkipField() {
            return this.errorMode.equals(ErrorMode.skipField);
        }

        public boolean isSkipLine() {
            return this.errorMode.equals(ErrorMode.skipRecord);
        }
    }

    public static enum ErrorMode {
        skipLine(new ErrorMode[0]),
        skipRecord(skipLine),
        skipField(new ErrorMode[0]),
        raiseException(new ErrorMode[0]),
        disableCheck(new ErrorMode[0]),
        abort(raiseException),
        ignoreError(disableCheck),
        rejectRecord(skipRecord),
        setToNull(new ErrorMode[0]),
        setToEmptyValue(new ErrorMode[0]);

        List<ErrorMode> aliases = new ArrayList<ErrorMode>();

        private ErrorMode(ErrorMode ... aliases) {
            this.aliases.addAll(Arrays.asList(aliases));
            ErrorMode[] errorModeArray = aliases;
            int n2 = aliases.length;
            int n3 = 0;
            while (n3 < n2) {
                ErrorMode em = errorModeArray[n3];
                if (!em.aliases.contains((Object)this)) {
                    em.aliases.add(this);
                }
                ++n3;
            }
        }

        public boolean equals(ErrorMode errorMode) {
            return this.equals(errorMode, new ArrayList<ErrorMode>());
        }

        private boolean equals(ErrorMode errorMode, List<ErrorMode> previous) {
            if (errorMode == this) {
                return true;
            }
            previous.add(this);
            for (ErrorMode em : this.aliases) {
                if (previous.contains((Object)em) || !em.equals(errorMode, previous)) continue;
                return true;
            }
            return false;
        }
    }
}

