/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileManagment.ILineContext;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.tools.Pointer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MetadataFilterSet
implements ILineContext {
    Map<String, MetadataFilterSet> sameLineFilterSet;
    List<MetadataFilterSet> sameLineFilterSetTodo;
    private IReadContext readContext;
    int ancestorBaseLevel = 0;
    List<MetadataFilter> filters = new ArrayList<MetadataFilter>();
    List<MetadataFilter> ancestorFilters = new ArrayList<MetadataFilter>();
    Map<String, MetadataFilterSet> children = new HashMap<String, MetadataFilterSet>();
    String name;
    MetadataFilterSet parent;
    private String currentLine;
    private String uuid;
    List<MetadataFilterSet> childrenOrdred;
    boolean newLine = true;
    int startPosition;
    int endPosition;
    MetadataFilterSet sameLineAncestor;
    Writer writer;
    int precParentLineNumber = -1;
    int lineNumber;
    long timestampid = -1L;
    int occurenceStart = -1;
    int occurenceSize = -1;
    int occurenceNumber = -1;
    String[] lines;
    int linePos = 0;
    private int order;

    public MetadataFilterSet(IReadContext context) {
        this.readContext = context;
    }

    public void setAncestorLevel(int level) {
        this.ancestorBaseLevel = level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChildren(String name, MetadataFilterSet child) {
        child.parent = this;
        if (child.ancestorBaseLevel > 0) {
            if (this.sameLineFilterSet == null) {
                this.sameLineFilterSet = new HashMap<String, MetadataFilterSet>();
            }
            this.sameLineFilterSet.put(name, child);
            child.sameLineAncestor = this.getFilterSet(child.ancestorBaseLevel - 1);
        } else {
            this.children.put(child.name, child);
        }
    }

    public void addFilter(List<MetadataFilter> filters) {
        for (MetadataFilter filter : filters) {
            if (filter.getAncestorLevel() > 0) {
                this.ancestorFilters.add(filter);
                continue;
            }
            this.filters.add(filter);
        }
    }

    public boolean testCurrent(String row, boolean exclusif, int linePosition, int endPosition) {
        if (this.filters.size() > 0) {
            for (MetadataFilter filter : this.filters) {
                if (filter.test(row, linePosition, endPosition)) continue;
                return false;
            }
        } else if (exclusif) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "MetadataFilterSet [name=" + this.name + ", ancestorBaseLevel=" + this.ancestorBaseLevel + ", occurenceSize=" + this.occurenceSize + ", occurenceNumber=" + this.occurenceNumber + ", occurenceStart=" + this.occurenceStart + ", filters=" + this.filters + ", ancestorFilters=" + this.ancestorFilters + ", \nchildren=" + this.children + "]";
    }

    public boolean testAncestor(boolean exclusif) {
        if (this.ancestorFilters.size() > 0) {
            for (MetadataFilter filter : this.ancestorFilters) {
                MetadataFilterSet set = this.getFilterSet(filter.ancestorLevel);
                if (set != null && filter.test(set.currentLine, set.startPosition, set.endPosition)) continue;
                return false;
            }
        } else if (exclusif) {
            return false;
        }
        return true;
    }

    public boolean testBoth(String row, boolean exclusif, int linePosition, int endPosition) {
        if (this.hasFilter()) {
            return this.testCurrent(row, true, linePosition, endPosition) || this.testAncestor(true);
        }
        return !exclusif;
    }

    @Override
    public Pointer<String> getLine() {
        return new Pointer<String>(this.currentLine);
    }

    public MetadataFilterSet getFilterSet(int ancestorLevel) {
        if (ancestorLevel == 0) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getFilterSet(ancestorLevel - 1);
        }
        return null;
    }

    public MetadataFilterSet determineFilterSet(String row, int linePosition, int endPosition) {
        if (this.testBoth(row, true, linePosition, endPosition)) {
            return this;
        }
        if (this.childrenOrdred == null) {
            this.childrenOrdred = new ArrayList<MetadataFilterSet>(this.children.values());
            Collections.sort(this.childrenOrdred, new Comparator<MetadataFilterSet>(){

                @Override
                public int compare(MetadataFilterSet o1, MetadataFilterSet o2) {
                    return o1.getOrder() - o1.getOrder();
                }
            });
        }
        for (MetadataFilterSet set : this.childrenOrdred) {
            if (!set.testBoth(row, true, linePosition, endPosition)) continue;
            return set;
        }
        if (this.parent != null) {
            return this.parent.determineFilterSet(row, linePosition, endPosition);
        }
        return null;
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public boolean hasFilter() {
        return this.filters.size() > 0 || this.ancestorFilters.size() > 0;
    }

    public List<MetadataFilter> getAncestorFilters() {
        return this.filters;
    }

    public int size() {
        if (this.children != null) {
            return this.children.size();
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getLocalPosition() {
        return this.lineNumber;
    }

    public void setCurrentLine(String str, int startPosition, int endPosition) {
        this.currentLine = str;
        this.newLine = true;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.uuid = null;
        this.lines = null;
        if (this.sameLineFilterSet != null && this.sameLineFilterSet.size() > 0) {
            this.sameLineFilterSetTodo = new ArrayList<MetadataFilterSet>(this.sameLineFilterSet.values());
        }
    }

    public MetadataFilterSet nextSameLineMetadataFilterSet() {
        if (this.sameLineFilterSetTodo != null && this.sameLineFilterSetTodo.size() > 0) {
            MetadataFilterSet ret = this.sameLineFilterSetTodo.get(0);
            this.sameLineFilterSetTodo.remove(0);
            return ret;
        }
        return null;
    }

    @Override
    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
        return this.uuid;
    }

    public void setParent(MetadataFilterSet parent) {
        this.parent = parent;
    }

    public void addWriter(BufferedWriter bufferedWriter) {
        this.writer = bufferedWriter;
    }

    public void write(Writer writer, String lineTerminator, boolean force) {
        if (this.currentLine != null) {
            try {
                if (writer == null) {
                    writer = new BufferedWriter(new FileWriter("d:/data/pmsipilot/split/" + this.getName()));
                }
                if (force || this.precParentLineNumber != this.parent.lineNumber) {
                    this.parent.write(writer, lineTerminator, true);
                }
                this.precParentLineNumber = this.parent.lineNumber;
                writer.write(String.valueOf(this.currentLine) + lineTerminator);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void write(String lineTerminator) {
        try {
            if (this.writer == null) {
                this.writer = new BufferedWriter(new FileWriter("d:/data/pmsipilot/split/" + this.getName()));
            }
            this.write(this.writer, lineTerminator, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeWriters() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        for (MetadataFilterSet child : this.children.values()) {
            child.closeWriters();
        }
    }

    @Override
    public String getTimeStampPosition() throws IOException {
        return String.valueOf(this.readContext.startTimeStamp()) + "." + this.getLocalPosition();
    }

    public MetadataFilterSet getSameLineAncsetor() {
        return this.sameLineAncestor;
    }

    public void setOccurenceStart(int occurenceStart) {
        this.occurenceStart = occurenceStart;
    }

    public void setOccurenceSize(int occurenceSize) {
        this.occurenceSize = occurenceSize;
    }

    public void setOccurenceNumber(int occurenceNumber) {
        this.occurenceNumber = occurenceNumber;
    }

    public int getOrder() {
        return this.order;
    }

    public String nextLine() {
        if (this.occurenceStart > -1 && this.occurenceSize > -1) {
            if (this.lines == null) {
                String before = null;
                String tmp = null;
                String after = null;
                int _occurenceStart = this.occurenceStart - 1;
                if (this.lines == null) {
                    tmp = this.occurenceNumber > -1 && this.occurenceNumber * this.occurenceSize < this.currentLine.length() ? this.currentLine.substring(_occurenceStart, _occurenceStart + this.occurenceNumber * this.occurenceSize) : this.currentLine.substring(_occurenceStart);
                }
                if (_occurenceStart > 0) {
                    before = this.currentLine.substring(0, _occurenceStart);
                }
                if (tmp.length() + _occurenceStart < this.currentLine.length()) {
                    after = this.currentLine.substring(tmp.length() + _occurenceStart);
                }
                if (tmp != null) {
                    int startIndex = 0;
                    int endIndex = 0;
                    int size = tmp.length() / this.occurenceSize;
                    this.lines = new String[size];
                    int i = 0;
                    while (i < size) {
                        startIndex = i * this.occurenceSize;
                        endIndex = (i + 1) * this.occurenceSize;
                        String tmp2 = tmp.substring(startIndex, endIndex);
                        this.lines[i] = before != null && after != null ? String.valueOf(before) + tmp2 + after : (before != null ? String.valueOf(before) + tmp2 : (after != null ? String.valueOf(tmp2) + after : tmp2));
                        ++i;
                    }
                }
                this.linePos = -1;
            }
            if (this.lines != null) {
                String str = null;
                while (str == null && this.lines.length > ++this.linePos) {
                    str = this.lines[this.linePos];
                    if (!this.testCurrent(str, false, this.startPosition, this.endPosition)) {
                        str = null;
                        continue;
                    }
                    ++this.lineNumber;
                }
                return str;
            }
        } else if (this.newLine) {
            ++this.lineNumber;
            this.newLine = false;
            return this.currentLine;
        }
        return null;
    }

    public MetadataFilterSet getParent() {
        return this.parent;
    }

    public void setOrder(int position) {
        this.order = position;
    }

    public static enum TestMode {
        current,
        ancestor,
        both;

    }
}

