/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata.internal;

import com.stambia.jdbc.driver.file.fileMetadata.internal.InternalColumn;
import com.stambia.jdbc.driver.file.fileMetadata.internal.Messages;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public abstract class FileColumn
extends InternalColumn {
    String name;
    int type;
    static String file_name = "file_name";
    static String file_absolute_path = "file_absolute_path";
    static String file_canonical_path = "file_canonical_path";
    static String file_path = "file_path";
    static String file_total_space = "file_total_space";
    static String file_usable_space = "file_usable_space";
    static String file_free_space = "file_free_space";
    static String file_can_execute = "file_can_execute";
    static String file_can_read = "file_can_read";
    static String file_can_write = "file_can_write";
    static String file_is_absolute = "file_is_absolute";
    static String file_is_file = "file_is_file";
    static String file_is_directory = "file_is_directory";
    static String file_exists = "file_exists";
    static String file_is_hidden = "file_is_hidden";
    static String file_length = "file_length";
    static String file_last_modified = "file_last_modified";
    static String file_parent_path = "file_parent_path";
    static String file_parent_absolute_path = "file_parent_absolute_path";
    static String file_parent_canonical_path = "file_parent_canonical_path";
    static String file_parent_name = "file_parent_name";
    static String file_parent_can_write = "file_parent_can_write";
    static Map<String, InternalColumn> registry = new HashMap<String, InternalColumn>();
    public static FileColumn fileNameColumn = new FileColumn(file_name, 12){

        @Override
        public Object getObject(File file) {
            if (file != null) {
                return file.getName();
            }
            return null;
        }
    };
    public static FileColumn fileAbsoluthPathColumn = new FileColumn(file_absolute_path, 12){

        @Override
        public Object getObject(File file) {
            return file.getAbsolutePath();
        }
    };
    static FileColumn fileCanonicalPathColumn = new FileColumn(file_canonical_path, 12){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getCanonicalPath();
        }
    };
    public static FileColumn filePathColumn = new FileColumn(file_path, 12){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getPath();
        }
    };
    static FileColumn fileTotalSpaceColumn = new FileColumn(file_total_space, -5){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getTotalSpace();
        }
    };
    static FileColumn fileUsableSpaceColumn = new FileColumn(file_usable_space, -5){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getUsableSpace();
        }
    };
    static FileColumn fileFreeSpaceColumn = new FileColumn(file_free_space, -5){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getFreeSpace();
        }
    };
    static FileColumn fileCanExecuteColumn = new FileColumn(file_can_execute, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.canExecute();
        }
    };
    static FileColumn fileCanReadColumn = new FileColumn(file_can_read, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.canRead();
        }
    };
    static FileColumn fileCanWriteColumn = new FileColumn(file_can_write, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.canWrite();
        }
    };
    static FileColumn fileIsAbsoluthColumn = new FileColumn(file_is_absolute, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.isAbsolute();
        }
    };
    static FileColumn fileIsFileColumn = new FileColumn(file_is_file, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.isFile();
        }
    };
    static FileColumn fileIsDirectoryColumn = new FileColumn(file_is_directory, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.isDirectory();
        }
    };
    static FileColumn fileExistsColumn = new FileColumn(file_exists, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.exists();
        }
    };
    static FileColumn fileIsHiddenColumn = new FileColumn(file_is_hidden, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.isHidden();
        }
    };
    static FileColumn fileLengthColumn = new FileColumn(file_length, -5){

        @Override
        public Object getObject(File file) throws IOException {
            return file.length();
        }
    };
    static FileColumn fileLastModifiedColumn = new FileColumn(file_last_modified, 93){

        @Override
        public Object getObject(File file) throws IOException {
            return new Timestamp(file.lastModified());
        }
    };
    static FileColumn fileParentNameColumn = new FileColumn(file_parent_name, 12){

        @Override
        public Object getObject(File file) {
            return file.getParentFile().getName();
        }
    };
    public static FileColumn fileParentAbsoluthPathColumn = new FileColumn(file_parent_absolute_path, 12){

        @Override
        public Object getObject(File file) {
            return file.getParentFile().getAbsolutePath();
        }
    };
    static FileColumn fileParentCanonicalPathColumn = new FileColumn(file_parent_canonical_path, 12){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getParentFile().getCanonicalPath();
        }
    };
    public static FileColumn fileParentPathColumn = new FileColumn(file_parent_path, 12){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getParentFile().getPath();
        }
    };
    private static FileColumn fileParentCanWrite = new FileColumn(file_parent_can_write, 16){

        @Override
        public Object getObject(File file) throws IOException {
            return file.getParentFile().canWrite();
        }
    };

    public FileColumn(String name, int type) {
        this.name = name;
        this.type = type;
        registry.put(name, this);
    }

    public static InternalColumn getColumn(String name) {
        return registry.get(name);
    }

    protected abstract Object getObject(File var1) throws Throwable;

    private Object _getObject(File file) throws Throwable {
        if (file != null) {
            return this.getObject(file);
        }
        return file;
    }

    public String getString(File file) throws Throwable {
        Object o = this._getObject(file);
        if (o instanceof String) {
            return (String)o;
        }
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public Date getDate(File file) throws Throwable {
        Object o = this._getObject(file);
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Timestamp) {
            return new Date(((Timestamp)o).getTime());
        }
        if (o != null) {
            throw new SQLException(String.valueOf(o.toString()) + Messages.getString("FileColumn.0"));
        }
        return null;
    }

    public Boolean getBoolean(File file) throws Throwable {
        Object o = this._getObject(file);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o != null) {
            throw new SQLException(String.valueOf(o.toString()) + Messages.getString("FileColumn.1"));
        }
        return null;
    }

    public Timestamp getTimestamp(File file) throws Throwable {
        Object o = this._getObject(file);
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o != null) {
            throw new SQLException(String.valueOf(o.toString()) + Messages.getString("FileColumn.2"));
        }
        return null;
    }

    public Long getLong(File file) throws Throwable {
        Object o = this._getObject(file);
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o != null) {
            throw new SQLException(String.valueOf(o.toString()) + Messages.getString("FileColumn.3"));
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

