/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.tools;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class StbScriptEngineManager
extends ScriptEngineManager {
    static ScriptEngineFactory sunFactory;

    static {
        try {
            Class<?> clazz = Class.forName("com.sun.script.javascript.RhinoScriptEngineFactory");
            sunFactory = (ScriptEngineFactory)clazz.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public StbScriptEngineManager(ClassLoader loader) {
        super(loader);
    }

    public StbScriptEngineManager() {
    }

    private ScriptEngine sunEmbended() {
        return sunFactory.getScriptEngine();
    }

    private ScriptEngine rhinoNonJdk() {
        ScriptEngine engine = super.getEngineByName("rhino-nonjdk");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return engine;
    }

    private ScriptEngine nashornRhinoCompat() {
        ScriptEngine engine = super.getEngineByName("nashorn");
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        try {
            engine.eval("function  println( str){print(str);};load('nashorn:mozilla_compat.js')");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        return engine;
    }

    public ScriptEngine other(String engineName) {
        ScriptEngine engine = super.getEngineByName(engineName);
        Bindings bindings = engine.getBindings(100);
        bindings.clear();
        return engine;
    }

    @Override
    public ScriptEngine getEngineByName(String engineName) {
        if (engineName.equals("rhino")) {
            if (sunFactory != null) {
                return this.sunEmbended();
            }
            return this.rhinoNonJdk();
        }
        if (engineName.equals("rhino-nonjdk")) {
            return this.rhinoNonJdk();
        }
        if (engineName.equals("nashorn-rhino")) {
            return this.nashornRhinoCompat();
        }
        return this.other(engineName);
    }
}

