/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.reverse;

import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.MdNodeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CompareContentProvider
implements ITreeContentProvider {
    private IncrementalReverser.DefaulteverseMatchingStrategy nodeMatchingMode;
    public static final Comparator<MdDiffNode> comparator = new Comparator<MdDiffNode>(){
        MdNodeComparator mdNodeComparator = new MdNodeComparator();

        @Override
        public int compare(MdDiffNode o1, MdDiffNode o2) {
            MdNode node1 = o1.getOldNode() == null ? o1.getNewNode() : o1.getOldNode();
            MdNode node2 = o2.getOldNode() == null ? o2.getNewNode() : o2.getOldNode();
            return this.mdNodeComparator.compare((Object)node1, (Object)node2);
        }
    };

    public CompareContentProvider(IncrementalReverser.DefaulteverseMatchingStrategy nodeMatchingMode) {
        this.nodeMatchingMode = nodeMatchingMode;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> children = new ArrayList();
        if (parentElement instanceof MdDiffNode) {
            MdDiffNode currentDiff = (MdDiffNode)parentElement;
            if (currentDiff.getChildren().isEmpty()) {
                if (currentDiff.getState() == MdDiffNode.State.NEW) {
                    MdNode node = currentDiff.getNewNode();
                    for (MdNode childNode : node.getNode()) {
                        children.add(new MdDiffNode(currentDiff, null, childNode, currentDiff.isIgnorePosition()));
                    }
                } else if (currentDiff.getState() == MdDiffNode.State.OLD) {
                    MdNode node = currentDiff.getOldNode();
                    for (MdNode childNode : node.getNode()) {
                        children.add(new MdDiffNode(currentDiff, childNode, null, currentDiff.isIgnorePosition()));
                    }
                } else {
                    MdNode newNode = currentDiff.getNewNode();
                    MdNode oldNode = currentDiff.getOldNode();
                    ArrayList<MdNode> handledFromNew = new ArrayList<MdNode>();
                    for (MdNode oldChild : oldNode.getNode()) {
                        MdNode newChild = null;
                        if (this.nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByName) {
                            newChild = newNode.getNodeByName(oldChild.getDefType(), oldChild.getName());
                        } else if (this.nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition) {
                            newChild = newNode.getNodeByPosition(oldChild.getDefType(), oldChild.getPosition().intValue());
                        }
                        if (newChild != null) {
                            handledFromNew.add(newChild);
                        }
                        children.add(new MdDiffNode(currentDiff, oldChild, newChild, currentDiff.isIgnorePosition()));
                    }
                    for (MdNode newChild : newNode.getNode()) {
                        if (handledFromNew.contains(newChild)) continue;
                        MdNode oldChild = null;
                        if (this.nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByName) {
                            oldChild = oldNode.getNodeByName(newChild.getDefType(), newChild.getName());
                        } else if (this.nodeMatchingMode == IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition) {
                            oldChild = oldNode.getNodeByPosition(newChild.getDefType(), newChild.getPosition().intValue());
                        }
                        children.add(new MdDiffNode(currentDiff, oldChild, newChild, currentDiff.isIgnorePosition()));
                    }
                }
                Collections.sort(children, comparator);
            } else {
                children = currentDiff.getChildren();
            }
            return children.toArray(new Object[children.size()]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof MdDiffNode) {
            return ((MdDiffNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MdDiffNode) {
            return ((MdDiffNode)element).hasChildren();
        }
        return false;
    }
}

