/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.reverse;

import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class CompareLabelProvider
extends LabelProvider
implements ILabelProvider,
IColorProvider,
IFontProvider {
    private AdapterFactoryLabelProvider delegate;
    public static Color red = new Color(null, 255, 0, 0);
    public static Color blue = new Color(null, 0, 0, 255);
    public static Color orange = new Color(null, 255, 140, 0);

    public CompareLabelProvider() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.delegate = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
    }

    public Image getImage(Object element) {
        if (element instanceof MdDiffNode) {
            MdDiffNode node = (MdDiffNode)element;
            if (node.getState() == MdDiffNode.State.NEW) {
                return this.delegate.getImage((Object)node.getNewNode());
            }
            if (node.getState() == MdDiffNode.State.OLD) {
                return this.delegate.getImage((Object)node.getOldNode());
            }
            if (node.getNewNode().getDefType().equals(node.getOldNode().getDefType())) {
                return this.delegate.getImage((Object)node.getOldNode());
            }
            return null;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof MdDiffNode) {
            MdDiffNode node = (MdDiffNode)element;
            if (node.getState() == MdDiffNode.State.NEW) {
                return "+ " + this.delegate.getText((Object)node.getNewNode());
            }
            if (node.getState() == MdDiffNode.State.OLD) {
                return this.delegate.getText((Object)node.getOldNode());
            }
            String s = "";
            if (node.getState() == MdDiffNode.State.UPDATED) {
                s = "* ";
            }
            if (node.getNewNode().getDefType().equals(node.getOldNode().getDefType())) {
                return String.valueOf(s) + this.delegate.getText((Object)node.getOldNode());
            }
            return String.valueOf(s) + this.delegate.getText((Object)node.getOldNode()) + " | " + this.delegate.getText((Object)node.getNewNode());
        }
        return "";
    }

    public Color getForeground(Object element) {
        MdDiffNode node;
        if (element instanceof MdDiffNode && (node = (MdDiffNode)element).getState() == MdDiffNode.State.NONE) {
            return Display.getDefault().getSystemColor(15);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof MdDiffNode) {
            MdDiffNode node = (MdDiffNode)element;
            if (node.getState() == MdDiffNode.State.NEW) {
                return MdDiffNodeUI.myFontBold;
            }
            if (node.getState() == MdDiffNode.State.UPDATED) {
                return MdDiffNodeUI.myFontItalic;
            }
            if (node.getState() == MdDiffNode.State.NONE && node.getChildrenState() != 0) {
                return MdDiffNodeUI.myFontItalic;
            }
        }
        return null;
    }
}

