/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.reverse;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.presentation.Messages;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MdDiffNode {
    private MdNode oldNode;
    private MdNode newNode;
    private State state;
    private MdDiffNode parent;
    private boolean ignorePosition;
    private List<MdDiffNode> children = new ArrayList<MdDiffNode>();
    private int childrenStates = 0;
    public static int HAS_NEW = 2;
    public static int HAS_OLD = 4;
    public static int HAS_UPDATE = 8;
    private String tooltip = null;

    private boolean attributeEquals(MdNode n1, MdNode n2, Collection<String> ignoredAttributeCodes) {
        for (Attribute a : n1.getAttribute()) {
            if (ignoredAttributeCodes != null && ignoredAttributeCodes.contains(a.getDefType())) continue;
            Attribute nA = n2.getAttributeByCode(a.getDefType());
            if (nA == null) {
                boolean skip = false;
                Property p = a.getTechProperty();
                if (p != null) {
                    if (p.isUnbounded()) {
                        if (a.getValues().isEmpty() || a.getRefs().isEmpty() || a.getValueEntry().isEmpty()) {
                            skip = true;
                        }
                    } else if (p.getType() == PropertyType.REFERENCE) {
                        if (a.getRef() == null) {
                            skip = true;
                        }
                    } else {
                        boolean bl = skip = a.getValue() == null || a.getValue().isEmpty();
                    }
                }
                if (skip) continue;
            }
            if (nA == null) {
                return false;
            }
            Property p = a.getTechProperty();
            if (p == null) continue;
            if (p.isUnbounded()) {
                if (p.isKeyValue()) {
                    Set k1 = a.getValueEntry().keySet();
                    Set k2 = nA.getValueEntry().keySet();
                    if (k1.size() == k2.size()) {
                        if (k1.containsAll(k2)) {
                            Collection v1 = a.getValueEntry().values();
                            Collection v2 = nA.getValueEntry().values();
                            if (v1.size() == v2.size()) {
                                if (v1.containsAll(v2)) continue;
                                return false;
                            }
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                if (p.getType() == PropertyType.REFERENCE) {
                    if (a.getRefs().size() == nA.getRefs().size()) {
                        if (a.getRefs().containsAll((Collection)nA.getRefs())) continue;
                        return false;
                    }
                    return false;
                }
                if (a.getValues().size() == nA.getValues().size()) {
                    return a.getValues().containsAll((Collection)nA.getValues());
                }
                return false;
            }
            if (!(p.getType() == PropertyType.REFERENCE ? a.getRef() != nA.getRef() : nA.getValue() != null && (a.getValue() == null || !a.getValue().equals(nA.getValue())))) continue;
            return false;
        }
        return true;
    }

    public MdDiffNode(MdDiffNode parent, MdNode oldNode, MdNode newNode, Collection<String> ignoredAttributeCodes, boolean ignorePosition) {
        this.ignorePosition = ignorePosition;
        this.oldNode = oldNode;
        this.newNode = newNode;
        this.parent = parent;
        if (oldNode == null) {
            this.state = State.NEW;
        } else if (newNode == null) {
            this.state = State.OLD;
            StringBuffer buf = new StringBuffer();
            Map s = EcoreUtil.CrossReferencer.find(Collections.singleton(oldNode));
            for (EObject k : s.keySet()) {
                Collection c = (Collection)s.get(k);
                if (c == null) continue;
                for (EStructuralFeature.Setting set : c) {
                    EReference ref;
                    if (!(set.getEStructuralFeature() instanceof EReference) || (ref = (EReference)set.getEStructuralFeature()).isContainer() || ref.isContainment()) continue;
                    buf.append(String.valueOf(Messages.MdDiffNode_0) + (k instanceof MdNode ? ((MdNode)k).getName() : ((Attribute)k).getName()) + "\n");
                }
            }
            if (((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getDependencyHelper().hasUsage((EObject)oldNode)) {
                buf.append(Messages.MdDiffNode_2);
            }
            if (buf.length() > 0) {
                this.tooltip = buf.toString();
            }
        } else {
            boolean attributesEquals;
            this.state = State.NONE;
            boolean bl = attributesEquals = this.attributeEquals(oldNode, newNode, ignoredAttributeCodes) && this.attributeEquals(newNode, oldNode, ignoredAttributeCodes);
            if (!ignorePosition && attributesEquals && (oldNode.getPosition() != null && !oldNode.getPosition().equals(newNode.getPosition()) || newNode.getPosition() != null && !newNode.getPosition().equals(oldNode.getPosition()))) {
                attributesEquals = false;
            }
            if (!attributesEquals) {
                this.state = State.UPDATED;
            }
        }
        if (parent != null) {
            parent.children.add(this);
            parent.updateChildState(this.state);
        }
    }

    public boolean isIgnorePosition() {
        return this.ignorePosition;
    }

    public MdDiffNode(MdDiffNode parent, MdNode oldNode, MdNode newNode, boolean ignorePosition) {
        this(parent, oldNode, newNode, null, ignorePosition);
    }

    void updateChildState(State state) {
        switch (state) {
            case NEW: {
                this.childrenStates |= HAS_NEW;
                break;
            }
            case OLD: {
                this.childrenStates |= HAS_OLD;
                break;
            }
            case UPDATED: {
                this.childrenStates |= HAS_UPDATE;
            }
        }
        if (this.parent != null) {
            this.parent.updateChildState(state);
        }
    }

    public int getChildrenState() {
        return this.childrenStates;
    }

    public List<MdDiffNode> getChildren() {
        return this.children;
    }

    public State getState() {
        return this.state;
    }

    public MdDiffNode getParent() {
        return this.parent;
    }

    public MdNode getOldNode() {
        return this.oldNode;
    }

    public MdNode getNewNode() {
        return this.newNode;
    }

    public String getLabel() {
        String res = null;
        switch (this.state) {
            case NEW: {
                res = this.newNode.getName();
                break;
            }
            case OLD: {
                res = this.oldNode.getName();
                break;
            }
            case NONE: {
                res = this.newNode.getName();
                break;
            }
            case UPDATED: {
                res = this.newNode.getName().equals(this.oldNode.getName()) ? this.newNode.getName() : String.valueOf(this.oldNode.getName()) + "|" + this.newNode.getName();
            }
        }
        return res == null ? "" : res;
    }

    public boolean hasChildren() {
        boolean res = false;
        if (this.newNode != null) {
            boolean bl = res = res || !this.newNode.getNode().isEmpty();
        }
        if (this.oldNode != null) {
            res = res || !this.oldNode.getNode().isEmpty();
        }
        return res;
    }

    public List<MdDiffNode> getDescendance() {
        ArrayList<MdDiffNode> l = new ArrayList<MdDiffNode>();
        l.addAll(this.children);
        for (MdDiffNode n : this.children) {
            l.addAll(n.getDescendance());
        }
        return l;
    }

    public List<MdDiffNode> getAncestors() {
        ArrayList<MdDiffNode> l = new ArrayList<MdDiffNode>();
        if (this.getParent() != null) {
            l.add(this.getParent());
            l.addAll(this.getParent().getAncestors());
        }
        return l;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Stream<MdDiffNode> stream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(MdDiffNode::stream));
    }

    public static enum State {
        NEW,
        OLD,
        UPDATED,
        NONE;

    }
}

