/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.reverse;

import com.indy.md.ui.editor.reverse.CompareContentProvider;
import com.indy.md.ui.editor.reverse.CompareLabelProvider;
import com.indy.md.ui.editor.reverse.DecoratingColumLabelProvider;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.presentation.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class MdDiffNodeUI {
    private static final String SEARCH_TEXT = Messages.MdDiffNodeUI_0;
    private static final Color frColor = new Color(null, 128, 128, 128);
    private static Image checkAll;
    private static Image uncheckAll;
    private static Image collapseAll;
    private static Image expandAll;
    private static Image nextImage;
    public static Font myFontBold;
    public static Font myFontItalic;
    private CheckboxTreeViewer viewer;
    private Text search;
    private String searchText;
    private Button next;
    private ToolBar toolbar;
    private boolean showNoDiffItems = false;
    protected TabbedPropertySheetWidgetFactory widgetFactory;
    private Stack<ListIterator<MdDiffNode>> searchStack = new Stack();
    private boolean clearing = false;
    private boolean hasHit = false;
    private ViewerHelper viewerHelper = new ViewerHelper();

    static {
        myFontBold = new Font((Device)Display.getDefault(), new FontData(Display.getDefault().getSystemFont().getFontData()[0].getName(), Display.getDefault().getSystemFont().getFontData()[0].getHeight(), 1));
        myFontItalic = new Font((Device)Display.getDefault(), new FontData(Display.getDefault().getSystemFont().getFontData()[0].getName(), Display.getDefault().getSystemFont().getFontData()[0].getHeight(), 2));
        try {
            nextImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui.intro/icons/full/elcl16/forward_nav.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            collapseAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/elcl16/collapseall.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            expandAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/elcl16/expandall.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            checkAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/checkAll.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            uncheckAll = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.diagram/icons/obj16/uncheckall.png")).createImage();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public MdDiffNodeUI(TabbedPropertySheetWidgetFactory widgetFactory) {
        this.widgetFactory = widgetFactory;
    }

    public CheckboxTreeViewer createViewer(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 268503840);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setAutoExpandLevel(-1);
        this.viewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider(new CompareLabelProvider(), null));
        this.viewer.setContentProvider((IContentProvider)new CompareContentProvider(IncrementalReverser.DefaulteverseMatchingStrategy.ByName));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                this.checkDescendance(event.getChecked(), (MdDiffNode)event.getElement());
                if (event.getChecked() && ((MdDiffNode)event.getElement()).getState() == MdDiffNode.State.NEW) {
                    MdDiffNode p = ((MdDiffNode)event.getElement()).getParent();
                    while (p != null && p.getState() == MdDiffNode.State.NEW) {
                        MdDiffNodeUI.this.viewer.setChecked((Object)p, true);
                        p = p.getParent();
                    }
                }
            }

            private void checkDescendance(boolean checked, MdDiffNode element) {
                List<MdDiffNode> nodes = element.getDescendance();
                for (MdDiffNode n : nodes) {
                    if (checked && n.getState() == MdDiffNode.State.NONE && n.getChildrenState() == 0) continue;
                    MdDiffNodeUI.this.viewer.setChecked((Object)n, checked);
                }
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!MdDiffNodeUI.this.showNoDiffItems) {
                    return ((MdDiffNode)element).getState() != MdDiffNode.State.NONE || ((MdDiffNode)element).getChildrenState() != 0;
                }
                return true;
            }
        });
        this.viewer.getControl().forceFocus();
        this.customizeTree();
        return this.viewer;
    }

    private void customizeTree() {
        this.viewer.getTree().addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                Object data = item.getData();
                if (data == null) {
                    return;
                }
                int flag = -1;
                try {
                    flag = ((MdDiffNode)item.getData()).getChildrenState();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                event.gc.setFont(myFontBold);
                int k = event.gc.stringExtent((String)"*").x;
                if ((flag & MdDiffNode.HAS_NEW) != 0) {
                    event.width += k + 2;
                }
                if ((flag & MdDiffNode.HAS_OLD) != 0) {
                    event.width += k + 2;
                }
                if ((flag & MdDiffNode.HAS_UPDATE) != 0) {
                    event.width += k + 2;
                }
            }
        });
        this.viewer.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                if (item.getData() == null) {
                    return;
                }
                if (((MdDiffNode)item.getData()).getState() == MdDiffNode.State.OLD) {
                    Rectangle r = item.getTextBounds(0);
                    String s = ((ILabelProvider)MdDiffNodeUI.this.viewer.getLabelProvider()).getText(item.getData());
                    Point k = event.gc.stringExtent(s);
                    event.gc.drawLine(r.x, r.y + r.height / 2, r.x + k.x, r.y + r.height / 2);
                }
            }
        });
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MdDiffNode node;
                if (event.detail == 32 && (node = (MdDiffNode)((TreeItem)event.item).getData()).getState() == MdDiffNode.State.NONE && node.getChildrenState() == 0) {
                    event.doit = false;
                    event.detail = 0;
                    event.type = 0;
                    try {
                        MdDiffNodeUI.this.viewer.getTree().setRedraw(false);
                        TreeItem item = (TreeItem)event.item;
                        item.setChecked(!item.getChecked());
                    }
                    finally {
                        MdDiffNodeUI.this.viewer.getTree().setRedraw(true);
                    }
                }
            }
        });
    }

    public Composite createOptionComposite(Composite parent) {
        Composite c = this.widgetFactory.createComposite(parent);
        c.setLayout((Layout)new GridLayout());
        Button b = this.widgetFactory.createButton(c, Messages.MdDiffNodeUI_7, 32);
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.showNoDiffItems = ((Button)e.widget).getSelection();
                MdDiffNodeUI.this.viewer.refresh();
                MdDiffNodeUI.this.viewer.expandAll();
            }
        });
        return c;
    }

    public Composite createSearchBar(Composite parent) {
        Group group = this.widgetFactory.createGroup(parent, Messages.MdDiffNodeUI_8);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)group.getLayout()).verticalSpacing = 0;
        ((GridLayout)group.getLayout()).marginTop = 5;
        ((GridLayout)group.getLayout()).marginBottom = 0;
        ((GridLayout)group.getLayout()).marginHeight = 0;
        this.search = this.widgetFactory.createText((Composite)group, SEARCH_TEXT, 2048);
        this.search.setLayoutData((Object)new GridData(4, 2, true, false));
        this.search.setForeground(frColor);
        this.search.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Text l = (Text)e.widget;
                if (l.getText().trim().isEmpty()) {
                    l.setForeground(frColor);
                    MdDiffNodeUI.this.clearing = true;
                    l.setText(SEARCH_TEXT);
                    MdDiffNodeUI.this.clearing = false;
                }
            }

            public void focusGained(FocusEvent e) {
                Text l = (Text)e.widget;
                if (frColor.equals((Object)l.getForeground())) {
                    l.setForeground(null);
                    MdDiffNodeUI.this.clearing = true;
                    l.setText("");
                    MdDiffNodeUI.this.clearing = false;
                }
            }
        });
        this.search.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Text l = (Text)e.widget;
                l.selectAll();
            }
        });
        this.search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MdDiffNodeUI.this.hasHit = false;
                if (frColor.equals((Object)((Text)e.widget).getForeground())) {
                    MdDiffNodeUI.this.searchText = null;
                } else {
                    MdDiffNodeUI.this.searchText = ((Text)e.widget).getText();
                }
                MdDiffNodeUI.this.next.setEnabled(false);
                MdDiffNodeUI.this.searchStack.clear();
                MdDiffNode root = null;
                Object input = MdDiffNodeUI.this.viewer.getInput();
                if (input instanceof MdDiffNode) {
                    root = (MdDiffNode)input;
                } else if (input instanceof Collection) {
                    root = (MdDiffNode)((Collection)input).stream().findFirst().get();
                } else if (input instanceof Object[]) {
                    root = (MdDiffNode)((Object[])input)[0];
                }
                if (root != null) {
                    MdDiffNodeUI.this.searchStack.add(root.getChildren().listIterator());
                    if (!MdDiffNodeUI.this.clearing) {
                        MdDiffNodeUI.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                        MdDiffNodeUI.this.selectNext();
                        MdDiffNodeUI.this.next.setEnabled(true);
                    }
                }
            }
        });
        this.next = this.widgetFactory.createButton((Composite)group, "", 8);
        this.next.setLayoutData((Object)new GridData(3, 2, false, false));
        this.next.setImage(nextImage);
        this.next.setToolTipText(Messages.MdDiffNodeUI_11);
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.selectNext();
            }
        });
        return group;
    }

    public Composite createToolbar(Composite parent) {
        ToolBar tb;
        Composite c = this.widgetFactory.createComposite(parent, 0);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(3, false));
        ((GridLayout)c.getLayout()).marginBottom = 0;
        ((GridLayout)c.getLayout()).marginHeight = 0;
        ((GridLayout)c.getLayout()).marginLeft = 0;
        ((GridLayout)c.getLayout()).marginRight = 0;
        ((GridLayout)c.getLayout()).marginTop = 0;
        ((GridLayout)c.getLayout()).marginWidth = 0;
        c.setBackground(parent.getShell().getDisplay().getSystemColor(32));
        Label l = this.widgetFactory.createLabel(c, "");
        l.setBackground(parent.getShell().getDisplay().getSystemColor(32));
        l.setLayoutData((Object)new GridData(1, 4, true, false));
        this.toolbar = tb = new ToolBar(c, 0x800100);
        tb.setBackground(parent.getShell().getDisplay().getSystemColor(32));
        tb.setLayoutData((Object)new GridData(3, 4, false, false));
        ToolItem it = new ToolItem(this.toolbar, 8);
        it.setImage(expandAll);
        it.setToolTipText(Messages.MdDiffNodeUI_13);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.viewer.expandAll();
            }
        });
        it = new ToolItem(this.toolbar, 8);
        it.setImage(collapseAll);
        it.setToolTipText(Messages.MdDiffNodeUI_14);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.viewer.collapseAll();
            }
        });
        it = new ToolItem(this.toolbar, 8);
        it.setImage(checkAll);
        it.setToolTipText(Messages.MdDiffNodeUI_15);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.viewer.setAllChecked(true);
            }
        });
        it = new ToolItem(this.toolbar, 8);
        it.setImage(uncheckAll);
        it.setToolTipText(Messages.MdDiffNodeUI_16);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MdDiffNodeUI.this.viewer.setAllChecked(false);
            }
        });
        return c;
    }

    protected boolean match(MdDiffNode it) {
        if (this.searchText != null && !this.searchText.isEmpty()) {
            if (!this.showNoDiffItems && it.getChildrenState() == 0 && it.getState() == MdDiffNode.State.NONE) {
                return false;
            }
            return ((ILabelProvider)this.viewer.getLabelProvider()).getText((Object)it).toLowerCase().contains(this.searchText.toLowerCase());
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean selectNext() {
        block7: {
            while (true) {
                if (!this.searchStack.isEmpty()) ** GOTO lbl32
                return false;
lbl-1000:
                // 1 sources

                {
                    it = this.searchStack.peek();
                    while (it.hasNext()) {
                        n = (MdDiffNode)it.next();
                        visible = true;
                        var7_7 = this.viewer.getFilters();
                        var6_6 = var7_7.length;
                        var5_5 = 0;
                        while (var5_5 < var6_6) {
                            f = var7_7[var5_5];
                            if (!f.select((Viewer)this.viewer, (Object)n.getParent(), (Object)n)) {
                                visible = false;
                                break;
                            }
                            ++var5_5;
                        }
                        if (visible && this.match(n)) {
                            this.viewer.reveal((Object)n);
                            this.viewer.setSelection((ISelection)new StructuredSelection((Object)n));
                            this.searchStack.push(n.getChildren().listIterator());
                            this.hasHit = true;
                            return true;
                        }
                        if (!visible) continue;
                        this.searchStack.push(n.getChildren().listIterator());
                        it = this.searchStack.peek();
                    }
                    this.searchStack.pop();
lbl32:
                    // 2 sources

                    ** while (!this.searchStack.isEmpty())
                }
lbl33:
                // 1 sources

                if (!this.hasHit) break;
                if (MessageDialog.openQuestion((Shell)this.search.getShell(), (String)Messages.MdDiffNodeUI_17, (String)Messages.MdDiffNodeUI_18)) {
                    root = (MdDiffNode)this.viewer.getInput();
                    this.searchStack.add(root.getChildren().listIterator());
                    continue;
                }
                break block7;
                break;
            }
            return false;
        }
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.next.setEnabled(false);
        this.search.setForeground(MdDiffNodeUI.frColor);
        this.searchText = null;
        this.clearing = true;
        this.search.setText(MdDiffNodeUI.SEARCH_TEXT);
        this.clearing = false;
        this.viewer.getTree().forceFocus();
        return false;
    }

    public DiffState computeDiffState(IVisitorHandler handler, List<String> defTypeToDelete) throws Exception {
        HashSet<MdDiffNode> diffs = new HashSet<MdDiffNode>();
        ArrayList<MdDiffNode> toDelete = new ArrayList<MdDiffNode>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            if (((MdDiffNode)node).getState() == MdDiffNode.State.OLD) {
                if (defTypeToDelete.contains(((MdDiffNode)node).getOldNode().getDefType())) {
                    diffs.add((MdDiffNode)node);
                    toDelete.add((MdDiffNode)node);
                }
            } else {
                diffs.add((MdDiffNode)node);
            }
            ++n2;
        }
        ArrayList<MdDiffNode> ancestors = new ArrayList<MdDiffNode>();
        for (MdDiffNode n3 : diffs) {
            List<MdDiffNode> l = n3.getAncestors();
            if (ancestors.isEmpty()) {
                ancestors.addAll(l);
                continue;
            }
            ancestors.retainAll(l);
        }
        Iterator i = ancestors.iterator();
        block4: while (i.hasNext()) {
            MdDiffNode n4 = (MdDiffNode)i.next();
            for (MdDiffNode k : diffs) {
                if (k == n4 || !k.getDescendance().contains(n4)) continue;
                i.remove();
                continue block4;
            }
        }
        Visitor v = new Visitor(diffs, toDelete);
        v.handler = handler;
        MdNode tree = null;
        try {
            Object o = this.viewer.getInput();
            if (o instanceof MdDiffNode) {
                tree = v.visit((MdDiffNode)o);
            } else if (o instanceof Object[]) {
                tree = v.visit((MdDiffNode)((Object[])o)[0]);
            }
            ArrayList<MdNode> mdNodeToDelete = new ArrayList<MdNode>();
            for (MdDiffNode n5 : toDelete) {
                mdNodeToDelete.add(n5.getOldNode());
            }
            TreeIterator it = tree.eAllContents();
            while (it.hasNext()) {
                EObject n6 = (EObject)it.next();
                if (!(n6 instanceof MdNode)) continue;
                ((MdNode)n6).setSubstituteContainer(null);
            }
            return new DiffState(tree, mdNodeToDelete);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public ViewerHelper getViewerHelper() {
        return this.viewerHelper;
    }

    public class DiffState {
        private MdNode resultingMdNode;
        private List<MdNode> nodesToDelete;

        private DiffState(MdNode resultingMdNode, List<MdNode> nodesToDelete) {
            this.resultingMdNode = resultingMdNode;
            this.nodesToDelete = nodesToDelete;
        }

        public MdNode getResultingMdNode() {
            return this.resultingMdNode;
        }

        public List<MdNode> getNodesToDelete() {
            return this.nodesToDelete;
        }
    }

    public static interface IVisitorHandler {
        public void handleVisited(MdDiffNode var1, MdNode var2);
    }

    public class ViewerHelper {
        public void setInput(Object input) {
            MdDiffNodeUI.this.viewer.setInput(input);
            Stream<Object> stream = null;
            if (input instanceof MdDiffNode) {
                stream = ((MdDiffNode)input).stream();
            } else if (input instanceof Object[]) {
                stream = Stream.of((Object[])input);
                stream = stream.flatMap(MdDiffNode::stream);
            }
            if (stream != null) {
                Object[] elementToCheckArray = stream.filter(d -> d.getState() == MdDiffNode.State.NEW || d.getParent() == input && d.getState() == MdDiffNode.State.UPDATED).toArray();
                MdDiffNodeUI.this.viewer.setCheckedElements(elementToCheckArray);
            }
        }

        public void setAllChecked(boolean all) {
            MdDiffNodeUI.this.viewer.setSubtreeChecked(MdDiffNodeUI.this.viewer.getInput(), all);
        }

        public Object[] getCheckedElements() {
            return MdDiffNodeUI.this.viewer.getCheckedElements();
        }

        public void setExpandedState(MdDiffNode element, boolean expanded) {
            MdDiffNodeUI.this.viewer.setExpandedState((Object)element, expanded);
        }
    }

    protected class Visitor {
        public List<MdDiffNode> toReverse = new ArrayList<MdDiffNode>();
        private IVisitorHandler handler;
        private List<MdDiffNode> toDelete;

        public Visitor(Collection<MdDiffNode> toApply, List<MdDiffNode> toDelete) {
            this.toDelete = toDelete;
            this.toReverse.addAll(toApply);
        }

        public MdNode visit(MdDiffNode node) {
            MdNode res = null;
            switch (node.getState()) {
                case NEW: {
                    if (this.toReverse.contains(node)) {
                        res = node.getNewNode();
                        break;
                    }
                    res = null;
                    break;
                }
                case OLD: {
                    if (this.toDelete.contains(node)) {
                        res = null;
                        break;
                    }
                    res = node.getOldNode();
                    break;
                }
                default: {
                    res = this.toReverse.contains(node) ? node.getNewNode() : node.getOldNode();
                }
            }
            if (res != null) {
                MdNode t = res.copy(1);
                t.setSubstituteContainer(res.getSubstituteContainer());
                t.setDefType(res.getDefType());
                res = t;
                if (this.handler != null) {
                    this.handler.handleVisited(node, t);
                }
                for (MdDiffNode n : node.getChildren()) {
                    MdNode c = this.visit(n);
                    if (c == null) continue;
                    res.getNode().add((Object)c);
                }
            }
            return res;
        }
    }
}

