/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.md.ui.editor.ui.ReverseProvider;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.ReverseUtil;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.presentation.custom.ReverseMdNodeContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class MdControl {
    private Object control;
    private boolean enable = true;
    private String defCodeFeature;
    private ReverseProvider provider;
    private Set<String> codeProvider;
    private int type;
    public static final int STRING_COMBO_TYPE = 1;
    public static final int REF_COMBO_TYPE = 2;
    public static final int REF_TREE_TYPE = 3;
    public static final int STRING_TYPE = 4;

    public Object getControl() {
        return this.control;
    }

    public String getDefCodeFeature() {
        return this.defCodeFeature;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnable(boolean state) {
        this.enable = state;
    }

    public Set<String> getCodeProvider() {
        return this.codeProvider;
    }

    public static CheckboxTreeViewer createTreeViewer(Composite parent, int style, boolean tree) {
        CheckboxTreeViewer ctv = new CheckboxTreeViewer(parent);
        ctv.getTree().setLayoutData((Object)new GridData(1808));
        ctv.setContentProvider((IContentProvider)new ReverseMdNodeContentProvider(tree));
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ctv.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        return ctv;
    }

    public void reverse(MdReverse reverse, Object connection, MdNode parent) throws ReverseException {
        this.reverse(reverse, connection, parent, null);
    }

    public void reverse(MdReverse reverse, Object connection, MdNode parent, Map<String, Boolean> incrementalDelete) throws ReverseException {
        this.reverse(reverse, connection, parent, incrementalDelete, null);
    }

    public void reverse(MdReverse reverse, Object connection, MdNode parent, Map<String, Boolean> incrementalDelete, Map<String, IncrementalReverser.IReverseMatchingStrategy> reverseMode) throws ReverseException {
        Object[] obj = new Object[1];
        Object object = this.getSelection();
        if (object instanceof List) {
            ArrayList<MdNode> toRemove = new ArrayList<MdNode>();
            List roots = (List)((Viewer)this.control).getInput();
            if (roots != null) {
                for (MdNode _p : roots) {
                    if (((List)object).contains(_p)) {
                        TreeIterator it = _p.eAllContents();
                        while (it.hasNext()) {
                            EObject _obj = (EObject)it.next();
                            if (!(_obj instanceof MdNode) || ((List)object).contains(_obj)) continue;
                            toRemove.add((MdNode)_obj);
                        }
                        continue;
                    }
                    toRemove.add(_p);
                }
                for (MdNode node : toRemove) {
                    if (roots.remove(node)) continue;
                    ((MdNode)node.eContainer()).getNode().remove((Object)node);
                }
                obj = roots.toArray();
            } else {
                obj = null;
            }
        } else {
            obj[0] = this.getSelection();
        }
        if (obj != null) {
            ReverseUtil.incrementalReverse((MdNode)parent, (MdReverse)reverse, (Object)connection, (Object[])obj, incrementalDelete, reverseMode);
        }
    }

    public MdControl(Object control, String defCodeFeature, int type) {
        this.control = control;
        this.defCodeFeature = defCodeFeature;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    private List<MdNode> select(TreeItem item) {
        if (item.getChecked()) {
            ArrayList<MdNode> list = new ArrayList<MdNode>();
            list.add((MdNode)item.getData());
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                list.addAll(this.select(child));
                ++n2;
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public Object getSelection() {
        if (this.control instanceof Viewer) {
            ISelection selection = ((Viewer)this.control).getSelection();
            if (selection != null) {
                if (this.control instanceof CheckboxTreeViewer) {
                    ArrayList<MdNode> list = new ArrayList<MdNode>();
                    TreeItem[] treeItemArray = ((CheckboxTreeViewer)this.control).getTree().getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        list.addAll(this.select(item));
                        ++n2;
                    }
                    return list;
                }
                if (selection instanceof IStructuredSelection) {
                    Object obj = ((IStructuredSelection)selection).getFirstElement();
                    return obj;
                }
            }
        } else if (this.control instanceof Text) {
            return ((Text)this.control).getText();
        }
        return null;
    }

    public void setProvider(ReverseProvider provider) {
        if (this.control instanceof ComboViewer) {
            ((ComboViewer)this.control).addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MdControl.this.provider.handleEvent();
                }
            });
        }
        if (this.control instanceof CheckboxTreeViewer) {
            ((CheckboxTreeViewer)this.control).addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MdControl.this.provider.handleEvent();
                }
            });
        }
        this.provider = provider;
    }

    public void addCodeProvider(String code) {
        if (this.codeProvider == null) {
            this.codeProvider = new HashSet<String>();
        }
        this.codeProvider.add(code);
    }

    public void handleInputChanged(List elements) {
    }

    public void refreshControl(List elements) {
        block7: {
            block8: {
                if (!this.isEnabled()) break block7;
                if (this.type != 2) break block8;
                MdNode selection = (MdNode)this.getSelection();
                ((Viewer)this.control).setInput((Object)elements);
                this.handleInputChanged(elements);
                if (this.type != 2 || selection == null) break block7;
                int i = 0;
                for (MdNode node : (List)((ComboViewer)this.control).getInput()) {
                    if (node.getName().equals(selection.getName())) {
                        ((ComboViewer)this.control).getCombo().select(i);
                    }
                    ++i;
                }
                break block7;
            }
            if (this.type == 3) {
                ((Viewer)this.control).setInput((Object)elements);
                this.handleInputChanged(elements);
            } else if (this.type == 1) {
                String selection = (String)this.getSelection();
                ((ComboViewer)this.control).setInput((Object)elements);
                this.handleInputChanged(elements);
                int i = 0;
                for (String value : (List)((ComboViewer)this.control).getInput()) {
                    if (value.equals(selection)) {
                        ((ComboViewer)this.control).getCombo().select(i);
                    }
                    ++i;
                }
            }
        }
    }
}

