/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.md.ui.editor.ui.Messages;
import com.semarchy.xdi.designer.core.services.IEvaluationConfigurationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.presentation.custom.ReverseMdNodeContentProvider;
import com.stambia.md.util.MdAttributeReader;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class MdControlManager {
    public static final int DISPLAY_NAME = 0;
    public static final int VALUE = 1;
    public static final int NAME = 3;
    List<MdControl> list = new ArrayList<MdControl>();
    private HashSet<MdControlListener> setListener;
    public static final String COMBO_NULL_VALUE = "<unset>";

    public MdControl addControl(Control control, MdNode parent, String propertyCode, int mode, boolean record, boolean rawValue) {
        return this.addControl(control, parent, propertyCode, mode, record, true, null, rawValue);
    }

    public MdControl addControl(Control control, MdNode parent, String propertyCode, int mode, boolean record, String overrideDefaultValue, boolean rawValue) {
        return this.addControl(control, parent, propertyCode, mode, record, true, overrideDefaultValue, rawValue);
    }

    public void refresh(String xmlName) {
        for (MdControl md : this.list) {
            if (xmlName == null || md.xmlName == null || !xmlName.equals(md.xmlName)) continue;
            md.refreshValues(false);
        }
    }

    public MdControl addControl(Control control, MdNode parent, String propertyCode, int mode, boolean record, boolean mandatory, final String overrideDefaultValue, boolean rawValue) {
        MdControl md = new MdControl(this, control, parent, propertyCode, mode, record, mandatory, rawValue){

            @Override
            String getDefaultvalue() {
                if (overrideDefaultValue != null) {
                    return overrideDefaultValue;
                }
                return super.getDefaultvalue();
            }

            @Override
            public void handleModification(Object oldValue, Object newValue) {
                MdControlEvent event = new MdControlEvent();
                event.control = this.control;
                event.node = this.parent;
                event.xmlName = this.xmlName;
                event.mdControl = this;
                event.oldValue = oldValue;
                event.newValue = newValue;
                this.handleEvent(event);
            }
        };
        this.list.add(md);
        return md;
    }

    private void handleEvent(MdControlEvent event) {
        if (this.setListener != null) {
            for (MdControlListener listener : this.setListener) {
                listener.modifyValue(event);
            }
        }
    }

    public void init() {
        for (MdControl mdc : this.list) {
            mdc.init();
        }
    }

    public void addListener(MdControlListener listener) {
        if (this.setListener == null) {
            this.setListener = new HashSet();
        }
        this.setListener.add(listener);
    }

    public void removeListener(MdControlListener listener) {
        if (this.setListener != null) {
            this.setListener.remove(listener);
        }
    }

    public static void initComboViewerProvider(ComboViewer cv) {
        cv.setContentProvider((IContentProvider)new ReverseMdNodeContentProvider(false));
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        cv.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        cv.setSorter(new ViewerSorter());
    }

    public boolean isComplete() {
        for (MdControl mdc : this.list) {
            if (mdc.isComplete()) continue;
            return false;
        }
        return true;
    }

    public static interface DataLoader {
        public List loadData();
    }

    public abstract class MdControl {
        String xmlName;
        MdNode parent;
        Control control;
        private int mode;
        private Property p;
        private List values;
        private Object value;
        private boolean record;
        private boolean checkIfIsmandatory;
        private boolean isMandatory;
        private boolean rawValue;
        private DataLoader dataLoader;
        private StructuredViewer viewer;

        String getDefaultvalue() {
            if (this.p != null) {
                return this.p.getDefaultValue();
            }
            return null;
        }

        public void setMandatory(boolean isMandatory) {
            this.isMandatory = isMandatory;
        }

        public MdControl(Control _control, MdNode parent, String xmlName, int mode, boolean record, boolean rawValue) {
            this.init(_control, parent, xmlName, mode, record, true, rawValue);
        }

        public void setViewer(StructuredViewer v) {
            this.viewer = v;
        }

        private void init(Control _control, MdNode parent, String xmlName, int mode, boolean record, boolean checkIfIsmandatory, boolean rawValue) {
            this.record = record;
            this.parent = parent;
            this.xmlName = xmlName;
            this.mode = mode;
            this.control = _control;
            this.checkIfIsmandatory = checkIfIsmandatory;
            this.rawValue = rawValue;
            this.addListener();
            if (xmlName != null) {
                this.p = parent.getLevel().getAttributeByXmlName(xmlName);
            }
        }

        public MdControl(Control _control, MdNode parent, String xmlName, int mode, boolean record, boolean mandatory, boolean rawValue) {
            this.init(_control, parent, xmlName, mode, record, mandatory, rawValue);
        }

        public abstract void handleModification(Object var1, Object var2);

        protected void addListener() {
            if (this.control instanceof Combo) {
                ((Combo)this.control).addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Object oldValue = MdControl.this.value;
                        if (MdControl.this.p.getType().equals((Object)PropertyType.REFERENCE)) {
                            MdControl.this.value = ((IStructuredSelection)MdControl.this.viewer.getSelection()).getFirstElement();
                        } else {
                            int index = ((Combo)MdControl.this.control).getSelectionIndex();
                            if (index >= 0) {
                                MdControl.this.value = ((Combo)MdControl.this.control).getItem(index);
                            } else {
                                MdControl.this.value = null;
                            }
                        }
                        if (MdControl.this.value == MdControlManager.COMBO_NULL_VALUE) {
                            MdControl.this.value = null;
                        }
                        if (MdControl.this.record) {
                            MdControl.this.record();
                        }
                        MdControl.this.handleModification(oldValue, MdControl.this.value);
                    }
                });
                if ((this.control.getStyle() & 8) == 0) {
                    ((Combo)this.control).addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            Object oldValue = MdControl.this.value;
                            MdControl.this.value = ((Combo)MdControl.this.control).getText();
                            if (MdControl.this.value.equals("")) {
                                MdControl.this.value = null;
                            }
                            if (MdControl.this.record) {
                                MdControl.this.record();
                            }
                            MdControl.this.handleModification(oldValue, MdControl.this.value);
                        }
                    });
                }
            } else if (this.control instanceof Text) {
                ((Text)this.control).addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Object oldValue = MdControl.this.value;
                        MdControl.this.value = ((Text)MdControl.this.control).getText();
                        if (MdControl.this.value.equals("")) {
                            MdControl.this.value = null;
                        }
                        if (MdControl.this.record) {
                            MdControl.this.record();
                        }
                        MdControl.this.handleModification(oldValue, MdControl.this.value);
                    }
                });
            } else if (this.control instanceof Button) {
                ((Button)this.control).addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Object oldValue = MdControl.this.value;
                        MdControl.this.value = String.valueOf(((Button)MdControl.this.control).getSelection());
                        if (MdControl.this.value.equals("")) {
                            MdControl.this.value = "false";
                        }
                        if (MdControl.this.record) {
                            MdControl.this.record();
                        }
                        MdControl.this.handleModification(oldValue, MdControl.this.value);
                    }
                });
            }
        }

        public void record() {
            if (this.viewer != null && this.p.getType().equals((Object)PropertyType.REFERENCE)) {
                this.parent.setRefAttribute(this.p.getCode(), (EObject)this.value, true);
            } else if (this.record && this.mode != 0) {
                Configuration conf = this.parent.findConfiguration(((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
                conf = conf == null ? this.parent : conf;
                String newValue = null;
                if (this.control instanceof Text) {
                    newValue = ((Text)this.control).getText();
                } else if (this.control instanceof Combo) {
                    newValue = (String)this.value;
                } else if (this.control instanceof Button) {
                    newValue = String.valueOf(((Button)this.control).getSelection());
                }
                String oldValue = conf instanceof MdNode && this.mode == 3 ? conf.getName() : conf.getAttributeValueByXmlName(this.xmlName);
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)this.parent);
                    RecordingCommand rc = new RecordingCommand(ted){

                        protected void doExecute() {
                            Configuration conf = MdControl.this.parent.findConfiguration(((IEvaluationConfigurationService)E4InjectorHelper.getService(IEvaluationConfigurationService.class)).getCurrentConfigurationName());
                            conf = conf == null ? MdControl.this.parent : conf;
                            Object _value = MdControl.this.value;
                            if (_value != null && MdControl.this.p != null && MdControl.this.p.getType().equals((Object)PropertyType.PASSWORD)) {
                                try {
                                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                                    String encrypt = semaphoreManager.setSemaphore(true, (String)_value);
                                    _value = encrypt;
                                }
                                catch (OtherExceptionI e) {
                                    e.printStackTrace();
                                }
                            }
                            if (MdControl.this.p != null) {
                                if (MdControl.this.control instanceof Text) {
                                    conf.setAttribute(MdControl.this.p.getCode(), (String)_value, false);
                                } else if (MdControl.this.control instanceof Combo) {
                                    conf.setAttribute(MdControl.this.p.getCode(), (String)_value, false);
                                } else if (MdControl.this.control instanceof Button) {
                                    conf.setAttribute(MdControl.this.p.getCode(), (String)_value, false);
                                }
                            } else if (conf instanceof MdNode && MdControl.this.mode == 3 && MdControl.this.control instanceof Text) {
                                conf.setName((String)_value);
                            }
                        }
                    };
                    rc.setLabel(String.valueOf(Messages.MdControlManager_6) + this.xmlName);
                    ted.getCommandStack().execute((Command)rc);
                }
            }
        }

        public boolean isComplete() {
            if (this.checkIfIsmandatory && this.isMandatory()) {
                return this.value != null && !this.value.equals("") || this.control instanceof Label;
            }
            return true;
        }

        public boolean isEnable() {
            if (this.p != null) {
                return Util.isXpathConditionValided((Element)this.parent, (String)this.p.getXpathCondition());
            }
            return true;
        }

        public boolean isMandatory() {
            return this.isEnable() && (this.p != null && !this.p.isNullable() || this.isMandatory);
        }

        public void setDataLoader(DataLoader dataLoader) {
            this.dataLoader = dataLoader;
        }

        public void initWithDataLoader() {
            if (this.rawValue) {
                try {
                    this.value = MdAttributeReader.readAttribute((String)this.p.getCode(), (MdNode)this.parent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.value = this.parent.evaluateMdString("@" + this.xmlName);
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            if (this.dataLoader != null && this.mode == 1) {
                this.values = this.dataLoader.loadData();
                if (this.value != null && !this.values.contains(this.value)) {
                    this.values.add(this.value);
                }
                this.refreshValues(true);
            }
        }

        public Object getValue() {
            return this.value;
        }

        private void setValues() throws XPathExpressionException {
            switch (this.mode) {
                case 0: {
                    if (this.p == null) break;
                    this.value = this.p.getDisplayName();
                    break;
                }
                case 1: {
                    if (this.p.getType().equals((Object)PropertyType.REFERENCE)) {
                        Attribute attr = this.parent.getAttributeByXmlName(this.xmlName);
                        this.value = attr != null ? attr.getRef() : null;
                    } else {
                        if (this.rawValue) {
                            try {
                                this.value = MdAttributeReader.readAttribute((String)this.p.getCode(), (MdNode)this.parent);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.value = this.parent.evaluateMdString("@" + this.xmlName);
                            if (this.value != null && this.p.getType().equals((Object)PropertyType.PASSWORD)) {
                                try {
                                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                                    String decrypt = semaphoreManager.getStringAsciiInfo((String)this.value);
                                    this.value = decrypt;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (this.value == null || "".equals(this.value)) {
                            this.value = this.getDefaultvalue();
                        }
                    }
                    Object _values = null;
                    this.values = null;
                    if (this.control instanceof Combo && this.p != null && this.p.getMdXpathAccess() != null && !this.p.getMdXpathAccess().equals("")) {
                        _values = this.parent.evaluateMdSet(this.p.getMdXpathAccess());
                    }
                    if (!(_values instanceof List)) break;
                    this.values = (List)_values;
                    break;
                }
                case 3: {
                    this.value = this.parent.getName();
                }
            }
        }

        private void refreshValues(boolean record) {
            Object tmpValue = this.value;
            if (this.values != null && this.values.size() > 0) {
                ArrayList<Object> _values;
                if (this.p.getType().equals((Object)PropertyType.REFERENCE) && this.viewer != null) {
                    _values = new ArrayList<Object>();
                    for (Object md : this.values) {
                        _values.add((MdNode)md);
                    }
                    this.viewer.setInput(_values);
                } else if (this.control instanceof Combo) {
                    _values = new ArrayList();
                    for (Object attr : this.values) {
                        if (attr instanceof Attribute) {
                            _values.add(((Attribute)attr).getStringValue());
                            continue;
                        }
                        _values.add(attr.toString());
                    }
                    Collections.sort(_values);
                    ((Combo)this.control).setItems(_values.toArray(new String[_values.size()]));
                }
            }
            this.value = tmpValue;
            if (this.value != null) {
                if (this.viewer != null && this.p.getType().equals((Object)PropertyType.REFERENCE)) {
                    StructuredSelection d = new StructuredSelection(this.value);
                    this.viewer.setSelection((ISelection)d);
                } else if (this.control instanceof Text) {
                    ((Text)this.control).setText((String)this.value);
                } else if (this.control instanceof Label) {
                    ((Label)this.control).setText((String)this.value);
                } else if (this.control instanceof Combo) {
                    ((Combo)this.control).setText((String)this.value);
                } else if (this.control instanceof Button) {
                    if ((String)this.value != null && ((String)this.value).equals("true")) {
                        ((Button)this.control).setSelection(true);
                    } else {
                        ((Button)this.control).setSelection(false);
                    }
                }
                if (record) {
                    this.record();
                }
            }
        }

        public void init() {
            Object oldValue = this.value;
            try {
                this.setValues();
                this.refreshValues(true);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            this.handleModification(oldValue, this.value);
        }

        public void setValue(Object value) {
            this.value = value;
            this.record();
        }

        public void setEnable(boolean enabled) {
            this.control.setEnabled(enabled);
        }
    }

    public class MdControlEvent {
        public MdNode node;
        public Control control;
        public String xmlName;
        public MdControl mdControl;
        public Object oldValue;
        public Object newValue;
    }

    public static interface MdControlListener {
        public void modifyValue(MdControlEvent var1);
    }
}

