/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.md.ui.editor.ui.Messages;
import com.stambia.jdbc.driver.file.tools.StbScriptEngineManager;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.md.presentation.internal.Xml2MdConverter;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.emf.ecore.EObject;

public class ScriptEngineReverseAPI {
    public void reverseWithScript(List<ReverseScript> queryScript, List<MdNode> result) throws Exception {
        try {
            if (queryScript.size() > 0) {
                for (MdNode node : result) {
                    this.visitMdNodeForScriptReverse(node, queryScript);
                }
            }
        }
        catch (ScriptException e) {
            MdEditorPlugin.getPlugin().getLog().warn(Messages.ScriptEngineReverseAPI_4, (Throwable)e);
            e.printStackTrace();
        }
    }

    private void visitMdNodeForScriptReverse(MdNode current, List<ReverseScript> queryScript) throws Exception {
        for (ReverseScript rs : queryScript) {
            if (!rs.levels.contains(current.getDefType())) continue;
            rs.execute(current);
        }
        for (MdNode child : current.getNode()) {
            this.visitMdNodeForScriptReverse(child, queryScript);
        }
    }

    static enum ATTRIBUTE_MATCH_MODE {
        ADD_ATTRIBUTE_REVERSE_MODE,
        ADD_ATTRIBUTE_CODE_MODE,
        ADD_ATTRIBUTE_DISPLAY_MODE,
        ADD_ATTRIBUTE_XML_NAME_MODE;

    }

    public static final class NodeWrapper {
        MdNode node;
        MdNode realNode;

        public NodeWrapper(MdNode realNode2) {
            this.realNode = realNode2;
        }

        public NodeWrapper setAttributeValue(String code, String value) {
            this.addStringAttribute(this.node, value, code, ATTRIBUTE_MATCH_MODE.ADD_ATTRIBUTE_XML_NAME_MODE);
            return this;
        }

        public void copyAttributes() {
            for (Attribute a : this.realNode.getAttribute()) {
                this.addStringAttribute(this.node, a.getValue(), a.getDefType(), ATTRIBUTE_MATCH_MODE.ADD_ATTRIBUTE_CODE_MODE);
            }
        }

        public String evaluateXpath(String expression) throws XPathExpressionException {
            String string;
            EObject oldSubstitute = null;
            try {
                String s;
                if (this.node.eContainer() == null) {
                    oldSubstitute = this.node.getSubstituteContainer();
                    this.node.setSubstituteContainer(this.realNode.eContainer());
                }
                string = s = this.node.evaluate(expression);
            }
            catch (Throwable throwable) {
                this.node.setSubstituteContainer(oldSubstitute);
                throw throwable;
            }
            this.node.setSubstituteContainer(oldSubstitute);
            return string;
        }

        public String evaluateXpathOnRealNode(String expression) throws XPathExpressionException {
            return this.realNode.evaluate(expression);
        }

        public NodeWrapper reverseWithXml(InputStream xmlStream) throws Exception {
            Xml2MdConverter xm = new Xml2MdConverter();
            xm.convert(xmlStream, this.node, this.node.getLevel());
            return this;
        }

        public NodeWrapper getParent() throws Exception {
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = (MdNode)this.node.eContainer();
            return nw;
        }

        public NodeWrapper createNode(String level, String name) throws Exception {
            MdNode _node = MdFactoryHelper.createMdNode((String)level);
            this.node.getNode().add((Object)_node);
            _node.setName(name);
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = _node;
            return nw;
        }

        private void addStringAttribute(MdNode _node, String value, String type, ATTRIBUTE_MATCH_MODE mode) {
            if (_node != null) {
                Level _level = _node.getLevel(this.realNode.getSubstituteResource());
                if (value != null && _node != null && type != null) {
                    List<Property> props = null;
                    Property _prop = null;
                    if (_level != null) {
                        switch (mode) {
                            case ADD_ATTRIBUTE_REVERSE_MODE: {
                                props = Util.getPropertyByReverseCode((Level)_level, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_CODE_MODE: {
                                _prop = Util.getPropertyByCode((Level)_level, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_DISPLAY_MODE: {
                                _prop = Util.getPropertyByDisplayName((Level)_level, (String)type);
                                break;
                            }
                            case ADD_ATTRIBUTE_XML_NAME_MODE: {
                                _prop = Util.getPropertyByXmlName((Level)_level, (String)type);
                            }
                        }
                    }
                    if (props == null) {
                        props = new ArrayList();
                        if (_prop != null) {
                            props.add(_prop);
                        }
                    }
                    for (Property prop : props) {
                        Attribute attr = _node.getAttributeByFullCode(prop.getFullCode());
                        if (attr == null) {
                            attr = MdFactory.eINSTANCE.createAttribute();
                            attr.setDefType(prop.getFullCode());
                            _node.getAttribute().add((Object)attr);
                        }
                        if (prop.isUnbounded()) {
                            attr.getValues().add((Object)value);
                            continue;
                        }
                        attr.setValue(value);
                    }
                }
            }
        }
    }

    public static final class ReverseScript {
        public List<String> levels = new ArrayList<String>();
        public String language;
        public String script;
        MdNode realNode;
        ScriptEngine engine;

        public ReverseScript(MdNode realNode) {
            this.realNode = realNode;
        }

        void init(MdNode node) throws Exception {
            if (this.engine == null) {
                StbScriptEngineManager sem = new StbScriptEngineManager();
                this.engine = sem.getEngineByName(this.language);
            }
            Bindings bindings = this.engine.getContext().getBindings(100);
            NodeWrapper nw = new NodeWrapper(this.realNode);
            nw.node = node;
            bindings.put("__node__", (Object)nw);
        }

        void execute(MdNode node) throws Exception {
            this.init(node);
            this.engine.eval(this.script);
        }
    }
}

