/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.editor.ui;

import com.indy.md.ui.editor.ui.Messages;
import com.indy.md.ui.editor.ui.XPathAction;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.tech.Tech;
import com.stambia.tech.XpathExpression;
import java.net.URL;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class XPathExpressionPopup
extends AbstractHandler {
    private static final String P_SHELL_WIDTH;
    private static final String P_SHELL_HEIGHT;
    private static final String P_SHELL_X;
    private static final String P_SHELL_Y;
    private static final Image IMG_FOCUS;
    private static final ImageDescriptor IMG;
    private static AdapterFactoryLabelProvider labelProvider;
    @Inject
    @Preference(nodePath="com.indy.md.ui.editor")
    private IEclipsePreferences preferences;
    private MdNode mdNode;
    private String searchName = null;
    TableViewer table;
    Shell shell;

    static {
        block11: {
            block9: {
                P_SHELL_WIDTH = XPathExpressionPopup.class + ".shell.width";
                P_SHELL_HEIGHT = XPathExpressionPopup.class + ".shell.height";
                P_SHELL_X = XPathExpressionPopup.class + ".shell.x";
                P_SHELL_Y = XPathExpressionPopup.class + ".shell.y";
                Image img = null;
                try {
                    try {
                        img = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.cross.ui/icons/16x16/reveal_16x16.png")).createImage();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        IMG_FOCUS = img;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    IMG_FOCUS = img;
                    throw throwable;
                }
                IMG_FOCUS = img;
            }
            ImageDescriptor desc = null;
            try {
                try {
                    desc = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/magnifier.png"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IMG = desc;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IMG = desc;
                throw throwable;
            }
            IMG = desc;
        }
        labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    public XPathExpressionPopup() {
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)EclipseContextFactory.create());
    }

    private void openShell() {
        final Shell sh = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2160);
        try {
            sh.setImage(Window.getDefaultImages()[0]);
        }
        catch (Exception exception) {}
        sh.setLayout((Layout)new FillLayout());
        this.createContent((Composite)sh);
        sh.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                XPathExpressionPopup.this.preferences.putInt(P_SHELL_WIDTH, sh.getSize().x);
                XPathExpressionPopup.this.preferences.putInt(P_SHELL_HEIGHT, sh.getSize().y);
                XPathExpressionPopup.this.preferences.putInt(P_SHELL_X, sh.getLocation().x);
                XPathExpressionPopup.this.preferences.putInt(P_SHELL_Y, sh.getLocation().y);
                try {
                    XPathExpressionPopup.this.preferences.flush();
                }
                catch (BackingStoreException e1) {
                    e1.printStackTrace();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        int x = this.preferences.getInt(P_SHELL_X, 0);
        int y = this.preferences.getInt(P_SHELL_Y, 0);
        if (x > 0 && y > 0) {
            sh.setLocation(x, y);
        }
        this.shell = sh;
        sh.setSize(this.preferences.getInt(P_SHELL_WIDTH, 400), this.preferences.getInt(P_SHELL_HEIGHT, 300));
        sh.open();
        this.fillData(this.mdNode);
        int i = 0;
        while (i < this.table.getTable().getColumnCount()) {
            this.table.getTable().getColumn(i).pack();
            ++i;
        }
    }

    private void fillData(MdNode node) {
        this.mdNode = node;
        ArrayList xp = new ArrayList();
        xp.addAll(Util.getXpathExpressions((Configuration)this.mdNode));
        xp.addAll(Util.getglobalXpathExpressions((Configuration)this.mdNode));
        ArrayList<XPathExpressionWrapper> input = new ArrayList<XPathExpressionWrapper>(xp.size());
        for (XpathExpression x : xp) {
            for (QName q : x.getCode()) {
                input.add(new XPathExpressionWrapper(q, x));
            }
        }
        this.table.setInput(input);
        this.shell.setText(String.format(Messages.XPathExpressionPopup_0, labelProvider.getText((Object)node)));
        this.shell.setImage(labelProvider.getImage((Object)node));
    }

    private void createToolBar(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        c.setLayout((Layout)gl);
        final Text searchBar = new Text(c, 2048);
        searchBar.setToolTipText(Messages.XPathExpressionPopup_8);
        searchBar.setLayoutData((Object)new GridData(4, 1, true, false));
        searchBar.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPathExpressionPopup.this.searchName = searchBar.getText();
                XPathExpressionPopup.this.table.refresh();
            }
        });
        ToolBar tb = new ToolBar(c, 0x800100);
        tb.setLayoutData((Object)new GridData(3, 1, false, false));
        ToolItem it = new ToolItem(tb, 8);
        it.setImage(IMG_FOCUS);
        it.setToolTipText(Messages.XPathExpressionPopup_9);
        it.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IWorkbenchPart p = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    IStructuredSelection ss = (IStructuredSelection)p.getSite().getSelectionProvider().getSelection();
                    if (!ss.isEmpty()) {
                        Object element = ss.getFirstElement();
                        MdNode n = null;
                        if (element instanceof MdNode) {
                            n = (MdNode)element;
                        } else {
                            element = Platform.getAdapterManager().getAdapter(element, EObject.class);
                            if (element instanceof MdNode) {
                                n = (MdNode)element;
                            }
                        }
                        if (n != null) {
                            XPathExpressionPopup.this.fillData(n);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    private void createContent(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        this.createToolBar(main);
        Label l = new Label(main, 64);
        l.setText(Messages.XPathExpressionPopup_10);
        l.setLayoutData((Object)new GridData(4, 4, true, false));
        this.table = new TableViewer(main, 68096);
        this.table.getControl().setLayoutData((Object)new GridData(4, 4, false, true));
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.getTable().setLinesVisible(true);
        this.table.getTable().setHeaderVisible(true);
        this.table.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((XPathExpressionWrapper)e1).label.compareTo(((XPathExpressionWrapper)e2).label);
            }
        });
        this.table.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (XPathExpressionPopup.this.searchName == null || XPathExpressionPopup.this.searchName.isEmpty()) {
                    return true;
                }
                return ((XPathExpressionWrapper)element).getLabel().toLowerCase().contains(XPathExpressionPopup.this.searchName.toLowerCase());
            }
        });
        TableViewerColumn col1 = new TableViewerColumn(this.table, 16384);
        col1.getColumn().setText(Messages.XPathExpressionPopup_11);
        col1.getColumn().setWidth(100);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((XPathExpressionWrapper)element).getLabel();
            }

            public void update(ViewerCell cell) {
                super.update(cell);
            }
        });
        col1 = new TableViewerColumn(this.table, 16384);
        col1.getColumn().setText(Messages.XPathExpressionPopup_12);
        col1.getColumn().setWidth(100);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((XPathExpressionWrapper)element).getContext().name();
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XPathExpressionWrapper wrapper = (XPathExpressionWrapper)XPathExpressionPopup.this.table.getStructuredSelection().getFirstElement();
                XPathAction a = new XPathAction(XPathExpressionPopup.this.mdNode, wrapper.xPath, wrapper.label, wrapper.label);
                a.run();
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection s = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (!s.isEmpty()) {
            Object o = s.getFirstElement();
            EObject eo = (EObject)Platform.getAdapterManager().getAdapter(o, EObject.class);
            if (eo instanceof MdNode) {
                this.mdNode = (MdNode)eo;
                this.openShell();
            } else {
                this.mdNode = null;
            }
        } else {
            this.mdNode = null;
        }
        return null;
    }

    static enum ExecutionContext {
        Global,
        Node;

    }

    class XPathExpressionWrapper {
        String label;
        XpathExpression xPath;
        ExecutionContext ctx;

        public XPathExpressionWrapper(QName q, XpathExpression x) {
            this.label = XPathAction.transformName(q.getLocalPart());
            this.xPath = x;
            this.ctx = x.eContainer() instanceof Tech ? ExecutionContext.Global : ExecutionContext.Node;
        }

        String getLabel() {
            return this.label;
        }

        ExecutionContext getContext() {
            return this.ctx;
        }
    }
}

